/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.AsymmetricDecryptRequest;
import com.google.cloud.kms.v1.AsymmetricDecryptResponse;
import com.google.cloud.kms.v1.AsymmetricSignRequest;
import com.google.cloud.kms.v1.AsymmetricSignResponse;
import com.google.cloud.kms.v1.CreateCryptoKeyRequest;
import com.google.cloud.kms.v1.CreateCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.CreateImportJobRequest;
import com.google.cloud.kms.v1.CreateKeyRingRequest;
import com.google.cloud.kms.v1.CryptoKey;
import com.google.cloud.kms.v1.CryptoKeyVersion;
import com.google.cloud.kms.v1.DecryptRequest;
import com.google.cloud.kms.v1.DecryptResponse;
import com.google.cloud.kms.v1.DestroyCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.EncryptRequest;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.GenerateRandomBytesRequest;
import com.google.cloud.kms.v1.GenerateRandomBytesResponse;
import com.google.cloud.kms.v1.GetCryptoKeyRequest;
import com.google.cloud.kms.v1.GetCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.GetImportJobRequest;
import com.google.cloud.kms.v1.GetKeyRingRequest;
import com.google.cloud.kms.v1.GetPublicKeyRequest;
import com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.ImportJob;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.cloud.kms.v1.KeyRing;
import com.google.cloud.kms.v1.ListCryptoKeyVersionsRequest;
import com.google.cloud.kms.v1.ListCryptoKeyVersionsResponse;
import com.google.cloud.kms.v1.ListCryptoKeysRequest;
import com.google.cloud.kms.v1.ListCryptoKeysResponse;
import com.google.cloud.kms.v1.ListImportJobsRequest;
import com.google.cloud.kms.v1.ListImportJobsResponse;
import com.google.cloud.kms.v1.ListKeyRingsRequest;
import com.google.cloud.kms.v1.ListKeyRingsResponse;
import com.google.cloud.kms.v1.MacSignRequest;
import com.google.cloud.kms.v1.MacSignResponse;
import com.google.cloud.kms.v1.MacVerifyRequest;
import com.google.cloud.kms.v1.MacVerifyResponse;
import com.google.cloud.kms.v1.PublicKey;
import com.google.cloud.kms.v1.RawDecryptRequest;
import com.google.cloud.kms.v1.RawDecryptResponse;
import com.google.cloud.kms.v1.RawEncryptRequest;
import com.google.cloud.kms.v1.RawEncryptResponse;
import com.google.cloud.kms.v1.RestoreCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.stub.GrpcKeyManagementServiceStub;
import com.google.cloud.kms.v1.stub.HttpJsonKeyManagementServiceStub;
import com.google.cloud.kms.v1.stub.KeyManagementServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class KeyManagementServiceStubSettings
extends StubSettings<KeyManagementServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloudkms").build();
    private final PagedCallSettings<ListKeyRingsRequest, ListKeyRingsResponse, KeyManagementServiceClient.ListKeyRingsPagedResponse> listKeyRingsSettings;
    private final PagedCallSettings<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyManagementServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings;
    private final PagedCallSettings<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsSettings;
    private final PagedCallSettings<ListImportJobsRequest, ListImportJobsResponse, KeyManagementServiceClient.ListImportJobsPagedResponse> listImportJobsSettings;
    private final UnaryCallSettings<GetKeyRingRequest, KeyRing> getKeyRingSettings;
    private final UnaryCallSettings<GetCryptoKeyRequest, CryptoKey> getCryptoKeySettings;
    private final UnaryCallSettings<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionSettings;
    private final UnaryCallSettings<GetPublicKeyRequest, PublicKey> getPublicKeySettings;
    private final UnaryCallSettings<GetImportJobRequest, ImportJob> getImportJobSettings;
    private final UnaryCallSettings<CreateKeyRingRequest, KeyRing> createKeyRingSettings;
    private final UnaryCallSettings<CreateCryptoKeyRequest, CryptoKey> createCryptoKeySettings;
    private final UnaryCallSettings<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionSettings;
    private final UnaryCallSettings<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionSettings;
    private final UnaryCallSettings<CreateImportJobRequest, ImportJob> createImportJobSettings;
    private final UnaryCallSettings<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeySettings;
    private final UnaryCallSettings<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionSettings;
    private final UnaryCallSettings<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionSettings;
    private final UnaryCallSettings<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionSettings;
    private final UnaryCallSettings<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionSettings;
    private final UnaryCallSettings<EncryptRequest, EncryptResponse> encryptSettings;
    private final UnaryCallSettings<DecryptRequest, DecryptResponse> decryptSettings;
    private final UnaryCallSettings<RawEncryptRequest, RawEncryptResponse> rawEncryptSettings;
    private final UnaryCallSettings<RawDecryptRequest, RawDecryptResponse> rawDecryptSettings;
    private final UnaryCallSettings<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignSettings;
    private final UnaryCallSettings<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptSettings;
    private final UnaryCallSettings<MacSignRequest, MacSignResponse> macSignSettings;
    private final UnaryCallSettings<MacVerifyRequest, MacVerifyResponse> macVerifySettings;
    private final UnaryCallSettings<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, KeyManagementServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing> LIST_KEY_RINGS_PAGE_STR_DESC = new PagedListDescriptor<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing>(){

        public String emptyToken() {
            return "";
        }

        public ListKeyRingsRequest injectToken(ListKeyRingsRequest payload, String token) {
            return ListKeyRingsRequest.newBuilder((ListKeyRingsRequest)payload).setPageToken(token).build();
        }

        public ListKeyRingsRequest injectPageSize(ListKeyRingsRequest payload, int pageSize) {
            return ListKeyRingsRequest.newBuilder((ListKeyRingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListKeyRingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListKeyRingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<KeyRing> extractResources(ListKeyRingsResponse payload) {
            return payload.getKeyRingsList();
        }
    };
    private static final PagedListDescriptor<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> LIST_CRYPTO_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey>(){

        public String emptyToken() {
            return "";
        }

        public ListCryptoKeysRequest injectToken(ListCryptoKeysRequest payload, String token) {
            return ListCryptoKeysRequest.newBuilder((ListCryptoKeysRequest)payload).setPageToken(token).build();
        }

        public ListCryptoKeysRequest injectPageSize(ListCryptoKeysRequest payload, int pageSize) {
            return ListCryptoKeysRequest.newBuilder((ListCryptoKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCryptoKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCryptoKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CryptoKey> extractResources(ListCryptoKeysResponse payload) {
            return payload.getCryptoKeysList();
        }
    };
    private static final PagedListDescriptor<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion> LIST_CRYPTO_KEY_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListCryptoKeyVersionsRequest injectToken(ListCryptoKeyVersionsRequest payload, String token) {
            return ListCryptoKeyVersionsRequest.newBuilder((ListCryptoKeyVersionsRequest)payload).setPageToken(token).build();
        }

        public ListCryptoKeyVersionsRequest injectPageSize(ListCryptoKeyVersionsRequest payload, int pageSize) {
            return ListCryptoKeyVersionsRequest.newBuilder((ListCryptoKeyVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCryptoKeyVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCryptoKeyVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CryptoKeyVersion> extractResources(ListCryptoKeyVersionsResponse payload) {
            return payload.getCryptoKeyVersionsList();
        }
    };
    private static final PagedListDescriptor<ListImportJobsRequest, ListImportJobsResponse, ImportJob> LIST_IMPORT_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListImportJobsRequest, ListImportJobsResponse, ImportJob>(){

        public String emptyToken() {
            return "";
        }

        public ListImportJobsRequest injectToken(ListImportJobsRequest payload, String token) {
            return ListImportJobsRequest.newBuilder((ListImportJobsRequest)payload).setPageToken(token).build();
        }

        public ListImportJobsRequest injectPageSize(ListImportJobsRequest payload, int pageSize) {
            return ListImportJobsRequest.newBuilder((ListImportJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListImportJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListImportJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ImportJob> extractResources(ListImportJobsResponse payload) {
            return payload.getImportJobsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListKeyRingsRequest, ListKeyRingsResponse, KeyManagementServiceClient.ListKeyRingsPagedResponse> LIST_KEY_RINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListKeyRingsRequest, ListKeyRingsResponse, KeyManagementServiceClient.ListKeyRingsPagedResponse>(){

        public ApiFuture<KeyManagementServiceClient.ListKeyRingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListKeyRingsRequest, ListKeyRingsResponse> callable, ListKeyRingsRequest request, ApiCallContext context, ApiFuture<ListKeyRingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_KEY_RINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyManagementServiceClient.ListKeyRingsPagedResponse.createAsync((PageContext<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyManagementServiceClient.ListCryptoKeysPagedResponse> LIST_CRYPTO_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyManagementServiceClient.ListCryptoKeysPagedResponse>(){

        public ApiFuture<KeyManagementServiceClient.ListCryptoKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> callable, ListCryptoKeysRequest request, ApiCallContext context, ApiFuture<ListCryptoKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CRYPTO_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyManagementServiceClient.ListCryptoKeysPagedResponse.createAsync((PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> LIST_CRYPTO_KEY_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse>(){

        public ApiFuture<KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse> callable, ListCryptoKeyVersionsRequest request, ApiCallContext context, ApiFuture<ListCryptoKeyVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CRYPTO_KEY_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse.createAsync((PageContext<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListImportJobsRequest, ListImportJobsResponse, KeyManagementServiceClient.ListImportJobsPagedResponse> LIST_IMPORT_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListImportJobsRequest, ListImportJobsResponse, KeyManagementServiceClient.ListImportJobsPagedResponse>(){

        public ApiFuture<KeyManagementServiceClient.ListImportJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListImportJobsRequest, ListImportJobsResponse> callable, ListImportJobsRequest request, ApiCallContext context, ApiFuture<ListImportJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_IMPORT_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyManagementServiceClient.ListImportJobsPagedResponse.createAsync((PageContext<ListImportJobsRequest, ListImportJobsResponse, ImportJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, KeyManagementServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, KeyManagementServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<KeyManagementServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyManagementServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListKeyRingsRequest, ListKeyRingsResponse, KeyManagementServiceClient.ListKeyRingsPagedResponse> listKeyRingsSettings() {
        return this.listKeyRingsSettings;
    }

    public PagedCallSettings<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyManagementServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings() {
        return this.listCryptoKeysSettings;
    }

    public PagedCallSettings<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsSettings() {
        return this.listCryptoKeyVersionsSettings;
    }

    public PagedCallSettings<ListImportJobsRequest, ListImportJobsResponse, KeyManagementServiceClient.ListImportJobsPagedResponse> listImportJobsSettings() {
        return this.listImportJobsSettings;
    }

    public UnaryCallSettings<GetKeyRingRequest, KeyRing> getKeyRingSettings() {
        return this.getKeyRingSettings;
    }

    public UnaryCallSettings<GetCryptoKeyRequest, CryptoKey> getCryptoKeySettings() {
        return this.getCryptoKeySettings;
    }

    public UnaryCallSettings<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionSettings() {
        return this.getCryptoKeyVersionSettings;
    }

    public UnaryCallSettings<GetPublicKeyRequest, PublicKey> getPublicKeySettings() {
        return this.getPublicKeySettings;
    }

    public UnaryCallSettings<GetImportJobRequest, ImportJob> getImportJobSettings() {
        return this.getImportJobSettings;
    }

    public UnaryCallSettings<CreateKeyRingRequest, KeyRing> createKeyRingSettings() {
        return this.createKeyRingSettings;
    }

    public UnaryCallSettings<CreateCryptoKeyRequest, CryptoKey> createCryptoKeySettings() {
        return this.createCryptoKeySettings;
    }

    public UnaryCallSettings<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionSettings() {
        return this.createCryptoKeyVersionSettings;
    }

    public UnaryCallSettings<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionSettings() {
        return this.importCryptoKeyVersionSettings;
    }

    public UnaryCallSettings<CreateImportJobRequest, ImportJob> createImportJobSettings() {
        return this.createImportJobSettings;
    }

    public UnaryCallSettings<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeySettings() {
        return this.updateCryptoKeySettings;
    }

    public UnaryCallSettings<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionSettings() {
        return this.updateCryptoKeyVersionSettings;
    }

    public UnaryCallSettings<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionSettings() {
        return this.updateCryptoKeyPrimaryVersionSettings;
    }

    public UnaryCallSettings<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionSettings() {
        return this.destroyCryptoKeyVersionSettings;
    }

    public UnaryCallSettings<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionSettings() {
        return this.restoreCryptoKeyVersionSettings;
    }

    public UnaryCallSettings<EncryptRequest, EncryptResponse> encryptSettings() {
        return this.encryptSettings;
    }

    public UnaryCallSettings<DecryptRequest, DecryptResponse> decryptSettings() {
        return this.decryptSettings;
    }

    public UnaryCallSettings<RawEncryptRequest, RawEncryptResponse> rawEncryptSettings() {
        return this.rawEncryptSettings;
    }

    public UnaryCallSettings<RawDecryptRequest, RawDecryptResponse> rawDecryptSettings() {
        return this.rawDecryptSettings;
    }

    public UnaryCallSettings<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignSettings() {
        return this.asymmetricSignSettings;
    }

    public UnaryCallSettings<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptSettings() {
        return this.asymmetricDecryptSettings;
    }

    public UnaryCallSettings<MacSignRequest, MacSignResponse> macSignSettings() {
        return this.macSignSettings;
    }

    public UnaryCallSettings<MacVerifyRequest, MacVerifyResponse> macVerifySettings() {
        return this.macVerifySettings;
    }

    public UnaryCallSettings<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesSettings() {
        return this.generateRandomBytesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, KeyManagementServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public KeyManagementServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcKeyManagementServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonKeyManagementServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudkms";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudkms.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudkms.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return KeyManagementServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeyManagementServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeyManagementServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return KeyManagementServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected KeyManagementServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listKeyRingsSettings = settingsBuilder.listKeyRingsSettings().build();
        this.listCryptoKeysSettings = settingsBuilder.listCryptoKeysSettings().build();
        this.listCryptoKeyVersionsSettings = settingsBuilder.listCryptoKeyVersionsSettings().build();
        this.listImportJobsSettings = settingsBuilder.listImportJobsSettings().build();
        this.getKeyRingSettings = settingsBuilder.getKeyRingSettings().build();
        this.getCryptoKeySettings = settingsBuilder.getCryptoKeySettings().build();
        this.getCryptoKeyVersionSettings = settingsBuilder.getCryptoKeyVersionSettings().build();
        this.getPublicKeySettings = settingsBuilder.getPublicKeySettings().build();
        this.getImportJobSettings = settingsBuilder.getImportJobSettings().build();
        this.createKeyRingSettings = settingsBuilder.createKeyRingSettings().build();
        this.createCryptoKeySettings = settingsBuilder.createCryptoKeySettings().build();
        this.createCryptoKeyVersionSettings = settingsBuilder.createCryptoKeyVersionSettings().build();
        this.importCryptoKeyVersionSettings = settingsBuilder.importCryptoKeyVersionSettings().build();
        this.createImportJobSettings = settingsBuilder.createImportJobSettings().build();
        this.updateCryptoKeySettings = settingsBuilder.updateCryptoKeySettings().build();
        this.updateCryptoKeyVersionSettings = settingsBuilder.updateCryptoKeyVersionSettings().build();
        this.updateCryptoKeyPrimaryVersionSettings = settingsBuilder.updateCryptoKeyPrimaryVersionSettings().build();
        this.destroyCryptoKeyVersionSettings = settingsBuilder.destroyCryptoKeyVersionSettings().build();
        this.restoreCryptoKeyVersionSettings = settingsBuilder.restoreCryptoKeyVersionSettings().build();
        this.encryptSettings = settingsBuilder.encryptSettings().build();
        this.decryptSettings = settingsBuilder.decryptSettings().build();
        this.rawEncryptSettings = settingsBuilder.rawEncryptSettings().build();
        this.rawDecryptSettings = settingsBuilder.rawDecryptSettings().build();
        this.asymmetricSignSettings = settingsBuilder.asymmetricSignSettings().build();
        this.asymmetricDecryptSettings = settingsBuilder.asymmetricDecryptSettings().build();
        this.macSignSettings = settingsBuilder.macSignSettings().build();
        this.macVerifySettings = settingsBuilder.macVerifySettings().build();
        this.generateRandomBytesSettings = settingsBuilder.generateRandomBytesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<KeyManagementServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListKeyRingsRequest, ListKeyRingsResponse, KeyManagementServiceClient.ListKeyRingsPagedResponse> listKeyRingsSettings;
        private final PagedCallSettings.Builder<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyManagementServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings;
        private final PagedCallSettings.Builder<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsSettings;
        private final PagedCallSettings.Builder<ListImportJobsRequest, ListImportJobsResponse, KeyManagementServiceClient.ListImportJobsPagedResponse> listImportJobsSettings;
        private final UnaryCallSettings.Builder<GetKeyRingRequest, KeyRing> getKeyRingSettings;
        private final UnaryCallSettings.Builder<GetCryptoKeyRequest, CryptoKey> getCryptoKeySettings;
        private final UnaryCallSettings.Builder<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionSettings;
        private final UnaryCallSettings.Builder<GetPublicKeyRequest, PublicKey> getPublicKeySettings;
        private final UnaryCallSettings.Builder<GetImportJobRequest, ImportJob> getImportJobSettings;
        private final UnaryCallSettings.Builder<CreateKeyRingRequest, KeyRing> createKeyRingSettings;
        private final UnaryCallSettings.Builder<CreateCryptoKeyRequest, CryptoKey> createCryptoKeySettings;
        private final UnaryCallSettings.Builder<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionSettings;
        private final UnaryCallSettings.Builder<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionSettings;
        private final UnaryCallSettings.Builder<CreateImportJobRequest, ImportJob> createImportJobSettings;
        private final UnaryCallSettings.Builder<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeySettings;
        private final UnaryCallSettings.Builder<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionSettings;
        private final UnaryCallSettings.Builder<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionSettings;
        private final UnaryCallSettings.Builder<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionSettings;
        private final UnaryCallSettings.Builder<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionSettings;
        private final UnaryCallSettings.Builder<EncryptRequest, EncryptResponse> encryptSettings;
        private final UnaryCallSettings.Builder<DecryptRequest, DecryptResponse> decryptSettings;
        private final UnaryCallSettings.Builder<RawEncryptRequest, RawEncryptResponse> rawEncryptSettings;
        private final UnaryCallSettings.Builder<RawDecryptRequest, RawDecryptResponse> rawDecryptSettings;
        private final UnaryCallSettings.Builder<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignSettings;
        private final UnaryCallSettings.Builder<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptSettings;
        private final UnaryCallSettings.Builder<MacSignRequest, MacSignResponse> macSignSettings;
        private final UnaryCallSettings.Builder<MacVerifyRequest, MacVerifyResponse> macVerifySettings;
        private final UnaryCallSettings.Builder<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, KeyManagementServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listKeyRingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_KEY_RINGS_PAGE_STR_FACT);
            this.listCryptoKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CRYPTO_KEYS_PAGE_STR_FACT);
            this.listCryptoKeyVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CRYPTO_KEY_VERSIONS_PAGE_STR_FACT);
            this.listImportJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_IMPORT_JOBS_PAGE_STR_FACT);
            this.getKeyRingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCryptoKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCryptoKeyVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getImportJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createKeyRingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCryptoKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCryptoKeyVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importCryptoKeyVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createImportJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCryptoKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCryptoKeyVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCryptoKeyPrimaryVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.destroyCryptoKeyVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreCryptoKeyVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.encryptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.decryptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rawEncryptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rawDecryptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.asymmetricSignSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.asymmetricDecryptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.macSignSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.macVerifySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateRandomBytesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listKeyRingsSettings, this.listCryptoKeysSettings, this.listCryptoKeyVersionsSettings, this.listImportJobsSettings, this.getKeyRingSettings, this.getCryptoKeySettings, this.getCryptoKeyVersionSettings, this.getPublicKeySettings, this.getImportJobSettings, this.createKeyRingSettings, this.createCryptoKeySettings, this.createCryptoKeyVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.importCryptoKeyVersionSettings, this.createImportJobSettings, this.updateCryptoKeySettings, this.updateCryptoKeyVersionSettings, this.updateCryptoKeyPrimaryVersionSettings, this.destroyCryptoKeyVersionSettings, this.restoreCryptoKeyVersionSettings, this.encryptSettings, this.decryptSettings, this.rawEncryptSettings, this.rawDecryptSettings, this.asymmetricSignSettings, this.asymmetricDecryptSettings, this.macSignSettings, this.macVerifySettings, this.generateRandomBytesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(KeyManagementServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listKeyRingsSettings = settings.listKeyRingsSettings.toBuilder();
            this.listCryptoKeysSettings = settings.listCryptoKeysSettings.toBuilder();
            this.listCryptoKeyVersionsSettings = settings.listCryptoKeyVersionsSettings.toBuilder();
            this.listImportJobsSettings = settings.listImportJobsSettings.toBuilder();
            this.getKeyRingSettings = settings.getKeyRingSettings.toBuilder();
            this.getCryptoKeySettings = settings.getCryptoKeySettings.toBuilder();
            this.getCryptoKeyVersionSettings = settings.getCryptoKeyVersionSettings.toBuilder();
            this.getPublicKeySettings = settings.getPublicKeySettings.toBuilder();
            this.getImportJobSettings = settings.getImportJobSettings.toBuilder();
            this.createKeyRingSettings = settings.createKeyRingSettings.toBuilder();
            this.createCryptoKeySettings = settings.createCryptoKeySettings.toBuilder();
            this.createCryptoKeyVersionSettings = settings.createCryptoKeyVersionSettings.toBuilder();
            this.importCryptoKeyVersionSettings = settings.importCryptoKeyVersionSettings.toBuilder();
            this.createImportJobSettings = settings.createImportJobSettings.toBuilder();
            this.updateCryptoKeySettings = settings.updateCryptoKeySettings.toBuilder();
            this.updateCryptoKeyVersionSettings = settings.updateCryptoKeyVersionSettings.toBuilder();
            this.updateCryptoKeyPrimaryVersionSettings = settings.updateCryptoKeyPrimaryVersionSettings.toBuilder();
            this.destroyCryptoKeyVersionSettings = settings.destroyCryptoKeyVersionSettings.toBuilder();
            this.restoreCryptoKeyVersionSettings = settings.restoreCryptoKeyVersionSettings.toBuilder();
            this.encryptSettings = settings.encryptSettings.toBuilder();
            this.decryptSettings = settings.decryptSettings.toBuilder();
            this.rawEncryptSettings = settings.rawEncryptSettings.toBuilder();
            this.rawDecryptSettings = settings.rawDecryptSettings.toBuilder();
            this.asymmetricSignSettings = settings.asymmetricSignSettings.toBuilder();
            this.asymmetricDecryptSettings = settings.asymmetricDecryptSettings.toBuilder();
            this.macSignSettings = settings.macSignSettings.toBuilder();
            this.macVerifySettings = settings.macVerifySettings.toBuilder();
            this.generateRandomBytesSettings = settings.generateRandomBytesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listKeyRingsSettings, this.listCryptoKeysSettings, this.listCryptoKeyVersionsSettings, this.listImportJobsSettings, this.getKeyRingSettings, this.getCryptoKeySettings, this.getCryptoKeyVersionSettings, this.getPublicKeySettings, this.getImportJobSettings, this.createKeyRingSettings, this.createCryptoKeySettings, this.createCryptoKeyVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.importCryptoKeyVersionSettings, this.createImportJobSettings, this.updateCryptoKeySettings, this.updateCryptoKeyVersionSettings, this.updateCryptoKeyPrimaryVersionSettings, this.destroyCryptoKeyVersionSettings, this.restoreCryptoKeyVersionSettings, this.encryptSettings, this.decryptSettings, this.rawEncryptSettings, this.rawDecryptSettings, this.asymmetricSignSettings, this.asymmetricDecryptSettings, this.macSignSettings, this.macVerifySettings, this.generateRandomBytesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(KeyManagementServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)KeyManagementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeyManagementServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(KeyManagementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)KeyManagementServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)KeyManagementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeyManagementServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(KeyManagementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listKeyRingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listCryptoKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listCryptoKeyVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listImportJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getKeyRingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getCryptoKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getCryptoKeyVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getImportJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createKeyRingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createCryptoKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createCryptoKeyVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.importCryptoKeyVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createImportJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateCryptoKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateCryptoKeyVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateCryptoKeyPrimaryVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.destroyCryptoKeyVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.restoreCryptoKeyVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.encryptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.decryptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.rawEncryptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.rawDecryptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.asymmetricSignSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.asymmetricDecryptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.macSignSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.macVerifySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.generateRandomBytesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListKeyRingsRequest, ListKeyRingsResponse, KeyManagementServiceClient.ListKeyRingsPagedResponse> listKeyRingsSettings() {
            return this.listKeyRingsSettings;
        }

        public PagedCallSettings.Builder<ListCryptoKeysRequest, ListCryptoKeysResponse, KeyManagementServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysSettings() {
            return this.listCryptoKeysSettings;
        }

        public PagedCallSettings.Builder<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsSettings() {
            return this.listCryptoKeyVersionsSettings;
        }

        public PagedCallSettings.Builder<ListImportJobsRequest, ListImportJobsResponse, KeyManagementServiceClient.ListImportJobsPagedResponse> listImportJobsSettings() {
            return this.listImportJobsSettings;
        }

        public UnaryCallSettings.Builder<GetKeyRingRequest, KeyRing> getKeyRingSettings() {
            return this.getKeyRingSettings;
        }

        public UnaryCallSettings.Builder<GetCryptoKeyRequest, CryptoKey> getCryptoKeySettings() {
            return this.getCryptoKeySettings;
        }

        public UnaryCallSettings.Builder<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionSettings() {
            return this.getCryptoKeyVersionSettings;
        }

        public UnaryCallSettings.Builder<GetPublicKeyRequest, PublicKey> getPublicKeySettings() {
            return this.getPublicKeySettings;
        }

        public UnaryCallSettings.Builder<GetImportJobRequest, ImportJob> getImportJobSettings() {
            return this.getImportJobSettings;
        }

        public UnaryCallSettings.Builder<CreateKeyRingRequest, KeyRing> createKeyRingSettings() {
            return this.createKeyRingSettings;
        }

        public UnaryCallSettings.Builder<CreateCryptoKeyRequest, CryptoKey> createCryptoKeySettings() {
            return this.createCryptoKeySettings;
        }

        public UnaryCallSettings.Builder<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionSettings() {
            return this.createCryptoKeyVersionSettings;
        }

        public UnaryCallSettings.Builder<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionSettings() {
            return this.importCryptoKeyVersionSettings;
        }

        public UnaryCallSettings.Builder<CreateImportJobRequest, ImportJob> createImportJobSettings() {
            return this.createImportJobSettings;
        }

        public UnaryCallSettings.Builder<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeySettings() {
            return this.updateCryptoKeySettings;
        }

        public UnaryCallSettings.Builder<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionSettings() {
            return this.updateCryptoKeyVersionSettings;
        }

        public UnaryCallSettings.Builder<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionSettings() {
            return this.updateCryptoKeyPrimaryVersionSettings;
        }

        public UnaryCallSettings.Builder<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionSettings() {
            return this.destroyCryptoKeyVersionSettings;
        }

        public UnaryCallSettings.Builder<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionSettings() {
            return this.restoreCryptoKeyVersionSettings;
        }

        public UnaryCallSettings.Builder<EncryptRequest, EncryptResponse> encryptSettings() {
            return this.encryptSettings;
        }

        public UnaryCallSettings.Builder<DecryptRequest, DecryptResponse> decryptSettings() {
            return this.decryptSettings;
        }

        public UnaryCallSettings.Builder<RawEncryptRequest, RawEncryptResponse> rawEncryptSettings() {
            return this.rawEncryptSettings;
        }

        public UnaryCallSettings.Builder<RawDecryptRequest, RawDecryptResponse> rawDecryptSettings() {
            return this.rawDecryptSettings;
        }

        public UnaryCallSettings.Builder<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignSettings() {
            return this.asymmetricSignSettings;
        }

        public UnaryCallSettings.Builder<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptSettings() {
            return this.asymmetricDecryptSettings;
        }

        public UnaryCallSettings.Builder<MacSignRequest, MacSignResponse> macSignSettings() {
            return this.macSignSettings;
        }

        public UnaryCallSettings.Builder<MacVerifyRequest, MacVerifyResponse> macVerifySettings() {
            return this.macVerifySettings;
        }

        public UnaryCallSettings.Builder<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesSettings() {
            return this.generateRandomBytesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, KeyManagementServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public KeyManagementServiceStubSettings build() throws IOException {
            return new KeyManagementServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

