/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.CreateEkmConnectionRequest;
import com.google.cloud.kms.v1.EkmConnection;
import com.google.cloud.kms.v1.EkmConnectionName;
import com.google.cloud.kms.v1.EkmServiceSettings;
import com.google.cloud.kms.v1.GetEkmConnectionRequest;
import com.google.cloud.kms.v1.ListEkmConnectionsRequest;
import com.google.cloud.kms.v1.ListEkmConnectionsResponse;
import com.google.cloud.kms.v1.LocationName;
import com.google.cloud.kms.v1.UpdateEkmConnectionRequest;
import com.google.cloud.kms.v1.stub.EkmServiceStub;
import com.google.cloud.kms.v1.stub.EkmServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EkmServiceClient
implements BackgroundResource {
    private final EkmServiceSettings settings;
    private final EkmServiceStub stub;

    public static final EkmServiceClient create() throws IOException {
        return EkmServiceClient.create(EkmServiceSettings.newBuilder().build());
    }

    public static final EkmServiceClient create(EkmServiceSettings settings) throws IOException {
        return new EkmServiceClient(settings);
    }

    public static final EkmServiceClient create(EkmServiceStub stub) {
        return new EkmServiceClient(stub);
    }

    protected EkmServiceClient(EkmServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EkmServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected EkmServiceClient(EkmServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EkmServiceSettings getSettings() {
        return this.settings;
    }

    public EkmServiceStub getStub() {
        return this.stub;
    }

    public final ListEkmConnectionsPagedResponse listEkmConnections(LocationName parent) {
        ListEkmConnectionsRequest request = ListEkmConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEkmConnections(request);
    }

    public final ListEkmConnectionsPagedResponse listEkmConnections(String parent) {
        ListEkmConnectionsRequest request = ListEkmConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listEkmConnections(request);
    }

    public final ListEkmConnectionsPagedResponse listEkmConnections(ListEkmConnectionsRequest request) {
        return (ListEkmConnectionsPagedResponse)((Object)this.listEkmConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEkmConnectionsRequest, ListEkmConnectionsPagedResponse> listEkmConnectionsPagedCallable() {
        return this.stub.listEkmConnectionsPagedCallable();
    }

    public final UnaryCallable<ListEkmConnectionsRequest, ListEkmConnectionsResponse> listEkmConnectionsCallable() {
        return this.stub.listEkmConnectionsCallable();
    }

    public final EkmConnection getEkmConnection(EkmConnectionName name) {
        GetEkmConnectionRequest request = GetEkmConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEkmConnection(request);
    }

    public final EkmConnection getEkmConnection(String name) {
        GetEkmConnectionRequest request = GetEkmConnectionRequest.newBuilder().setName(name).build();
        return this.getEkmConnection(request);
    }

    public final EkmConnection getEkmConnection(GetEkmConnectionRequest request) {
        return (EkmConnection)this.getEkmConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetEkmConnectionRequest, EkmConnection> getEkmConnectionCallable() {
        return this.stub.getEkmConnectionCallable();
    }

    public final EkmConnection createEkmConnection(LocationName parent, String ekmConnectionId, EkmConnection ekmConnection) {
        CreateEkmConnectionRequest request = CreateEkmConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEkmConnectionId(ekmConnectionId).setEkmConnection(ekmConnection).build();
        return this.createEkmConnection(request);
    }

    public final EkmConnection createEkmConnection(String parent, String ekmConnectionId, EkmConnection ekmConnection) {
        CreateEkmConnectionRequest request = CreateEkmConnectionRequest.newBuilder().setParent(parent).setEkmConnectionId(ekmConnectionId).setEkmConnection(ekmConnection).build();
        return this.createEkmConnection(request);
    }

    public final EkmConnection createEkmConnection(CreateEkmConnectionRequest request) {
        return (EkmConnection)this.createEkmConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEkmConnectionRequest, EkmConnection> createEkmConnectionCallable() {
        return this.stub.createEkmConnectionCallable();
    }

    public final EkmConnection updateEkmConnection(EkmConnection ekmConnection, FieldMask updateMask) {
        UpdateEkmConnectionRequest request = UpdateEkmConnectionRequest.newBuilder().setEkmConnection(ekmConnection).setUpdateMask(updateMask).build();
        return this.updateEkmConnection(request);
    }

    public final EkmConnection updateEkmConnection(UpdateEkmConnectionRequest request) {
        return (EkmConnection)this.updateEkmConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEkmConnectionRequest, EkmConnection> updateEkmConnectionCallable() {
        return this.stub.updateEkmConnectionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEkmConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection, ListEkmConnectionsPage, ListEkmConnectionsFixedSizeCollection> {
        private ListEkmConnectionsFixedSizeCollection(List<ListEkmConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEkmConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListEkmConnectionsFixedSizeCollection(null, 0);
        }

        protected ListEkmConnectionsFixedSizeCollection createCollection(List<ListEkmConnectionsPage> pages, int collectionSize) {
            return new ListEkmConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEkmConnectionsPage
    extends AbstractPage<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection, ListEkmConnectionsPage> {
        private ListEkmConnectionsPage(PageContext<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection> context, ListEkmConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListEkmConnectionsPage createEmptyPage() {
            return new ListEkmConnectionsPage(null, null);
        }

        protected ListEkmConnectionsPage createPage(PageContext<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection> context, ListEkmConnectionsResponse response) {
            return new ListEkmConnectionsPage(context, response);
        }

        public ApiFuture<ListEkmConnectionsPage> createPageAsync(PageContext<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection> context, ApiFuture<ListEkmConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEkmConnectionsPagedResponse
    extends AbstractPagedListResponse<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection, ListEkmConnectionsPage, ListEkmConnectionsFixedSizeCollection> {
        public static ApiFuture<ListEkmConnectionsPagedResponse> createAsync(PageContext<ListEkmConnectionsRequest, ListEkmConnectionsResponse, EkmConnection> context, ApiFuture<ListEkmConnectionsResponse> futureResponse) {
            ApiFuture<ListEkmConnectionsPage> futurePage = ListEkmConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEkmConnectionsPagedResponse((ListEkmConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEkmConnectionsPagedResponse(ListEkmConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEkmConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

