/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.ids.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.ids.v1.CreateEndpointRequest;
import com.google.cloud.ids.v1.DeleteEndpointRequest;
import com.google.cloud.ids.v1.Endpoint;
import com.google.cloud.ids.v1.GetEndpointRequest;
import com.google.cloud.ids.v1.IDSClient;
import com.google.cloud.ids.v1.ListEndpointsRequest;
import com.google.cloud.ids.v1.ListEndpointsResponse;
import com.google.cloud.ids.v1.OperationMetadata;
import com.google.cloud.ids.v1.stub.HttpJsonIDSCallableFactory;
import com.google.cloud.ids.v1.stub.IDSStub;
import com.google.cloud.ids.v1.stub.IDSStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonIDSStub
extends IDSStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Endpoint.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListEndpointsRequest, ListEndpointsResponse> listEndpointsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.ids.v1.IDS/ListEndpoints").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/endpoints", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEndpointsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEndpointRequest, Endpoint> getEndpointMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.ids.v1.IDS/GetEndpoint").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/endpoints/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Endpoint.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateEndpointRequest, Operation> createEndpointMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.ids.v1.IDS/CreateEndpoint").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/endpoints", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "endpointId", (Object)request.getEndpointId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("endpoint", (Message)request.getEndpoint())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteEndpointRequest, Operation> deleteEndpointMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.ids.v1.IDS/DeleteEndpoint").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/endpoints/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable;
    private final UnaryCallable<ListEndpointsRequest, IDSClient.ListEndpointsPagedResponse> listEndpointsPagedCallable;
    private final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable;
    private final UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable;
    private final OperationCallable<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationCallable;
    private final UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable;
    private final OperationCallable<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonIDSStub create(IDSStubSettings settings) throws IOException {
        return new HttpJsonIDSStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonIDSStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonIDSStub(IDSStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonIDSStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonIDSStub(IDSStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonIDSStub(IDSStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonIDSCallableFactory());
    }

    protected HttpJsonIDSStub(IDSStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listEndpointsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEndpointsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getEndpointTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEndpointMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createEndpointTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEndpointMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteEndpointTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEndpointMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listEndpointsCallable = callableFactory.createUnaryCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.listEndpointsPagedCallable = callableFactory.createPagedCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.getEndpointCallable = callableFactory.createUnaryCallable(getEndpointTransportSettings, settings.getEndpointSettings(), clientContext);
        this.createEndpointCallable = callableFactory.createUnaryCallable(createEndpointTransportSettings, settings.createEndpointSettings(), clientContext);
        this.createEndpointOperationCallable = callableFactory.createOperationCallable(createEndpointTransportSettings, settings.createEndpointOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteEndpointCallable = callableFactory.createUnaryCallable(deleteEndpointTransportSettings, settings.deleteEndpointSettings(), clientContext);
        this.deleteEndpointOperationCallable = callableFactory.createOperationCallable(deleteEndpointTransportSettings, settings.deleteEndpointOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listEndpointsMethodDescriptor);
        methodDescriptors.add(getEndpointMethodDescriptor);
        methodDescriptors.add(createEndpointMethodDescriptor);
        methodDescriptors.add(deleteEndpointMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.listEndpointsCallable;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, IDSClient.ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.listEndpointsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.getEndpointCallable;
    }

    @Override
    public UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable() {
        return this.createEndpointCallable;
    }

    @Override
    public OperationCallable<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationCallable() {
        return this.createEndpointOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable() {
        return this.deleteEndpointCallable;
    }

    @Override
    public OperationCallable<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationCallable() {
        return this.deleteEndpointOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

