/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1beta.CreateFeatureRequest;
import com.google.cloud.gkehub.v1beta.DeleteFeatureRequest;
import com.google.cloud.gkehub.v1beta.Feature;
import com.google.cloud.gkehub.v1beta.GetFeatureRequest;
import com.google.cloud.gkehub.v1beta.GkeHubClient;
import com.google.cloud.gkehub.v1beta.ListFeaturesRequest;
import com.google.cloud.gkehub.v1beta.ListFeaturesResponse;
import com.google.cloud.gkehub.v1beta.OperationMetadata;
import com.google.cloud.gkehub.v1beta.UpdateFeatureRequest;
import com.google.cloud.gkehub.v1beta.stub.GkeHubStub;
import com.google.cloud.gkehub.v1beta.stub.GkeHubStubSettings;
import com.google.cloud.gkehub.v1beta.stub.GrpcGkeHubCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcGkeHubStub
extends GkeHubStub {
    private static final MethodDescriptor<ListFeaturesRequest, ListFeaturesResponse> listFeaturesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/ListFeatures").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFeaturesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFeaturesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetFeatureRequest, Feature> getFeatureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/GetFeature").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFeatureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Feature.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateFeatureRequest, Operation> createFeatureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/CreateFeature").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFeatureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteFeatureRequest, Operation> deleteFeatureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/DeleteFeature").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFeatureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateFeatureRequest, Operation> updateFeatureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/UpdateFeature").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFeatureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable;
    private final UnaryCallable<ListFeaturesRequest, GkeHubClient.ListFeaturesPagedResponse> listFeaturesPagedCallable;
    private final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable;
    private final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable;
    private final OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable;
    private final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable;
    private final OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable;
    private final UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable;
    private final OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGkeHubStub create(GkeHubStubSettings settings) throws IOException {
        return new GrpcGkeHubStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGkeHubStub create(ClientContext clientContext) throws IOException {
        return new GrpcGkeHubStub(GkeHubStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGkeHubStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGkeHubStub(GkeHubStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGkeHubStub(GkeHubStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcGkeHubCallableFactory());
    }

    protected GrpcGkeHubStub(GkeHubStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listFeaturesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFeaturesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getFeatureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFeatureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createFeatureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFeatureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteFeatureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFeatureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateFeatureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFeatureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listFeaturesCallable = callableFactory.createUnaryCallable(listFeaturesTransportSettings, settings.listFeaturesSettings(), clientContext);
        this.listFeaturesPagedCallable = callableFactory.createPagedCallable(listFeaturesTransportSettings, settings.listFeaturesSettings(), clientContext);
        this.getFeatureCallable = callableFactory.createUnaryCallable(getFeatureTransportSettings, settings.getFeatureSettings(), clientContext);
        this.createFeatureCallable = callableFactory.createUnaryCallable(createFeatureTransportSettings, settings.createFeatureSettings(), clientContext);
        this.createFeatureOperationCallable = callableFactory.createOperationCallable(createFeatureTransportSettings, settings.createFeatureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteFeatureCallable = callableFactory.createUnaryCallable(deleteFeatureTransportSettings, settings.deleteFeatureSettings(), clientContext);
        this.deleteFeatureOperationCallable = callableFactory.createOperationCallable(deleteFeatureTransportSettings, settings.deleteFeatureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateFeatureCallable = callableFactory.createUnaryCallable(updateFeatureTransportSettings, settings.updateFeatureSettings(), clientContext);
        this.updateFeatureOperationCallable = callableFactory.createOperationCallable(updateFeatureTransportSettings, settings.updateFeatureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.listFeaturesCallable;
    }

    @Override
    public UnaryCallable<ListFeaturesRequest, GkeHubClient.ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.listFeaturesPagedCallable;
    }

    @Override
    public UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.getFeatureCallable;
    }

    @Override
    public UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.createFeatureCallable;
    }

    @Override
    public OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable() {
        return this.createFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.deleteFeatureCallable;
    }

    @Override
    public OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable() {
        return this.deleteFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable() {
        return this.updateFeatureCallable;
    }

    @Override
    public OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable() {
        return this.updateFeatureOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

