/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1beta.CreateFeatureRequest;
import com.google.cloud.gkehub.v1beta.DeleteFeatureRequest;
import com.google.cloud.gkehub.v1beta.Feature;
import com.google.cloud.gkehub.v1beta.GetFeatureRequest;
import com.google.cloud.gkehub.v1beta.GkeHubClient;
import com.google.cloud.gkehub.v1beta.ListFeaturesRequest;
import com.google.cloud.gkehub.v1beta.ListFeaturesResponse;
import com.google.cloud.gkehub.v1beta.OperationMetadata;
import com.google.cloud.gkehub.v1beta.UpdateFeatureRequest;
import com.google.cloud.gkehub.v1beta.stub.GkeHubStub;
import com.google.cloud.gkehub.v1beta.stub.GkeHubStubSettings;
import com.google.cloud.gkehub.v1beta.stub.HttpJsonGkeHubCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonGkeHubStub
extends GkeHubStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Feature.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListFeaturesRequest, ListFeaturesResponse> listFeaturesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/ListFeatures").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/features", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFeaturesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFeatureRequest, Feature> getFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/GetFeature").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/features/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Feature.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateFeatureRequest, Operation> createFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/CreateFeature").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/features", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "featureId", (Object)request.getFeatureId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteFeatureRequest, Operation> deleteFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/DeleteFeature").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/features/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateFeatureRequest, Operation> updateFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1beta.GkeHub/UpdateFeature").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/features/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable;
    private final UnaryCallable<ListFeaturesRequest, GkeHubClient.ListFeaturesPagedResponse> listFeaturesPagedCallable;
    private final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable;
    private final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable;
    private final OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable;
    private final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable;
    private final OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable;
    private final UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable;
    private final OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonGkeHubStub create(GkeHubStubSettings settings) throws IOException {
        return new HttpJsonGkeHubStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonGkeHubStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonGkeHubStub(GkeHubStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonGkeHubStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonGkeHubStub(GkeHubStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonGkeHubStub(GkeHubStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonGkeHubCallableFactory());
    }

    protected HttpJsonGkeHubStub(GkeHubStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listFeaturesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFeaturesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listFeaturesCallable = callableFactory.createUnaryCallable(listFeaturesTransportSettings, settings.listFeaturesSettings(), clientContext);
        this.listFeaturesPagedCallable = callableFactory.createPagedCallable(listFeaturesTransportSettings, settings.listFeaturesSettings(), clientContext);
        this.getFeatureCallable = callableFactory.createUnaryCallable(getFeatureTransportSettings, settings.getFeatureSettings(), clientContext);
        this.createFeatureCallable = callableFactory.createUnaryCallable(createFeatureTransportSettings, settings.createFeatureSettings(), clientContext);
        this.createFeatureOperationCallable = callableFactory.createOperationCallable(createFeatureTransportSettings, settings.createFeatureOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteFeatureCallable = callableFactory.createUnaryCallable(deleteFeatureTransportSettings, settings.deleteFeatureSettings(), clientContext);
        this.deleteFeatureOperationCallable = callableFactory.createOperationCallable(deleteFeatureTransportSettings, settings.deleteFeatureOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateFeatureCallable = callableFactory.createUnaryCallable(updateFeatureTransportSettings, settings.updateFeatureSettings(), clientContext);
        this.updateFeatureOperationCallable = callableFactory.createOperationCallable(updateFeatureTransportSettings, settings.updateFeatureOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listFeaturesMethodDescriptor);
        methodDescriptors.add(getFeatureMethodDescriptor);
        methodDescriptors.add(createFeatureMethodDescriptor);
        methodDescriptors.add(deleteFeatureMethodDescriptor);
        methodDescriptors.add(updateFeatureMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.listFeaturesCallable;
    }

    @Override
    public UnaryCallable<ListFeaturesRequest, GkeHubClient.ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.listFeaturesPagedCallable;
    }

    @Override
    public UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.getFeatureCallable;
    }

    @Override
    public UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.createFeatureCallable;
    }

    @Override
    public OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable() {
        return this.createFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.deleteFeatureCallable;
    }

    @Override
    public OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable() {
        return this.deleteFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable() {
        return this.updateFeatureCallable;
    }

    @Override
    public OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable() {
        return this.updateFeatureOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

