/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1alpha2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1alpha2.CreateMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.DeleteMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.GenerateConnectManifestRequest;
import com.google.cloud.gkehub.v1alpha2.GenerateConnectManifestResponse;
import com.google.cloud.gkehub.v1alpha2.GetMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.GkeHubSettings;
import com.google.cloud.gkehub.v1alpha2.InitializeHubRequest;
import com.google.cloud.gkehub.v1alpha2.InitializeHubResponse;
import com.google.cloud.gkehub.v1alpha2.ListMembershipsRequest;
import com.google.cloud.gkehub.v1alpha2.ListMembershipsResponse;
import com.google.cloud.gkehub.v1alpha2.LocationName;
import com.google.cloud.gkehub.v1alpha2.Membership;
import com.google.cloud.gkehub.v1alpha2.MembershipName;
import com.google.cloud.gkehub.v1alpha2.OperationMetadata;
import com.google.cloud.gkehub.v1alpha2.UpdateMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.stub.GkeHubStub;
import com.google.cloud.gkehub.v1alpha2.stub.GkeHubStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GkeHubClient
implements BackgroundResource {
    private final GkeHubSettings settings;
    private final GkeHubStub stub;
    private final OperationsClient operationsClient;

    public static final GkeHubClient create() throws IOException {
        return GkeHubClient.create(GkeHubSettings.newBuilder().build());
    }

    public static final GkeHubClient create(GkeHubSettings settings) throws IOException {
        return new GkeHubClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GkeHubClient create(GkeHubStub stub) {
        return new GkeHubClient(stub);
    }

    protected GkeHubClient(GkeHubSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GkeHubStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GkeHubClient(GkeHubStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final GkeHubSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GkeHubStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListMembershipsPagedResponse listMemberships(LocationName parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(String parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(ListMembershipsRequest request) {
        return (ListMembershipsPagedResponse)((Object)this.listMembershipsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsPagedResponse> listMembershipsPagedCallable() {
        return this.stub.listMembershipsPagedCallable();
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable() {
        return this.stub.listMembershipsCallable();
    }

    public final Membership getMembership(MembershipName name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(String name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(GetMembershipRequest request) {
        return (Membership)this.getMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable() {
        return this.stub.getMembershipCallable();
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(LocationName parent, Membership resource, String membershipId) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setResource(resource).setMembershipId(membershipId).build();
        return this.createMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(String parent, Membership resource, String membershipId) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent).setResource(resource).setMembershipId(membershipId).build();
        return this.createMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(CreateMembershipRequest request) {
        return this.createMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationCallable() {
        return this.stub.createMembershipOperationCallable();
    }

    public final UnaryCallable<CreateMembershipRequest, Operation> createMembershipCallable() {
        return this.stub.createMembershipCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(MembershipName name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMembershipAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(String name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name).build();
        return this.deleteMembershipAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(DeleteMembershipRequest request) {
        return this.deleteMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationCallable() {
        return this.stub.deleteMembershipOperationCallable();
    }

    public final UnaryCallable<DeleteMembershipRequest, Operation> deleteMembershipCallable() {
        return this.stub.deleteMembershipCallable();
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(String name, Membership resource, FieldMask updateMask) {
        UpdateMembershipRequest request = UpdateMembershipRequest.newBuilder().setName(name).setResource(resource).setUpdateMask(updateMask).build();
        return this.updateMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(UpdateMembershipRequest request) {
        return this.updateMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationCallable() {
        return this.stub.updateMembershipOperationCallable();
    }

    public final UnaryCallable<UpdateMembershipRequest, Operation> updateMembershipCallable() {
        return this.stub.updateMembershipCallable();
    }

    public final GenerateConnectManifestResponse generateConnectManifest(GenerateConnectManifestRequest request) {
        return (GenerateConnectManifestResponse)this.generateConnectManifestCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestCallable() {
        return this.stub.generateConnectManifestCallable();
    }

    public final InitializeHubResponse initializeHub(InitializeHubRequest request) {
        return (InitializeHubResponse)this.initializeHubCallable().call((Object)request);
    }

    public final UnaryCallable<InitializeHubRequest, InitializeHubResponse> initializeHubCallable() {
        return this.stub.initializeHubCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMembershipsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        private ListMembershipsFixedSizeCollection(List<ListMembershipsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMembershipsFixedSizeCollection createEmptyCollection() {
            return new ListMembershipsFixedSizeCollection(null, 0);
        }

        protected ListMembershipsFixedSizeCollection createCollection(List<ListMembershipsPage> pages, int collectionSize) {
            return new ListMembershipsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMembershipsPage
    extends AbstractPage<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage> {
        private ListMembershipsPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            super(context, (Object)response);
        }

        private static ListMembershipsPage createEmptyPage() {
            return new ListMembershipsPage(null, null);
        }

        protected ListMembershipsPage createPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            return new ListMembershipsPage(context, response);
        }

        public ApiFuture<ListMembershipsPage> createPageAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMembershipsPagedResponse
    extends AbstractPagedListResponse<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        public static ApiFuture<ListMembershipsPagedResponse> createAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            ApiFuture<ListMembershipsPage> futurePage = ListMembershipsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMembershipsPagedResponse((ListMembershipsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMembershipsPagedResponse(ListMembershipsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMembershipsFixedSizeCollection.createEmptyCollection());
        }
    }
}

