/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1alpha2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1alpha2.CreateMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.DeleteMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.GenerateConnectManifestRequest;
import com.google.cloud.gkehub.v1alpha2.GenerateConnectManifestResponse;
import com.google.cloud.gkehub.v1alpha2.GetMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.GkeHubClient;
import com.google.cloud.gkehub.v1alpha2.InitializeHubRequest;
import com.google.cloud.gkehub.v1alpha2.InitializeHubResponse;
import com.google.cloud.gkehub.v1alpha2.ListMembershipsRequest;
import com.google.cloud.gkehub.v1alpha2.ListMembershipsResponse;
import com.google.cloud.gkehub.v1alpha2.Membership;
import com.google.cloud.gkehub.v1alpha2.OperationMetadata;
import com.google.cloud.gkehub.v1alpha2.UpdateMembershipRequest;
import com.google.cloud.gkehub.v1alpha2.stub.GkeHubStub;
import com.google.cloud.gkehub.v1alpha2.stub.GrpcGkeHubStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GkeHubStubSettings
extends StubSettings<GkeHubStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListMembershipsRequest, ListMembershipsResponse, GkeHubClient.ListMembershipsPagedResponse> listMembershipsSettings;
    private final UnaryCallSettings<GetMembershipRequest, Membership> getMembershipSettings;
    private final UnaryCallSettings<CreateMembershipRequest, Operation> createMembershipSettings;
    private final OperationCallSettings<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationSettings;
    private final UnaryCallSettings<DeleteMembershipRequest, Operation> deleteMembershipSettings;
    private final OperationCallSettings<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationSettings;
    private final UnaryCallSettings<UpdateMembershipRequest, Operation> updateMembershipSettings;
    private final OperationCallSettings<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationSettings;
    private final UnaryCallSettings<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestSettings;
    private final UnaryCallSettings<InitializeHubRequest, InitializeHubResponse> initializeHubSettings;
    private static final PagedListDescriptor<ListMembershipsRequest, ListMembershipsResponse, Membership> LIST_MEMBERSHIPS_PAGE_STR_DESC = new PagedListDescriptor<ListMembershipsRequest, ListMembershipsResponse, Membership>(){

        public String emptyToken() {
            return "";
        }

        public ListMembershipsRequest injectToken(ListMembershipsRequest payload, String token) {
            return ListMembershipsRequest.newBuilder((ListMembershipsRequest)payload).setPageToken(token).build();
        }

        public ListMembershipsRequest injectPageSize(ListMembershipsRequest payload, int pageSize) {
            return ListMembershipsRequest.newBuilder((ListMembershipsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMembershipsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMembershipsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Membership> extractResources(ListMembershipsResponse payload) {
            return payload.getResourcesList() == null ? ImmutableList.of() : payload.getResourcesList();
        }
    };
    private static final PagedListResponseFactory<ListMembershipsRequest, ListMembershipsResponse, GkeHubClient.ListMembershipsPagedResponse> LIST_MEMBERSHIPS_PAGE_STR_FACT = new PagedListResponseFactory<ListMembershipsRequest, ListMembershipsResponse, GkeHubClient.ListMembershipsPagedResponse>(){

        public ApiFuture<GkeHubClient.ListMembershipsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> callable, ListMembershipsRequest request, ApiCallContext context, ApiFuture<ListMembershipsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MEMBERSHIPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GkeHubClient.ListMembershipsPagedResponse.createAsync((PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListMembershipsRequest, ListMembershipsResponse, GkeHubClient.ListMembershipsPagedResponse> listMembershipsSettings() {
        return this.listMembershipsSettings;
    }

    public UnaryCallSettings<GetMembershipRequest, Membership> getMembershipSettings() {
        return this.getMembershipSettings;
    }

    public UnaryCallSettings<CreateMembershipRequest, Operation> createMembershipSettings() {
        return this.createMembershipSettings;
    }

    public OperationCallSettings<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationSettings() {
        return this.createMembershipOperationSettings;
    }

    public UnaryCallSettings<DeleteMembershipRequest, Operation> deleteMembershipSettings() {
        return this.deleteMembershipSettings;
    }

    public OperationCallSettings<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationSettings() {
        return this.deleteMembershipOperationSettings;
    }

    public UnaryCallSettings<UpdateMembershipRequest, Operation> updateMembershipSettings() {
        return this.updateMembershipSettings;
    }

    public OperationCallSettings<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationSettings() {
        return this.updateMembershipOperationSettings;
    }

    public UnaryCallSettings<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestSettings() {
        return this.generateConnectManifestSettings;
    }

    public UnaryCallSettings<InitializeHubRequest, InitializeHubResponse> initializeHubSettings() {
        return this.initializeHubSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GkeHubStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGkeHubStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gkehub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkehub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GkeHubStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GkeHubStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GkeHubStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listMembershipsSettings = settingsBuilder.listMembershipsSettings().build();
        this.getMembershipSettings = settingsBuilder.getMembershipSettings().build();
        this.createMembershipSettings = settingsBuilder.createMembershipSettings().build();
        this.createMembershipOperationSettings = settingsBuilder.createMembershipOperationSettings().build();
        this.deleteMembershipSettings = settingsBuilder.deleteMembershipSettings().build();
        this.deleteMembershipOperationSettings = settingsBuilder.deleteMembershipOperationSettings().build();
        this.updateMembershipSettings = settingsBuilder.updateMembershipSettings().build();
        this.updateMembershipOperationSettings = settingsBuilder.updateMembershipOperationSettings().build();
        this.generateConnectManifestSettings = settingsBuilder.generateConnectManifestSettings().build();
        this.initializeHubSettings = settingsBuilder.initializeHubSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GkeHubStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListMembershipsRequest, ListMembershipsResponse, GkeHubClient.ListMembershipsPagedResponse> listMembershipsSettings;
        private final UnaryCallSettings.Builder<GetMembershipRequest, Membership> getMembershipSettings;
        private final UnaryCallSettings.Builder<CreateMembershipRequest, Operation> createMembershipSettings;
        private final OperationCallSettings.Builder<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMembershipRequest, Operation> deleteMembershipSettings;
        private final OperationCallSettings.Builder<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationSettings;
        private final UnaryCallSettings.Builder<UpdateMembershipRequest, Operation> updateMembershipSettings;
        private final OperationCallSettings.Builder<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationSettings;
        private final UnaryCallSettings.Builder<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestSettings;
        private final UnaryCallSettings.Builder<InitializeHubRequest, InitializeHubResponse> initializeHubSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listMembershipsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MEMBERSHIPS_PAGE_STR_FACT);
            this.getMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMembershipOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMembershipOperationSettings = OperationCallSettings.newBuilder();
            this.updateMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMembershipOperationSettings = OperationCallSettings.newBuilder();
            this.generateConnectManifestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.initializeHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMembershipsSettings, this.getMembershipSettings, this.createMembershipSettings, this.deleteMembershipSettings, this.updateMembershipSettings, this.generateConnectManifestSettings, this.initializeHubSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GkeHubStubSettings settings) {
            super((StubSettings)settings);
            this.listMembershipsSettings = settings.listMembershipsSettings.toBuilder();
            this.getMembershipSettings = settings.getMembershipSettings.toBuilder();
            this.createMembershipSettings = settings.createMembershipSettings.toBuilder();
            this.createMembershipOperationSettings = settings.createMembershipOperationSettings.toBuilder();
            this.deleteMembershipSettings = settings.deleteMembershipSettings.toBuilder();
            this.deleteMembershipOperationSettings = settings.deleteMembershipOperationSettings.toBuilder();
            this.updateMembershipSettings = settings.updateMembershipSettings.toBuilder();
            this.updateMembershipOperationSettings = settings.updateMembershipOperationSettings.toBuilder();
            this.generateConnectManifestSettings = settings.generateConnectManifestSettings.toBuilder();
            this.initializeHubSettings = settings.initializeHubSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMembershipsSettings, this.getMembershipSettings, this.createMembershipSettings, this.deleteMembershipSettings, this.updateMembershipSettings, this.generateConnectManifestSettings, this.initializeHubSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GkeHubStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GkeHubStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GkeHubStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GkeHubStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(GkeHubStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listMembershipsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateConnectManifestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.initializeHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createMembershipOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Membership.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteMembershipOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateMembershipOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Membership.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListMembershipsRequest, ListMembershipsResponse, GkeHubClient.ListMembershipsPagedResponse> listMembershipsSettings() {
            return this.listMembershipsSettings;
        }

        public UnaryCallSettings.Builder<GetMembershipRequest, Membership> getMembershipSettings() {
            return this.getMembershipSettings;
        }

        public UnaryCallSettings.Builder<CreateMembershipRequest, Operation> createMembershipSettings() {
            return this.createMembershipSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationSettings() {
            return this.createMembershipOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMembershipRequest, Operation> deleteMembershipSettings() {
            return this.deleteMembershipSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationSettings() {
            return this.deleteMembershipOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateMembershipRequest, Operation> updateMembershipSettings() {
            return this.updateMembershipSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationSettings() {
            return this.updateMembershipOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestSettings() {
            return this.generateConnectManifestSettings;
        }

        public UnaryCallSettings.Builder<InitializeHubRequest, InitializeHubResponse> initializeHubSettings() {
            return this.initializeHubSettings;
        }

        public GkeHubStubSettings build() throws IOException {
            return new GkeHubStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

