/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkemulticloud.v1.AttachedCluster;
import com.google.cloud.gkemulticloud.v1.AttachedClustersClient;
import com.google.cloud.gkemulticloud.v1.AttachedServerConfig;
import com.google.cloud.gkemulticloud.v1.CreateAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestResponse;
import com.google.cloud.gkemulticloud.v1.GetAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.GetAttachedServerConfigRequest;
import com.google.cloud.gkemulticloud.v1.ImportAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.ListAttachedClustersRequest;
import com.google.cloud.gkemulticloud.v1.ListAttachedClustersResponse;
import com.google.cloud.gkemulticloud.v1.OperationMetadata;
import com.google.cloud.gkemulticloud.v1.UpdateAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.stub.AttachedClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.GrpcAttachedClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.HttpJsonAttachedClustersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AttachedClustersStubSettings
extends StubSettings<AttachedClustersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateAttachedClusterRequest, Operation> createAttachedClusterSettings;
    private final OperationCallSettings<CreateAttachedClusterRequest, AttachedCluster, OperationMetadata> createAttachedClusterOperationSettings;
    private final UnaryCallSettings<UpdateAttachedClusterRequest, Operation> updateAttachedClusterSettings;
    private final OperationCallSettings<UpdateAttachedClusterRequest, AttachedCluster, OperationMetadata> updateAttachedClusterOperationSettings;
    private final UnaryCallSettings<ImportAttachedClusterRequest, Operation> importAttachedClusterSettings;
    private final OperationCallSettings<ImportAttachedClusterRequest, AttachedCluster, OperationMetadata> importAttachedClusterOperationSettings;
    private final UnaryCallSettings<GetAttachedClusterRequest, AttachedCluster> getAttachedClusterSettings;
    private final PagedCallSettings<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedClustersClient.ListAttachedClustersPagedResponse> listAttachedClustersSettings;
    private final UnaryCallSettings<DeleteAttachedClusterRequest, Operation> deleteAttachedClusterSettings;
    private final OperationCallSettings<DeleteAttachedClusterRequest, Empty, OperationMetadata> deleteAttachedClusterOperationSettings;
    private final UnaryCallSettings<GetAttachedServerConfigRequest, AttachedServerConfig> getAttachedServerConfigSettings;
    private final UnaryCallSettings<GenerateAttachedClusterInstallManifestRequest, GenerateAttachedClusterInstallManifestResponse> generateAttachedClusterInstallManifestSettings;
    private static final PagedListDescriptor<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster> LIST_ATTACHED_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListAttachedClustersRequest injectToken(ListAttachedClustersRequest payload, String token) {
            return ListAttachedClustersRequest.newBuilder((ListAttachedClustersRequest)payload).setPageToken(token).build();
        }

        public ListAttachedClustersRequest injectPageSize(ListAttachedClustersRequest payload, int pageSize) {
            return ListAttachedClustersRequest.newBuilder((ListAttachedClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAttachedClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAttachedClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AttachedCluster> extractResources(ListAttachedClustersResponse payload) {
            return payload.getAttachedClustersList() == null ? ImmutableList.of() : payload.getAttachedClustersList();
        }
    };
    private static final PagedListResponseFactory<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedClustersClient.ListAttachedClustersPagedResponse> LIST_ATTACHED_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedClustersClient.ListAttachedClustersPagedResponse>(){

        public ApiFuture<AttachedClustersClient.ListAttachedClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListAttachedClustersRequest, ListAttachedClustersResponse> callable, ListAttachedClustersRequest request, ApiCallContext context, ApiFuture<ListAttachedClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ATTACHED_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AttachedClustersClient.ListAttachedClustersPagedResponse.createAsync((PageContext<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAttachedClusterRequest, Operation> createAttachedClusterSettings() {
        return this.createAttachedClusterSettings;
    }

    public OperationCallSettings<CreateAttachedClusterRequest, AttachedCluster, OperationMetadata> createAttachedClusterOperationSettings() {
        return this.createAttachedClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateAttachedClusterRequest, Operation> updateAttachedClusterSettings() {
        return this.updateAttachedClusterSettings;
    }

    public OperationCallSettings<UpdateAttachedClusterRequest, AttachedCluster, OperationMetadata> updateAttachedClusterOperationSettings() {
        return this.updateAttachedClusterOperationSettings;
    }

    public UnaryCallSettings<ImportAttachedClusterRequest, Operation> importAttachedClusterSettings() {
        return this.importAttachedClusterSettings;
    }

    public OperationCallSettings<ImportAttachedClusterRequest, AttachedCluster, OperationMetadata> importAttachedClusterOperationSettings() {
        return this.importAttachedClusterOperationSettings;
    }

    public UnaryCallSettings<GetAttachedClusterRequest, AttachedCluster> getAttachedClusterSettings() {
        return this.getAttachedClusterSettings;
    }

    public PagedCallSettings<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedClustersClient.ListAttachedClustersPagedResponse> listAttachedClustersSettings() {
        return this.listAttachedClustersSettings;
    }

    public UnaryCallSettings<DeleteAttachedClusterRequest, Operation> deleteAttachedClusterSettings() {
        return this.deleteAttachedClusterSettings;
    }

    public OperationCallSettings<DeleteAttachedClusterRequest, Empty, OperationMetadata> deleteAttachedClusterOperationSettings() {
        return this.deleteAttachedClusterOperationSettings;
    }

    public UnaryCallSettings<GetAttachedServerConfigRequest, AttachedServerConfig> getAttachedServerConfigSettings() {
        return this.getAttachedServerConfigSettings;
    }

    public UnaryCallSettings<GenerateAttachedClusterInstallManifestRequest, GenerateAttachedClusterInstallManifestResponse> generateAttachedClusterInstallManifestSettings() {
        return this.generateAttachedClusterInstallManifestSettings;
    }

    public AttachedClustersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAttachedClustersStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAttachedClustersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gkemulticloud.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkemulticloud.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AttachedClustersStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AttachedClustersStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AttachedClustersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AttachedClustersStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AttachedClustersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAttachedClusterSettings = settingsBuilder.createAttachedClusterSettings().build();
        this.createAttachedClusterOperationSettings = settingsBuilder.createAttachedClusterOperationSettings().build();
        this.updateAttachedClusterSettings = settingsBuilder.updateAttachedClusterSettings().build();
        this.updateAttachedClusterOperationSettings = settingsBuilder.updateAttachedClusterOperationSettings().build();
        this.importAttachedClusterSettings = settingsBuilder.importAttachedClusterSettings().build();
        this.importAttachedClusterOperationSettings = settingsBuilder.importAttachedClusterOperationSettings().build();
        this.getAttachedClusterSettings = settingsBuilder.getAttachedClusterSettings().build();
        this.listAttachedClustersSettings = settingsBuilder.listAttachedClustersSettings().build();
        this.deleteAttachedClusterSettings = settingsBuilder.deleteAttachedClusterSettings().build();
        this.deleteAttachedClusterOperationSettings = settingsBuilder.deleteAttachedClusterOperationSettings().build();
        this.getAttachedServerConfigSettings = settingsBuilder.getAttachedServerConfigSettings().build();
        this.generateAttachedClusterInstallManifestSettings = settingsBuilder.generateAttachedClusterInstallManifestSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AttachedClustersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAttachedClusterRequest, Operation> createAttachedClusterSettings;
        private final OperationCallSettings.Builder<CreateAttachedClusterRequest, AttachedCluster, OperationMetadata> createAttachedClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAttachedClusterRequest, Operation> updateAttachedClusterSettings;
        private final OperationCallSettings.Builder<UpdateAttachedClusterRequest, AttachedCluster, OperationMetadata> updateAttachedClusterOperationSettings;
        private final UnaryCallSettings.Builder<ImportAttachedClusterRequest, Operation> importAttachedClusterSettings;
        private final OperationCallSettings.Builder<ImportAttachedClusterRequest, AttachedCluster, OperationMetadata> importAttachedClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetAttachedClusterRequest, AttachedCluster> getAttachedClusterSettings;
        private final PagedCallSettings.Builder<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedClustersClient.ListAttachedClustersPagedResponse> listAttachedClustersSettings;
        private final UnaryCallSettings.Builder<DeleteAttachedClusterRequest, Operation> deleteAttachedClusterSettings;
        private final OperationCallSettings.Builder<DeleteAttachedClusterRequest, Empty, OperationMetadata> deleteAttachedClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetAttachedServerConfigRequest, AttachedServerConfig> getAttachedServerConfigSettings;
        private final UnaryCallSettings.Builder<GenerateAttachedClusterInstallManifestRequest, GenerateAttachedClusterInstallManifestResponse> generateAttachedClusterInstallManifestSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAttachedClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAttachedClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateAttachedClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAttachedClusterOperationSettings = OperationCallSettings.newBuilder();
            this.importAttachedClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importAttachedClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getAttachedClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAttachedClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ATTACHED_CLUSTERS_PAGE_STR_FACT);
            this.deleteAttachedClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAttachedClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getAttachedServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateAttachedClusterInstallManifestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAttachedClusterSettings, this.updateAttachedClusterSettings, this.importAttachedClusterSettings, this.getAttachedClusterSettings, this.listAttachedClustersSettings, this.deleteAttachedClusterSettings, this.getAttachedServerConfigSettings, this.generateAttachedClusterInstallManifestSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AttachedClustersStubSettings settings) {
            super((StubSettings)settings);
            this.createAttachedClusterSettings = settings.createAttachedClusterSettings.toBuilder();
            this.createAttachedClusterOperationSettings = settings.createAttachedClusterOperationSettings.toBuilder();
            this.updateAttachedClusterSettings = settings.updateAttachedClusterSettings.toBuilder();
            this.updateAttachedClusterOperationSettings = settings.updateAttachedClusterOperationSettings.toBuilder();
            this.importAttachedClusterSettings = settings.importAttachedClusterSettings.toBuilder();
            this.importAttachedClusterOperationSettings = settings.importAttachedClusterOperationSettings.toBuilder();
            this.getAttachedClusterSettings = settings.getAttachedClusterSettings.toBuilder();
            this.listAttachedClustersSettings = settings.listAttachedClustersSettings.toBuilder();
            this.deleteAttachedClusterSettings = settings.deleteAttachedClusterSettings.toBuilder();
            this.deleteAttachedClusterOperationSettings = settings.deleteAttachedClusterOperationSettings.toBuilder();
            this.getAttachedServerConfigSettings = settings.getAttachedServerConfigSettings.toBuilder();
            this.generateAttachedClusterInstallManifestSettings = settings.generateAttachedClusterInstallManifestSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAttachedClusterSettings, this.updateAttachedClusterSettings, this.importAttachedClusterSettings, this.getAttachedClusterSettings, this.listAttachedClustersSettings, this.deleteAttachedClusterSettings, this.getAttachedServerConfigSettings, this.generateAttachedClusterInstallManifestSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AttachedClustersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AttachedClustersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AttachedClustersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AttachedClustersStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AttachedClustersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AttachedClustersStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AttachedClustersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AttachedClustersStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AttachedClustersStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AttachedClustersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAttachedClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAttachedClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.importAttachedClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAttachedClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAttachedClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAttachedClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAttachedServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateAttachedClusterInstallManifestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAttachedClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AttachedCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAttachedClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AttachedCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importAttachedClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AttachedCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAttachedClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAttachedClusterRequest, Operation> createAttachedClusterSettings() {
            return this.createAttachedClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateAttachedClusterRequest, AttachedCluster, OperationMetadata> createAttachedClusterOperationSettings() {
            return this.createAttachedClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAttachedClusterRequest, Operation> updateAttachedClusterSettings() {
            return this.updateAttachedClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateAttachedClusterRequest, AttachedCluster, OperationMetadata> updateAttachedClusterOperationSettings() {
            return this.updateAttachedClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportAttachedClusterRequest, Operation> importAttachedClusterSettings() {
            return this.importAttachedClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportAttachedClusterRequest, AttachedCluster, OperationMetadata> importAttachedClusterOperationSettings() {
            return this.importAttachedClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAttachedClusterRequest, AttachedCluster> getAttachedClusterSettings() {
            return this.getAttachedClusterSettings;
        }

        public PagedCallSettings.Builder<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedClustersClient.ListAttachedClustersPagedResponse> listAttachedClustersSettings() {
            return this.listAttachedClustersSettings;
        }

        public UnaryCallSettings.Builder<DeleteAttachedClusterRequest, Operation> deleteAttachedClusterSettings() {
            return this.deleteAttachedClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAttachedClusterRequest, Empty, OperationMetadata> deleteAttachedClusterOperationSettings() {
            return this.deleteAttachedClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAttachedServerConfigRequest, AttachedServerConfig> getAttachedServerConfigSettings() {
            return this.getAttachedServerConfigSettings;
        }

        public UnaryCallSettings.Builder<GenerateAttachedClusterInstallManifestRequest, GenerateAttachedClusterInstallManifestResponse> generateAttachedClusterInstallManifestSettings() {
            return this.generateAttachedClusterInstallManifestSettings;
        }

        public AttachedClustersStubSettings build() throws IOException {
            return new AttachedClustersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

