/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import java.util.Objects;
import javax.annotation.Nullable;

public class VectorQueryOptions {
    @Nullable
    private final FieldPath distanceResultField;
    @Nullable
    private final Double distanceThreshold;
    private static VectorQueryOptions DEFAULT = VectorQueryOptions.newBuilder().build();

    @Nullable
    public FieldPath getDistanceResultField() {
        return this.distanceResultField;
    }

    @Nullable
    public Double getDistanceThreshold() {
        return this.distanceThreshold;
    }

    VectorQueryOptions(Builder builder) {
        this.distanceThreshold = builder.distanceThreshold;
        this.distanceResultField = builder.distanceResultField;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof VectorQueryOptions)) {
            return false;
        }
        VectorQueryOptions otherOptions = (VectorQueryOptions)obj;
        return Objects.equals(this.distanceResultField, otherOptions.distanceResultField) && Objects.equals(this.distanceThreshold, otherOptions.distanceThreshold);
    }

    static VectorQueryOptions getDefaultInstance() {
        return DEFAULT;
    }

    public static final class Builder {
        @Nullable
        private FieldPath distanceResultField;
        @Nullable
        private Double distanceThreshold;

        private Builder() {
            this.distanceThreshold = null;
            this.distanceResultField = null;
        }

        private Builder(VectorQueryOptions options) {
            this.distanceThreshold = options.distanceThreshold;
            this.distanceResultField = options.distanceResultField;
        }

        public Builder setDistanceResultField(@Nullable String fieldPath) {
            this.distanceResultField = FieldPath.fromDotSeparatedString(fieldPath);
            return this;
        }

        public Builder setDistanceResultField(@Nullable FieldPath fieldPath) {
            this.distanceResultField = fieldPath;
            return this;
        }

        public Builder setDistanceThreshold(@Nullable Double distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
            return this;
        }

        public VectorQueryOptions build() {
            return new VectorQueryOptions(this);
        }
    }
}

