/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.firestore.v1.DocumentMask;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public final class FieldMask {
    static final FieldMask EMPTY_MASK = new FieldMask((SortedSet<FieldPath>)new TreeSet<FieldPath>());
    private final SortedSet<FieldPath> fieldPaths;

    FieldMask(Collection<FieldPath> fieldPaths) {
        this((SortedSet<FieldPath>)new TreeSet<FieldPath>(fieldPaths));
    }

    private FieldMask(SortedSet<FieldPath> fieldPaths) {
        this.fieldPaths = fieldPaths;
    }

    @Nonnull
    public static FieldMask of(String ... fieldPaths) {
        TreeSet<FieldPath> paths = new TreeSet<FieldPath>();
        for (String fieldPath : fieldPaths) {
            paths.add(FieldPath.fromDotSeparatedString(fieldPath));
        }
        return new FieldMask((SortedSet<FieldPath>)paths);
    }

    @Nonnull
    public static FieldMask of(FieldPath ... fieldPaths) {
        TreeSet<FieldPath> paths = new TreeSet<FieldPath>();
        Collections.addAll(paths, fieldPaths);
        return new FieldMask((SortedSet<FieldPath>)paths);
    }

    static FieldMask fromObject(Map<String, Object> values) {
        TreeSet<FieldPath> fieldPaths = FieldMask.extractFromMap(values, FieldPath.empty());
        return new FieldMask((SortedSet<FieldPath>)fieldPaths);
    }

    private static TreeSet<FieldPath> extractFromMap(Map<String, Object> values, FieldPath path) {
        TreeSet<FieldPath> fieldPaths = new TreeSet<FieldPath>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            FieldPath childPath = path.append(FieldPath.of(entry.getKey()));
            if (entry.getValue() instanceof FieldValue) {
                if (!((FieldValue)entry.getValue()).includeInDocumentMask()) continue;
                fieldPaths.add(childPath);
                continue;
            }
            if (value instanceof Map) {
                fieldPaths.addAll(FieldMask.extractFromMap((Map)value, childPath));
                continue;
            }
            fieldPaths.add(childPath);
        }
        return fieldPaths;
    }

    DocumentMask toPb() {
        DocumentMask.Builder updateMask = DocumentMask.newBuilder();
        for (FieldPath fieldPath : this.fieldPaths) {
            updateMask.addFieldPaths(fieldPath.getEncodedPath());
        }
        return updateMask.build();
    }

    boolean isEmpty() {
        return this.fieldPaths.isEmpty();
    }
}

