/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.CurrentMillisClock;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.TraceUtil;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.WriteResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class TransactionRunner<T> {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Status TOO_MANY_RETRIES_STATUS = Status.ABORTED.withDescription("too many retries");
    private static final Status USER_CALLBACK_FAILED = Status.ABORTED.withDescription("user callback failed");
    private final Transaction.AsyncFunction<T> userCallback;
    private final Span span;
    private final FirestoreImpl firestore;
    private final ScheduledExecutorService firestoreExecutor;
    private final Executor userCallbackExecutor;
    private final ExponentialRetryAlgorithm backoffAlgorithm;
    private final TransactionOptions transactionOptions;
    private TimedAttemptSettings nextBackoffAttempt;
    private Transaction transaction;
    private int attemptsRemaining;

    TransactionRunner(FirestoreImpl firestore, Transaction.AsyncFunction<T> userCallback, TransactionOptions transactionOptions) {
        this.transactionOptions = transactionOptions;
        this.span = tracer.spanBuilder("CloudFirestore.Transaction").startSpan();
        this.firestore = firestore;
        this.firestoreExecutor = firestore.getClient().getExecutor();
        this.userCallback = userCallback;
        this.attemptsRemaining = transactionOptions.getNumberOfAttempts();
        this.userCallbackExecutor = Context.currentContextExecutor((Executor)(transactionOptions.getExecutor() != null ? transactionOptions.getExecutor() : this.firestore.getClient().getExecutor()));
        this.backoffAlgorithm = new ExponentialRetryAlgorithm(firestore.getOptions().getRetrySettings(), CurrentMillisClock.getDefaultClock());
        this.nextBackoffAttempt = this.backoffAlgorithm.createFirstAttempt();
    }

    ApiFuture<T> run() {
        this.transaction = new Transaction(this.firestore, this.transactionOptions, this.transaction);
        --this.attemptsRemaining;
        this.span.addAnnotation("Start runTransaction", (Map)ImmutableMap.of((Object)"attemptsRemaining", (Object)AttributeValue.longAttributeValue((long)this.attemptsRemaining)));
        return ApiFutures.catchingAsync((ApiFuture)ApiFutures.transformAsync(this.maybeRollback(), (ApiAsyncFunction)new RollbackCallback(), (Executor)MoreExecutors.directExecutor()), Throwable.class, (ApiAsyncFunction)new RestartTransactionCallback(), (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<Void> maybeRollback() {
        return this.transaction.hasTransactionId() ? this.transaction.rollback() : ApiFutures.immediateFuture(null);
    }

    private SettableApiFuture<T> invokeUserCallback() {
        final SettableApiFuture returnedResult = SettableApiFuture.create();
        this.userCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ApiFuture userCallbackResult;
                try {
                    userCallbackResult = TransactionRunner.this.userCallback.updateCallback(TransactionRunner.this.transaction);
                }
                catch (Exception e) {
                    userCallbackResult = ApiFutures.immediateFailedFuture((Throwable)e);
                }
                ApiFutures.addCallback(userCallbackResult, (ApiFutureCallback)new ApiFutureCallback<T>(){

                    public void onFailure(Throwable t) {
                        returnedResult.setException(t);
                    }

                    public void onSuccess(T result) {
                        returnedResult.set(result);
                    }
                }, (Executor)TransactionRunner.this.firestoreExecutor);
            }
        });
        return returnedResult;
    }

    private class RestartTransactionCallback
    implements ApiAsyncFunction<Throwable, T> {
        private RestartTransactionCallback() {
        }

        public ApiFuture<T> apply(Throwable throwable) {
            if (!(throwable instanceof ApiException)) {
                TransactionRunner.this.span.setStatus(USER_CALLBACK_FAILED);
                return this.rollbackAndReject(throwable);
            }
            ApiException apiException = (ApiException)throwable;
            if (TransactionRunner.this.transaction.hasTransactionId() && this.isRetryableTransactionError(apiException)) {
                if (TransactionRunner.this.attemptsRemaining > 0) {
                    TransactionRunner.this.span.addAnnotation("retrying");
                    return TransactionRunner.this.run();
                }
                TransactionRunner.this.span.setStatus(TOO_MANY_RETRIES_STATUS);
                FirestoreException firestoreException = FirestoreException.forApiException(apiException, "Transaction was cancelled because of too many retries.");
                return this.rollbackAndReject((Throwable)((Object)firestoreException));
            }
            TransactionRunner.this.span.setStatus(TraceUtil.statusFromApiException(apiException));
            FirestoreException firestoreException = FirestoreException.forApiException(apiException, "Transaction failed with non-retryable error");
            return this.rollbackAndReject((Throwable)((Object)firestoreException));
        }

        private boolean isRetryableTransactionError(ApiException exception) {
            switch (exception.getStatusCode().getCode()) {
                case ABORTED: 
                case CANCELLED: 
                case UNKNOWN: 
                case DEADLINE_EXCEEDED: 
                case INTERNAL: 
                case UNAVAILABLE: 
                case UNAUTHENTICATED: 
                case RESOURCE_EXHAUSTED: {
                    return true;
                }
                case INVALID_ARGUMENT: {
                    return exception.getMessage().contains("transaction has expired");
                }
            }
            return false;
        }

        private ApiFuture<T> rollbackAndReject(final Throwable throwable) {
            final SettableApiFuture failedTransaction = SettableApiFuture.create();
            if (TransactionRunner.this.transaction.hasTransactionId()) {
                TransactionRunner.this.transaction.rollback().addListener(new Runnable(){

                    @Override
                    public void run() {
                        failedTransaction.setException(throwable);
                    }
                }, MoreExecutors.directExecutor());
            } else {
                failedTransaction.setException(throwable);
            }
            TransactionRunner.this.span.end();
            return failedTransaction;
        }
    }

    private class CommitTransactionCallback
    implements ApiFunction<List<WriteResult>, T> {
        private final T userFunctionResult;

        CommitTransactionCallback(T userFunctionResult) {
            this.userFunctionResult = userFunctionResult;
        }

        public T apply(List<WriteResult> input) {
            TransactionRunner.this.span.setStatus(Status.OK);
            TransactionRunner.this.span.end();
            return this.userFunctionResult;
        }
    }

    private class UserFunctionCallback
    implements ApiAsyncFunction<T, T> {
        private UserFunctionCallback() {
        }

        public ApiFuture<T> apply(T userFunctionResult) {
            return ApiFutures.transform(TransactionRunner.this.transaction.commit(), (ApiFunction)new CommitTransactionCallback(userFunctionResult), (Executor)MoreExecutors.directExecutor());
        }
    }

    private class BeginTransactionCallback
    implements ApiAsyncFunction<Void, T> {
        private BeginTransactionCallback() {
        }

        public ApiFuture<T> apply(Void ignored) {
            return ApiFutures.transformAsync((ApiFuture)TransactionRunner.this.invokeUserCallback(), (ApiAsyncFunction)new UserFunctionCallback(), (Executor)MoreExecutors.directExecutor());
        }
    }

    private class BackoffCallback
    implements ApiAsyncFunction<Void, T> {
        private BackoffCallback() {
        }

        public ApiFuture<T> apply(Void input) {
            return ApiFutures.transformAsync(TransactionRunner.this.transaction.begin(), (ApiAsyncFunction)new BeginTransactionCallback(), (Executor)MoreExecutors.directExecutor());
        }
    }

    private class RollbackCallback
    implements ApiAsyncFunction<Void, T> {
        private RollbackCallback() {
        }

        public ApiFuture<T> apply(Void input) {
            final SettableApiFuture backoff = SettableApiFuture.create();
            TransactionRunner.this.firestoreExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    backoff.set(null);
                }
            }, TransactionRunner.this.nextBackoffAttempt.getRandomizedRetryDelay().toMillis(), TimeUnit.MILLISECONDS);
            TransactionRunner.this.nextBackoffAttempt = TransactionRunner.this.backoffAlgorithm.createNextAttempt(TransactionRunner.this.nextBackoffAttempt);
            return ApiFutures.transformAsync((ApiFuture)backoff, (ApiAsyncFunction)new BackoffCallback(), (Executor)MoreExecutors.directExecutor());
        }
    }
}

