/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.Watch;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.ListCollectionIdsRequest;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class DocumentReference {
    private final ResourcePath path;
    private final FirestoreRpcContext<?> rpcContext;

    DocumentReference(FirestoreRpcContext<?> rpcContext, ResourcePath path) {
        this.path = path;
        this.rpcContext = rpcContext;
    }

    @Nonnull
    public Firestore getFirestore() {
        return this.rpcContext.getFirestore();
    }

    @Nonnull
    public String getId() {
        return this.path.getId();
    }

    @Nonnull
    public String getPath() {
        return this.path.getPath();
    }

    @Nonnull
    String getName() {
        return this.path.getName();
    }

    @Nonnull
    public CollectionReference getParent() {
        return new CollectionReference(this.rpcContext, (ResourcePath)this.path.getParent());
    }

    @Nonnull
    public CollectionReference collection(@Nonnull String collectionPath) {
        return new CollectionReference(this.rpcContext, (ResourcePath)this.path.append(collectionPath));
    }

    private <T> ApiFuture<T> extractFirst(ApiFuture<List<T>> results) {
        return ApiFutures.transform(results, (ApiFunction)new ApiFunction<List<T>, T>(){

            public T apply(List<T> results) {
                return results.isEmpty() ? null : (Object)results.get(0);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Nonnull
    public ApiFuture<WriteResult> create(@Nonnull Map<String, Object> fields) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.create(this, fields)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> create(@Nonnull Object pojo) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.create(this, pojo)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Map<String, Object> fields) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, fields)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, fields, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Object pojo) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, pojo)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Object pojo, @Nonnull SetOptions options) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, pojo, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Map<String, Object> fields) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, fields)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Map<String, Object> fields, Precondition options) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, fields, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, field, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, fieldPath, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Precondition options, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, options, field, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Precondition options, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, options, fieldPath, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> delete(@Nonnull Precondition options) {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.delete(this, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> delete() {
        WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
        return this.extractFirst(((WriteBatch)writeBatch.delete(this)).commit());
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get() {
        return this.extractFirst(this.rpcContext.getFirestore().getAll(this));
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get(FieldMask fieldMask) {
        return this.extractFirst(this.rpcContext.getFirestore().getAll(new DocumentReference[]{this}, fieldMask));
    }

    @Nonnull
    public Iterable<CollectionReference> listCollections() {
        FirestoreClient.ListCollectionIdsPagedResponse response;
        ListCollectionIdsRequest.Builder request = ListCollectionIdsRequest.newBuilder();
        request.setParent(this.path.toString());
        try {
            response = (FirestoreClient.ListCollectionIdsPagedResponse)((Object)ApiExceptions.callAndTranslateApiException(this.rpcContext.sendRequest(request.build(), this.rpcContext.getClient().listCollectionIdsPagedCallable())));
        }
        catch (ApiException exception) {
            throw FirestoreException.apiException(exception);
        }
        return new Iterable<CollectionReference>(){

            @Override
            @Nonnull
            public Iterator<CollectionReference> iterator() {
                final Iterator iterator = response.iterateAll().iterator();
                return new Iterator<CollectionReference>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public CollectionReference next() {
                        return DocumentReference.this.collection((String)iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull Executor executor, final @Nonnull EventListener<DocumentSnapshot> listener) {
        return Watch.forDocument(this).runWatch(executor, new EventListener<QuerySnapshot>(){

            @Override
            public void onEvent(@Nullable QuerySnapshot value, @Nullable FirestoreException error) {
                if (value == null) {
                    listener.onEvent(null, error);
                    return;
                }
                for (DocumentSnapshot doc : value) {
                    if (!doc.getReference().equals(DocumentReference.this)) continue;
                    listener.onEvent(value.getDocuments().get(0), null);
                    return;
                }
                listener.onEvent(DocumentSnapshot.fromMissing(DocumentReference.this.rpcContext, DocumentReference.this, value.getReadTime()), null);
            }
        });
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull EventListener<DocumentSnapshot> listener) {
        return this.addSnapshotListener(this.rpcContext.getClient().getExecutor(), listener);
    }

    ResourcePath getResourcePath() {
        return this.path;
    }

    public String toString() {
        return String.format("DocumentReference{path=%s}", this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentReference that = (DocumentReference)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.rpcContext, that.rpcContext);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.rpcContext);
    }
}

