/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.ResourcePath;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.Map;
import javax.annotation.Nonnull;

public class QueryDocumentSnapshot
extends DocumentSnapshot {
    protected QueryDocumentSnapshot(FirestoreImpl firestore, DocumentReference docRef, Map<String, Value> fields, Timestamp readTime, Timestamp updateTime, Timestamp createTime) {
        super(firestore, docRef, fields, readTime, updateTime, createTime);
    }

    static QueryDocumentSnapshot fromDocument(FirestoreImpl firestore, Timestamp readTime, Document document) {
        return new QueryDocumentSnapshot(firestore, new DocumentReference(firestore, ResourcePath.create(document.getName())), document.getFieldsMap(), readTime, Timestamp.fromProto((com.google.protobuf.Timestamp)document.getUpdateTime()), Timestamp.fromProto((com.google.protobuf.Timestamp)document.getCreateTime()));
    }

    @Override
    @Nonnull
    public Map<String, Object> getData() {
        Map<String, Object> result = super.getData();
        Preconditions.checkNotNull(result, (Object)"Data in a QueryDocumentSnapshot should be non-null");
        return result;
    }

    @Override
    @Nonnull
    public <T> T toObject(@Nonnull Class<T> valueType) {
        T result = super.toObject(valueType);
        Preconditions.checkNotNull(result, (Object)"Object in a QueryDocumentSnapshot should be non-null");
        return result;
    }
}

