/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.protobuf.Timestamp;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class WriteResult {
    private final Instant updateTime;

    private WriteResult(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Nonnull
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    static WriteResult fromProto(com.google.firestore.v1beta1.WriteResult writeResult, Timestamp commitTime) {
        Timestamp timestamp = writeResult.hasUpdateTime() ? writeResult.getUpdateTime() : commitTime;
        Instant instant = Instant.ofEpochSecond((long)timestamp.getSeconds(), (long)timestamp.getNanos());
        return new WriteResult(instant);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WriteResult that = (WriteResult)obj;
        return Objects.equals(this.updateTime, that.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.updateTime);
    }
}

