/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcSettings;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.LocationName;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.TriggerName;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.EventarcStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EventarcClient
implements BackgroundResource {
    private final EventarcSettings settings;
    private final EventarcStub stub;
    private final OperationsClient operationsClient;

    public static final EventarcClient create() throws IOException {
        return EventarcClient.create(EventarcSettings.newBuilder().build());
    }

    public static final EventarcClient create(EventarcSettings settings) throws IOException {
        return new EventarcClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EventarcClient create(EventarcStub stub) {
        return new EventarcClient(stub);
    }

    protected EventarcClient(EventarcSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EventarcStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EventarcClient(EventarcStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final EventarcSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EventarcStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Trigger getTrigger(TriggerName name) {
        GetTriggerRequest request = GetTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTrigger(request);
    }

    public final Trigger getTrigger(String name) {
        GetTriggerRequest request = GetTriggerRequest.newBuilder().setName(name).build();
        return this.getTrigger(request);
    }

    public final Trigger getTrigger(GetTriggerRequest request) {
        return (Trigger)this.getTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable() {
        return this.stub.getTriggerCallable();
    }

    public final ListTriggersPagedResponse listTriggers(LocationName parent) {
        ListTriggersRequest request = ListTriggersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTriggers(request);
    }

    public final ListTriggersPagedResponse listTriggers(String parent) {
        ListTriggersRequest request = ListTriggersRequest.newBuilder().setParent(parent).build();
        return this.listTriggers(request);
    }

    public final ListTriggersPagedResponse listTriggers(ListTriggersRequest request) {
        return (ListTriggersPagedResponse)((Object)this.listTriggersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTriggersRequest, ListTriggersPagedResponse> listTriggersPagedCallable() {
        return this.stub.listTriggersPagedCallable();
    }

    public final UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable() {
        return this.stub.listTriggersCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(LocationName parent, Trigger trigger, String triggerId) {
        CreateTriggerRequest request = CreateTriggerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTrigger(trigger).setTriggerId(triggerId).build();
        return this.createTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(String parent, Trigger trigger, String triggerId) {
        CreateTriggerRequest request = CreateTriggerRequest.newBuilder().setParent(parent).setTrigger(trigger).setTriggerId(triggerId).build();
        return this.createTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(CreateTriggerRequest request) {
        return this.createTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable() {
        return this.stub.createTriggerOperationCallable();
    }

    public final UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable() {
        return this.stub.createTriggerCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> updateTriggerAsync(Trigger trigger, FieldMask updateMask, boolean allowMissing) {
        UpdateTriggerRequest request = UpdateTriggerRequest.newBuilder().setTrigger(trigger).setUpdateMask(updateMask).setAllowMissing(allowMissing).build();
        return this.updateTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> updateTriggerAsync(UpdateTriggerRequest request) {
        return this.updateTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable() {
        return this.stub.updateTriggerOperationCallable();
    }

    public final UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable() {
        return this.stub.updateTriggerCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(TriggerName name, boolean allowMissing) {
        DeleteTriggerRequest request = DeleteTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).setAllowMissing(allowMissing).build();
        return this.deleteTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(String name, boolean allowMissing) {
        DeleteTriggerRequest request = DeleteTriggerRequest.newBuilder().setName(name).setAllowMissing(allowMissing).build();
        return this.deleteTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(DeleteTriggerRequest request) {
        return this.deleteTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable() {
        return this.stub.deleteTriggerOperationCallable();
    }

    public final UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable() {
        return this.stub.deleteTriggerCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTriggersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage, ListTriggersFixedSizeCollection> {
        private ListTriggersFixedSizeCollection(List<ListTriggersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTriggersFixedSizeCollection createEmptyCollection() {
            return new ListTriggersFixedSizeCollection(null, 0);
        }

        protected ListTriggersFixedSizeCollection createCollection(List<ListTriggersPage> pages, int collectionSize) {
            return new ListTriggersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTriggersPage
    extends AbstractPage<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage> {
        private ListTriggersPage(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ListTriggersResponse response) {
            super(context, (Object)response);
        }

        private static ListTriggersPage createEmptyPage() {
            return new ListTriggersPage(null, null);
        }

        protected ListTriggersPage createPage(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ListTriggersResponse response) {
            return new ListTriggersPage(context, response);
        }

        public ApiFuture<ListTriggersPage> createPageAsync(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ApiFuture<ListTriggersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTriggersPagedResponse
    extends AbstractPagedListResponse<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage, ListTriggersFixedSizeCollection> {
        public static ApiFuture<ListTriggersPagedResponse> createAsync(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ApiFuture<ListTriggersResponse> futureResponse) {
            ApiFuture<ListTriggersPage> futurePage = ListTriggersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTriggersPage, ListTriggersPagedResponse>(){

                public ListTriggersPagedResponse apply(ListTriggersPage input) {
                    return new ListTriggersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTriggersPagedResponse(ListTriggersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTriggersFixedSizeCollection.createEmptyCollection());
        }
    }
}

