/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.essentialcontacts.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.essentialcontacts.v1.ComputeContactsRequest;
import com.google.cloud.essentialcontacts.v1.ComputeContactsResponse;
import com.google.cloud.essentialcontacts.v1.Contact;
import com.google.cloud.essentialcontacts.v1.CreateContactRequest;
import com.google.cloud.essentialcontacts.v1.DeleteContactRequest;
import com.google.cloud.essentialcontacts.v1.EssentialContactsServiceClient;
import com.google.cloud.essentialcontacts.v1.GetContactRequest;
import com.google.cloud.essentialcontacts.v1.ListContactsRequest;
import com.google.cloud.essentialcontacts.v1.ListContactsResponse;
import com.google.cloud.essentialcontacts.v1.SendTestMessageRequest;
import com.google.cloud.essentialcontacts.v1.UpdateContactRequest;
import com.google.cloud.essentialcontacts.v1.stub.EssentialContactsServiceStub;
import com.google.cloud.essentialcontacts.v1.stub.GrpcEssentialContactsServiceStub;
import com.google.cloud.essentialcontacts.v1.stub.HttpJsonEssentialContactsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EssentialContactsServiceStubSettings
extends StubSettings<EssentialContactsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateContactRequest, Contact> createContactSettings;
    private final UnaryCallSettings<UpdateContactRequest, Contact> updateContactSettings;
    private final PagedCallSettings<ListContactsRequest, ListContactsResponse, EssentialContactsServiceClient.ListContactsPagedResponse> listContactsSettings;
    private final UnaryCallSettings<GetContactRequest, Contact> getContactSettings;
    private final UnaryCallSettings<DeleteContactRequest, Empty> deleteContactSettings;
    private final PagedCallSettings<ComputeContactsRequest, ComputeContactsResponse, EssentialContactsServiceClient.ComputeContactsPagedResponse> computeContactsSettings;
    private final UnaryCallSettings<SendTestMessageRequest, Empty> sendTestMessageSettings;
    private static final PagedListDescriptor<ListContactsRequest, ListContactsResponse, Contact> LIST_CONTACTS_PAGE_STR_DESC = new PagedListDescriptor<ListContactsRequest, ListContactsResponse, Contact>(){

        public String emptyToken() {
            return "";
        }

        public ListContactsRequest injectToken(ListContactsRequest payload, String token) {
            return ListContactsRequest.newBuilder((ListContactsRequest)payload).setPageToken(token).build();
        }

        public ListContactsRequest injectPageSize(ListContactsRequest payload, int pageSize) {
            return ListContactsRequest.newBuilder((ListContactsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListContactsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListContactsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Contact> extractResources(ListContactsResponse payload) {
            return payload.getContactsList() == null ? ImmutableList.of() : payload.getContactsList();
        }
    };
    private static final PagedListDescriptor<ComputeContactsRequest, ComputeContactsResponse, Contact> COMPUTE_CONTACTS_PAGE_STR_DESC = new PagedListDescriptor<ComputeContactsRequest, ComputeContactsResponse, Contact>(){

        public String emptyToken() {
            return "";
        }

        public ComputeContactsRequest injectToken(ComputeContactsRequest payload, String token) {
            return ComputeContactsRequest.newBuilder((ComputeContactsRequest)payload).setPageToken(token).build();
        }

        public ComputeContactsRequest injectPageSize(ComputeContactsRequest payload, int pageSize) {
            return ComputeContactsRequest.newBuilder((ComputeContactsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ComputeContactsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ComputeContactsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Contact> extractResources(ComputeContactsResponse payload) {
            return payload.getContactsList() == null ? ImmutableList.of() : payload.getContactsList();
        }
    };
    private static final PagedListResponseFactory<ListContactsRequest, ListContactsResponse, EssentialContactsServiceClient.ListContactsPagedResponse> LIST_CONTACTS_PAGE_STR_FACT = new PagedListResponseFactory<ListContactsRequest, ListContactsResponse, EssentialContactsServiceClient.ListContactsPagedResponse>(){

        public ApiFuture<EssentialContactsServiceClient.ListContactsPagedResponse> getFuturePagedResponse(UnaryCallable<ListContactsRequest, ListContactsResponse> callable, ListContactsRequest request, ApiCallContext context, ApiFuture<ListContactsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTACTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EssentialContactsServiceClient.ListContactsPagedResponse.createAsync((PageContext<ListContactsRequest, ListContactsResponse, Contact>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ComputeContactsRequest, ComputeContactsResponse, EssentialContactsServiceClient.ComputeContactsPagedResponse> COMPUTE_CONTACTS_PAGE_STR_FACT = new PagedListResponseFactory<ComputeContactsRequest, ComputeContactsResponse, EssentialContactsServiceClient.ComputeContactsPagedResponse>(){

        public ApiFuture<EssentialContactsServiceClient.ComputeContactsPagedResponse> getFuturePagedResponse(UnaryCallable<ComputeContactsRequest, ComputeContactsResponse> callable, ComputeContactsRequest request, ApiCallContext context, ApiFuture<ComputeContactsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)COMPUTE_CONTACTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EssentialContactsServiceClient.ComputeContactsPagedResponse.createAsync((PageContext<ComputeContactsRequest, ComputeContactsResponse, Contact>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateContactRequest, Contact> createContactSettings() {
        return this.createContactSettings;
    }

    public UnaryCallSettings<UpdateContactRequest, Contact> updateContactSettings() {
        return this.updateContactSettings;
    }

    public PagedCallSettings<ListContactsRequest, ListContactsResponse, EssentialContactsServiceClient.ListContactsPagedResponse> listContactsSettings() {
        return this.listContactsSettings;
    }

    public UnaryCallSettings<GetContactRequest, Contact> getContactSettings() {
        return this.getContactSettings;
    }

    public UnaryCallSettings<DeleteContactRequest, Empty> deleteContactSettings() {
        return this.deleteContactSettings;
    }

    public PagedCallSettings<ComputeContactsRequest, ComputeContactsResponse, EssentialContactsServiceClient.ComputeContactsPagedResponse> computeContactsSettings() {
        return this.computeContactsSettings;
    }

    public UnaryCallSettings<SendTestMessageRequest, Empty> sendTestMessageSettings() {
        return this.sendTestMessageSettings;
    }

    public EssentialContactsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEssentialContactsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEssentialContactsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return EssentialContactsServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "essentialcontacts";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "essentialcontacts.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "essentialcontacts.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EssentialContactsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EssentialContactsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EssentialContactsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EssentialContactsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EssentialContactsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createContactSettings = settingsBuilder.createContactSettings().build();
        this.updateContactSettings = settingsBuilder.updateContactSettings().build();
        this.listContactsSettings = settingsBuilder.listContactsSettings().build();
        this.getContactSettings = settingsBuilder.getContactSettings().build();
        this.deleteContactSettings = settingsBuilder.deleteContactSettings().build();
        this.computeContactsSettings = settingsBuilder.computeContactsSettings().build();
        this.sendTestMessageSettings = settingsBuilder.sendTestMessageSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EssentialContactsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateContactRequest, Contact> createContactSettings;
        private final UnaryCallSettings.Builder<UpdateContactRequest, Contact> updateContactSettings;
        private final PagedCallSettings.Builder<ListContactsRequest, ListContactsResponse, EssentialContactsServiceClient.ListContactsPagedResponse> listContactsSettings;
        private final UnaryCallSettings.Builder<GetContactRequest, Contact> getContactSettings;
        private final UnaryCallSettings.Builder<DeleteContactRequest, Empty> deleteContactSettings;
        private final PagedCallSettings.Builder<ComputeContactsRequest, ComputeContactsResponse, EssentialContactsServiceClient.ComputeContactsPagedResponse> computeContactsSettings;
        private final UnaryCallSettings.Builder<SendTestMessageRequest, Empty> sendTestMessageSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createContactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateContactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listContactsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTACTS_PAGE_STR_FACT);
            this.getContactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteContactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.computeContactsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)COMPUTE_CONTACTS_PAGE_STR_FACT);
            this.sendTestMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createContactSettings, this.updateContactSettings, this.listContactsSettings, this.getContactSettings, this.deleteContactSettings, this.computeContactsSettings, this.sendTestMessageSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EssentialContactsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createContactSettings = settings.createContactSettings.toBuilder();
            this.updateContactSettings = settings.updateContactSettings.toBuilder();
            this.listContactsSettings = settings.listContactsSettings.toBuilder();
            this.getContactSettings = settings.getContactSettings.toBuilder();
            this.deleteContactSettings = settings.deleteContactSettings.toBuilder();
            this.computeContactsSettings = settings.computeContactsSettings.toBuilder();
            this.sendTestMessageSettings = settings.sendTestMessageSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createContactSettings, this.updateContactSettings, this.listContactsSettings, this.getContactSettings, this.deleteContactSettings, this.computeContactsSettings, this.sendTestMessageSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EssentialContactsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EssentialContactsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EssentialContactsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EssentialContactsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EssentialContactsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EssentialContactsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EssentialContactsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EssentialContactsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createContactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateContactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listContactsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getContactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteContactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.computeContactsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.sendTestMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateContactRequest, Contact> createContactSettings() {
            return this.createContactSettings;
        }

        public UnaryCallSettings.Builder<UpdateContactRequest, Contact> updateContactSettings() {
            return this.updateContactSettings;
        }

        public PagedCallSettings.Builder<ListContactsRequest, ListContactsResponse, EssentialContactsServiceClient.ListContactsPagedResponse> listContactsSettings() {
            return this.listContactsSettings;
        }

        public UnaryCallSettings.Builder<GetContactRequest, Contact> getContactSettings() {
            return this.getContactSettings;
        }

        public UnaryCallSettings.Builder<DeleteContactRequest, Empty> deleteContactSettings() {
            return this.deleteContactSettings;
        }

        public PagedCallSettings.Builder<ComputeContactsRequest, ComputeContactsResponse, EssentialContactsServiceClient.ComputeContactsPagedResponse> computeContactsSettings() {
            return this.computeContactsSettings;
        }

        public UnaryCallSettings.Builder<SendTestMessageRequest, Empty> sendTestMessageSettings() {
            return this.sendTestMessageSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return EssentialContactsServiceStubSettings.getDefaultEndpoint();
        }

        public EssentialContactsServiceStubSettings build() throws IOException {
            return new EssentialContactsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

