/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.essentialcontacts.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.essentialcontacts.v1.ComputeContactsRequest;
import com.google.cloud.essentialcontacts.v1.ComputeContactsResponse;
import com.google.cloud.essentialcontacts.v1.Contact;
import com.google.cloud.essentialcontacts.v1.CreateContactRequest;
import com.google.cloud.essentialcontacts.v1.DeleteContactRequest;
import com.google.cloud.essentialcontacts.v1.EssentialContactsServiceClient;
import com.google.cloud.essentialcontacts.v1.GetContactRequest;
import com.google.cloud.essentialcontacts.v1.ListContactsRequest;
import com.google.cloud.essentialcontacts.v1.ListContactsResponse;
import com.google.cloud.essentialcontacts.v1.SendTestMessageRequest;
import com.google.cloud.essentialcontacts.v1.UpdateContactRequest;
import com.google.cloud.essentialcontacts.v1.stub.EssentialContactsServiceStub;
import com.google.cloud.essentialcontacts.v1.stub.EssentialContactsServiceStubSettings;
import com.google.cloud.essentialcontacts.v1.stub.HttpJsonEssentialContactsServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonEssentialContactsServiceStub
extends EssentialContactsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateContactRequest, Contact> createContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/CreateContact").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/contacts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*}/contacts", "/v1/{parent=organizations/*}/contacts"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("contact", (Message)request.getContact())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Contact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateContactRequest, Contact> updateContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/UpdateContact").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{contact.name=projects/*/contacts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "contact.name", (Object)request.getContact().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{contact.name=folders/*/contacts/*}", "/v1/{contact.name=organizations/*/contacts/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("contact", (Message)request.getContact())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Contact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListContactsRequest, ListContactsResponse> listContactsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/ListContacts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/contacts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*}/contacts", "/v1/{parent=organizations/*}/contacts"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListContactsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetContactRequest, Contact> getContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/GetContact").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/contacts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=folders/*/contacts/*}", "/v1/{name=organizations/*/contacts/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Contact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteContactRequest, Empty> deleteContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/DeleteContact").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/contacts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=folders/*/contacts/*}", "/v1/{name=organizations/*/contacts/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ComputeContactsRequest, ComputeContactsResponse> computeContactsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/ComputeContacts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/contacts:compute", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*}/contacts:compute", "/v1/{parent=organizations/*}/contacts:compute"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "notificationCategories", (Object)request.getNotificationCategoriesList());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ComputeContactsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SendTestMessageRequest, Empty> sendTestMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.essentialcontacts.v1.EssentialContactsService/SendTestMessage").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*}/contacts:sendTestMessage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=folders/*}/contacts:sendTestMessage", "/v1/{resource=organizations/*}/contacts:sendTestMessage"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateContactRequest, Contact> createContactCallable;
    private final UnaryCallable<UpdateContactRequest, Contact> updateContactCallable;
    private final UnaryCallable<ListContactsRequest, ListContactsResponse> listContactsCallable;
    private final UnaryCallable<ListContactsRequest, EssentialContactsServiceClient.ListContactsPagedResponse> listContactsPagedCallable;
    private final UnaryCallable<GetContactRequest, Contact> getContactCallable;
    private final UnaryCallable<DeleteContactRequest, Empty> deleteContactCallable;
    private final UnaryCallable<ComputeContactsRequest, ComputeContactsResponse> computeContactsCallable;
    private final UnaryCallable<ComputeContactsRequest, EssentialContactsServiceClient.ComputeContactsPagedResponse> computeContactsPagedCallable;
    private final UnaryCallable<SendTestMessageRequest, Empty> sendTestMessageCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonEssentialContactsServiceStub create(EssentialContactsServiceStubSettings settings) throws IOException {
        return new HttpJsonEssentialContactsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonEssentialContactsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonEssentialContactsServiceStub(EssentialContactsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonEssentialContactsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonEssentialContactsServiceStub(EssentialContactsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonEssentialContactsServiceStub(EssentialContactsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonEssentialContactsServiceCallableFactory());
    }

    protected HttpJsonEssentialContactsServiceStub(EssentialContactsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createContactMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateContactMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listContactsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listContactsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getContactMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteContactMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings computeContactsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(computeContactsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings sendTestMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(sendTestMessageMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createContactCallable = callableFactory.createUnaryCallable(createContactTransportSettings, settings.createContactSettings(), clientContext);
        this.updateContactCallable = callableFactory.createUnaryCallable(updateContactTransportSettings, settings.updateContactSettings(), clientContext);
        this.listContactsCallable = callableFactory.createUnaryCallable(listContactsTransportSettings, settings.listContactsSettings(), clientContext);
        this.listContactsPagedCallable = callableFactory.createPagedCallable(listContactsTransportSettings, settings.listContactsSettings(), clientContext);
        this.getContactCallable = callableFactory.createUnaryCallable(getContactTransportSettings, settings.getContactSettings(), clientContext);
        this.deleteContactCallable = callableFactory.createUnaryCallable(deleteContactTransportSettings, settings.deleteContactSettings(), clientContext);
        this.computeContactsCallable = callableFactory.createUnaryCallable(computeContactsTransportSettings, settings.computeContactsSettings(), clientContext);
        this.computeContactsPagedCallable = callableFactory.createPagedCallable(computeContactsTransportSettings, settings.computeContactsSettings(), clientContext);
        this.sendTestMessageCallable = callableFactory.createUnaryCallable(sendTestMessageTransportSettings, settings.sendTestMessageSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createContactMethodDescriptor);
        methodDescriptors.add(updateContactMethodDescriptor);
        methodDescriptors.add(listContactsMethodDescriptor);
        methodDescriptors.add(getContactMethodDescriptor);
        methodDescriptors.add(deleteContactMethodDescriptor);
        methodDescriptors.add(computeContactsMethodDescriptor);
        methodDescriptors.add(sendTestMessageMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateContactRequest, Contact> createContactCallable() {
        return this.createContactCallable;
    }

    @Override
    public UnaryCallable<UpdateContactRequest, Contact> updateContactCallable() {
        return this.updateContactCallable;
    }

    @Override
    public UnaryCallable<ListContactsRequest, ListContactsResponse> listContactsCallable() {
        return this.listContactsCallable;
    }

    @Override
    public UnaryCallable<ListContactsRequest, EssentialContactsServiceClient.ListContactsPagedResponse> listContactsPagedCallable() {
        return this.listContactsPagedCallable;
    }

    @Override
    public UnaryCallable<GetContactRequest, Contact> getContactCallable() {
        return this.getContactCallable;
    }

    @Override
    public UnaryCallable<DeleteContactRequest, Empty> deleteContactCallable() {
        return this.deleteContactCallable;
    }

    @Override
    public UnaryCallable<ComputeContactsRequest, ComputeContactsResponse> computeContactsCallable() {
        return this.computeContactsCallable;
    }

    @Override
    public UnaryCallable<ComputeContactsRequest, EssentialContactsServiceClient.ComputeContactsPagedResponse> computeContactsPagedCallable() {
        return this.computeContactsPagedCallable;
    }

    @Override
    public UnaryCallable<SendTestMessageRequest, Empty> sendTestMessageCallable() {
        return this.sendTestMessageCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

