/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.errorreporting.spi.v1beta1.ReportErrorsServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorEventRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorEventResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ReportErrorsServiceApi
implements AutoCloseable {
    private final ReportErrorsServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventCallable;
    private static final PathTemplate GROUP_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/groups/{group}");
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");

    public static final String formatGroupName(String project, String group) {
        return GROUP_PATH_TEMPLATE.instantiate(new String[]{"project", project, "group", group});
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String parseProjectFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"project");
    }

    public static final String parseGroupFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"group");
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final ReportErrorsServiceApi create() throws IOException {
        return ReportErrorsServiceApi.create(ReportErrorsServiceSettings.defaultBuilder().build());
    }

    public static final ReportErrorsServiceApi create(ReportErrorsServiceSettings settings) throws IOException {
        return new ReportErrorsServiceApi(settings);
    }

    protected ReportErrorsServiceApi(ReportErrorsServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.reportErrorEventCallable = UnaryCallable.create(settings.reportErrorEventSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ReportErrorsServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ReportErrorsServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final ReportErrorsServiceSettings getSettings() {
        return this.settings;
    }

    public final ReportErrorEventResponse reportErrorEvent(String projectName, ReportedErrorEvent event) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "reportErrorEvent");
        ReportErrorEventRequest request = ReportErrorEventRequest.newBuilder().setProjectName(projectName).setEvent(event).build();
        return this.reportErrorEvent(request);
    }

    public final ReportErrorEventResponse reportErrorEvent(ReportErrorEventRequest request) {
        return (ReportErrorEventResponse)this.reportErrorEventCallable().call((Object)request);
    }

    public final UnaryCallable<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventCallable() {
        return this.reportErrorEventCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

