/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.errorreporting.spi.v1beta1.ErrorStatsServiceSettings;
import com.google.cloud.errorreporting.spi.v1beta1.PagedResponseWrappers;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.QueryTimeRange;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class ErrorStatsServiceApi
implements AutoCloseable {
    private final ErrorStatsServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable;
    private final UnaryCallable<ListGroupStatsRequest, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsPagedCallable;
    private final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final UnaryCallable<ListEventsRequest, PagedResponseWrappers.ListEventsPagedResponse> listEventsPagedCallable;
    private final UnaryCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final ErrorStatsServiceApi create() throws IOException {
        return ErrorStatsServiceApi.create(ErrorStatsServiceSettings.defaultBuilder().build());
    }

    public static final ErrorStatsServiceApi create(ErrorStatsServiceSettings settings) throws IOException {
        return new ErrorStatsServiceApi(settings);
    }

    protected ErrorStatsServiceApi(ErrorStatsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.listGroupStatsCallable = UnaryCallable.create(settings.listGroupStatsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listGroupStatsPagedCallable = UnaryCallable.createPagedVariant(settings.listGroupStatsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listEventsCallable = UnaryCallable.create(settings.listEventsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listEventsPagedCallable = UnaryCallable.createPagedVariant(settings.listEventsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteEventsCallable = UnaryCallable.create(settings.deleteEventsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorStatsServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorStatsServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final ErrorStatsServiceSettings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListGroupStatsPagedResponse listGroupStats(String projectName, QueryTimeRange timeRange) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "listGroupStats");
        ListGroupStatsRequest request = ListGroupStatsRequest.newBuilder().setProjectName(projectName).setTimeRange(timeRange).build();
        return this.listGroupStats(request);
    }

    public final PagedResponseWrappers.ListGroupStatsPagedResponse listGroupStats(ListGroupStatsRequest request) {
        return (PagedResponseWrappers.ListGroupStatsPagedResponse)((Object)this.listGroupStatsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupStatsRequest, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsPagedCallable() {
        return this.listGroupStatsPagedCallable;
    }

    public final UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable() {
        return this.listGroupStatsCallable;
    }

    public final PagedResponseWrappers.ListEventsPagedResponse listEvents(String projectName, String groupId) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "listEvents");
        ListEventsRequest request = ListEventsRequest.newBuilder().setProjectName(projectName).setGroupId(groupId).build();
        return this.listEvents(request);
    }

    public final PagedResponseWrappers.ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (PagedResponseWrappers.ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, PagedResponseWrappers.ListEventsPagedResponse> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    public final DeleteEventsResponse deleteEvents(String projectName) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "deleteEvents");
        DeleteEventsRequest request = DeleteEventsRequest.newBuilder().setProjectName(projectName).build();
        return this.deleteEvents(request);
    }

    private final DeleteEventsResponse deleteEvents(DeleteEventsRequest request) {
        return (DeleteEventsResponse)this.deleteEventsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable() {
        return this.deleteEventsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

