/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.core.PagedListResponse;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.errorreporting.spi.v1beta1.ErrorStatsServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorEvent;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.QueryTimeRange;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class ErrorStatsServiceApi
implements AutoCloseable {
    private final ErrorStatsServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable;
    private final ApiCallable<ListGroupStatsRequest, PagedListResponse<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>> listGroupStatsPagedCallable;
    private final ApiCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final ApiCallable<ListEventsRequest, PagedListResponse<ListEventsRequest, ListEventsResponse, ErrorEvent>> listEventsPagedCallable;
    private final ApiCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");

    public final ErrorStatsServiceSettings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final ErrorStatsServiceApi create() throws IOException {
        return ErrorStatsServiceApi.create(ErrorStatsServiceSettings.defaultBuilder().build());
    }

    public static final ErrorStatsServiceApi create(ErrorStatsServiceSettings settings) throws IOException {
        return new ErrorStatsServiceApi(settings);
    }

    protected ErrorStatsServiceApi(ErrorStatsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.listGroupStatsCallable = ApiCallable.create(settings.listGroupStatsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listGroupStatsPagedCallable = ApiCallable.createPagedVariant(settings.listGroupStatsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listEventsCallable = ApiCallable.create(settings.listEventsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listEventsPagedCallable = ApiCallable.createPagedVariant(settings.listEventsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteEventsCallable = ApiCallable.create(settings.deleteEventsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorStatsServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorStatsServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final PagedListResponse<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> listGroupStats(String projectName, QueryTimeRange timeRange) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "listGroupStats");
        ListGroupStatsRequest request = ListGroupStatsRequest.newBuilder().setProjectName(projectName).setTimeRange(timeRange).build();
        return this.listGroupStats(request);
    }

    public final PagedListResponse<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> listGroupStats(ListGroupStatsRequest request) {
        return (PagedListResponse)this.listGroupStatsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListGroupStatsRequest, PagedListResponse<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>> listGroupStatsPagedCallable() {
        return this.listGroupStatsPagedCallable;
    }

    public final ApiCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable() {
        return this.listGroupStatsCallable;
    }

    public final PagedListResponse<ListEventsRequest, ListEventsResponse, ErrorEvent> listEvents(String projectName, String groupId) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "listEvents");
        ListEventsRequest request = ListEventsRequest.newBuilder().setProjectName(projectName).setGroupId(groupId).build();
        return this.listEvents(request);
    }

    public final PagedListResponse<ListEventsRequest, ListEventsResponse, ErrorEvent> listEvents(ListEventsRequest request) {
        return (PagedListResponse)this.listEventsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListEventsRequest, PagedListResponse<ListEventsRequest, ListEventsResponse, ErrorEvent>> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    public final ApiCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    public final DeleteEventsResponse deleteEvents(String projectName) {
        PROJECT_PATH_TEMPLATE.validate(projectName, "deleteEvents");
        DeleteEventsRequest request = DeleteEventsRequest.newBuilder().setProjectName(projectName).build();
        return this.deleteEvents(request);
    }

    private final DeleteEventsResponse deleteEvents(DeleteEventsRequest request) {
        return (DeleteEventsResponse)this.deleteEventsCallable().call((Object)request);
    }

    public final ApiCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable() {
        return this.deleteEventsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

