/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.errorreporting.spi.v1beta1.ErrorGroupServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroup;
import com.google.devtools.clouderrorreporting.v1beta1.GetGroupRequest;
import com.google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class ErrorGroupServiceApi
implements AutoCloseable {
    private final ErrorGroupServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<GetGroupRequest, ErrorGroup> getGroupCallable;
    private final ApiCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable;
    private static final PathTemplate GROUP_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/groups/{group}");

    public final ErrorGroupServiceSettings getSettings() {
        return this.settings;
    }

    public static final String formatGroupName(String project, String group) {
        return GROUP_PATH_TEMPLATE.instantiate(new String[]{"project", project, "group", group});
    }

    public static final String parseProjectFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"project");
    }

    public static final String parseGroupFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"group");
    }

    public static final ErrorGroupServiceApi create() throws IOException {
        return ErrorGroupServiceApi.create(ErrorGroupServiceSettings.defaultBuilder().build());
    }

    public static final ErrorGroupServiceApi create(ErrorGroupServiceSettings settings) throws IOException {
        return new ErrorGroupServiceApi(settings);
    }

    protected ErrorGroupServiceApi(ErrorGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.getGroupCallable = ApiCallable.create(settings.getGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateGroupCallable = ApiCallable.create(settings.updateGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorGroupServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorGroupServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final ErrorGroup getGroup(String groupName) {
        GROUP_PATH_TEMPLATE.validate(groupName, "getGroup");
        GetGroupRequest request = GetGroupRequest.newBuilder().setGroupName(groupName).build();
        return this.getGroup(request);
    }

    private final ErrorGroup getGroup(GetGroupRequest request) {
        return (ErrorGroup)this.getGroupCallable().call((Object)request);
    }

    public final ApiCallable<GetGroupRequest, ErrorGroup> getGroupCallable() {
        return this.getGroupCallable;
    }

    public final ErrorGroup updateGroup(ErrorGroup group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    private final ErrorGroup updateGroup(UpdateGroupRequest request) {
        return (ErrorGroup)this.updateGroupCallable().call((Object)request);
    }

    public final ApiCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

