/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.clouderrorreporting.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroup;
import com.google.devtools.clouderrorreporting.v1beta1.GetGroupRequest;
import com.google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest;
import com.google.devtools.clouderrorreporting.v1beta1.stub.ErrorGroupServiceStub;
import com.google.devtools.clouderrorreporting.v1beta1.stub.ErrorGroupServiceStubSettings;
import com.google.devtools.clouderrorreporting.v1beta1.stub.GrpcErrorGroupServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcErrorGroupServiceStub
extends ErrorGroupServiceStub {
    private static final MethodDescriptor<GetGroupRequest, ErrorGroup> getGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/GetGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ErrorGroup.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGroupRequest, ErrorGroup> updateGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/UpdateGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ErrorGroup.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable;
    private final UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcErrorGroupServiceStub create(ErrorGroupServiceStubSettings settings) throws IOException {
        return new GrpcErrorGroupServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcErrorGroupServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcErrorGroupServiceStub(ErrorGroupServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcErrorGroupServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcErrorGroupServiceStub(ErrorGroupServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcErrorGroupServiceStub(ErrorGroupServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcErrorGroupServiceCallableFactory());
    }

    protected GrpcErrorGroupServiceStub(ErrorGroupServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("group_name", String.valueOf(request.getGroupName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("group.name", String.valueOf(request.getGroup().getName()));
            return builder.build();
        }).build();
        this.getGroupCallable = callableFactory.createUnaryCallable(getGroupTransportSettings, settings.getGroupSettings(), clientContext);
        this.updateGroupCallable = callableFactory.createUnaryCallable(updateGroupTransportSettings, settings.updateGroupSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable() {
        return this.getGroupCallable;
    }

    @Override
    public UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

