/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.v1beta1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.errorreporting.v1beta1.ErrorStatsServiceSettings;
import com.google.cloud.errorreporting.v1beta1.PagedResponseWrappers;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ProjectName;
import com.google.devtools.clouderrorreporting.v1beta1.QueryTimeRange;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ErrorStatsServiceClient
implements AutoCloseable {
    private final ErrorStatsServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable;
    private final UnaryCallable<ListGroupStatsRequest, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsPagedCallable;
    private final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final UnaryCallable<ListEventsRequest, PagedResponseWrappers.ListEventsPagedResponse> listEventsPagedCallable;
    private final UnaryCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable;

    public static final ErrorStatsServiceClient create() throws IOException {
        return ErrorStatsServiceClient.create(ErrorStatsServiceSettings.defaultBuilder().build());
    }

    public static final ErrorStatsServiceClient create(ErrorStatsServiceSettings settings) throws IOException {
        return new ErrorStatsServiceClient(settings);
    }

    protected ErrorStatsServiceClient(ErrorStatsServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.listGroupStatsCallable = UnaryCallable.create(settings.listGroupStatsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listGroupStatsPagedCallable = UnaryCallable.createPagedVariant(settings.listGroupStatsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listEventsCallable = UnaryCallable.create(settings.listEventsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listEventsPagedCallable = UnaryCallable.createPagedVariant(settings.listEventsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteEventsCallable = UnaryCallable.create(settings.deleteEventsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorStatsServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorStatsServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final ErrorStatsServiceSettings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListGroupStatsPagedResponse listGroupStats(ProjectName projectName, QueryTimeRange timeRange) {
        ListGroupStatsRequest request = ListGroupStatsRequest.newBuilder().setProjectNameWithProjectName(projectName).setTimeRange(timeRange).build();
        return this.listGroupStats(request);
    }

    public final PagedResponseWrappers.ListGroupStatsPagedResponse listGroupStats(ListGroupStatsRequest request) {
        return (PagedResponseWrappers.ListGroupStatsPagedResponse)((Object)this.listGroupStatsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupStatsRequest, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsPagedCallable() {
        return this.listGroupStatsPagedCallable;
    }

    public final UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable() {
        return this.listGroupStatsCallable;
    }

    public final PagedResponseWrappers.ListEventsPagedResponse listEvents(ProjectName projectName, String groupId) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setProjectNameWithProjectName(projectName).setGroupId(groupId).build();
        return this.listEvents(request);
    }

    public final PagedResponseWrappers.ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (PagedResponseWrappers.ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, PagedResponseWrappers.ListEventsPagedResponse> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    public final DeleteEventsResponse deleteEvents(ProjectName projectName) {
        DeleteEventsRequest request = DeleteEventsRequest.newBuilder().setProjectNameWithProjectName(projectName).build();
        return this.deleteEvents(request);
    }

    private final DeleteEventsResponse deleteEvents(DeleteEventsRequest request) {
        return (DeleteEventsResponse)this.deleteEventsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable() {
        return this.deleteEventsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

