/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.clouderrorreporting.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorEvent;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorStatsServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ProjectName;
import com.google.devtools.clouderrorreporting.v1beta1.QueryTimeRange;
import com.google.devtools.clouderrorreporting.v1beta1.stub.ErrorStatsServiceStub;
import com.google.devtools.clouderrorreporting.v1beta1.stub.ErrorStatsServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ErrorStatsServiceClient
implements BackgroundResource {
    private final ErrorStatsServiceSettings settings;
    private final ErrorStatsServiceStub stub;

    public static final ErrorStatsServiceClient create() throws IOException {
        return ErrorStatsServiceClient.create(ErrorStatsServiceSettings.newBuilder().build());
    }

    public static final ErrorStatsServiceClient create(ErrorStatsServiceSettings settings) throws IOException {
        return new ErrorStatsServiceClient(settings);
    }

    public static final ErrorStatsServiceClient create(ErrorStatsServiceStub stub) {
        return new ErrorStatsServiceClient(stub);
    }

    protected ErrorStatsServiceClient(ErrorStatsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ErrorStatsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ErrorStatsServiceClient(ErrorStatsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ErrorStatsServiceSettings getSettings() {
        return this.settings;
    }

    public ErrorStatsServiceStub getStub() {
        return this.stub;
    }

    public final ListGroupStatsPagedResponse listGroupStats(ProjectName projectName, QueryTimeRange timeRange) {
        ListGroupStatsRequest request = ListGroupStatsRequest.newBuilder().setProjectName(projectName == null ? null : projectName.toString()).setTimeRange(timeRange).build();
        return this.listGroupStats(request);
    }

    public final ListGroupStatsPagedResponse listGroupStats(String projectName, QueryTimeRange timeRange) {
        ListGroupStatsRequest request = ListGroupStatsRequest.newBuilder().setProjectName(projectName).setTimeRange(timeRange).build();
        return this.listGroupStats(request);
    }

    public final ListGroupStatsPagedResponse listGroupStats(ListGroupStatsRequest request) {
        return (ListGroupStatsPagedResponse)((Object)this.listGroupStatsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupStatsRequest, ListGroupStatsPagedResponse> listGroupStatsPagedCallable() {
        return this.stub.listGroupStatsPagedCallable();
    }

    public final UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> listGroupStatsCallable() {
        return this.stub.listGroupStatsCallable();
    }

    public final ListEventsPagedResponse listEvents(ProjectName projectName, String groupId) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setProjectName(projectName == null ? null : projectName.toString()).setGroupId(groupId).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(String projectName, String groupId) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setProjectName(projectName).setGroupId(groupId).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, ListEventsPagedResponse> listEventsPagedCallable() {
        return this.stub.listEventsPagedCallable();
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.stub.listEventsCallable();
    }

    public final DeleteEventsResponse deleteEvents(ProjectName projectName) {
        DeleteEventsRequest request = DeleteEventsRequest.newBuilder().setProjectName(projectName == null ? null : projectName.toString()).build();
        return this.deleteEvents(request);
    }

    public final DeleteEventsResponse deleteEvents(String projectName) {
        DeleteEventsRequest request = DeleteEventsRequest.newBuilder().setProjectName(projectName).build();
        return this.deleteEvents(request);
    }

    public final DeleteEventsResponse deleteEvents(DeleteEventsRequest request) {
        return (DeleteEventsResponse)this.deleteEventsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEventsRequest, DeleteEventsResponse> deleteEventsCallable() {
        return this.stub.deleteEventsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEventsRequest, ListEventsResponse, ErrorEvent, ListEventsPage, ListEventsFixedSizeCollection> {
        private ListEventsFixedSizeCollection(List<ListEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEventsFixedSizeCollection createEmptyCollection() {
            return new ListEventsFixedSizeCollection(null, 0);
        }

        protected ListEventsFixedSizeCollection createCollection(List<ListEventsPage> pages, int collectionSize) {
            return new ListEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEventsPage
    extends AbstractPage<ListEventsRequest, ListEventsResponse, ErrorEvent, ListEventsPage> {
        private ListEventsPage(PageContext<ListEventsRequest, ListEventsResponse, ErrorEvent> context, ListEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListEventsPage createEmptyPage() {
            return new ListEventsPage(null, null);
        }

        protected ListEventsPage createPage(PageContext<ListEventsRequest, ListEventsResponse, ErrorEvent> context, ListEventsResponse response) {
            return new ListEventsPage(context, response);
        }

        public ApiFuture<ListEventsPage> createPageAsync(PageContext<ListEventsRequest, ListEventsResponse, ErrorEvent> context, ApiFuture<ListEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEventsPagedResponse
    extends AbstractPagedListResponse<ListEventsRequest, ListEventsResponse, ErrorEvent, ListEventsPage, ListEventsFixedSizeCollection> {
        public static ApiFuture<ListEventsPagedResponse> createAsync(PageContext<ListEventsRequest, ListEventsResponse, ErrorEvent> context, ApiFuture<ListEventsResponse> futureResponse) {
            ApiFuture<ListEventsPage> futurePage = ListEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEventsPagedResponse((ListEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEventsPagedResponse(ListEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGroupStatsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats, ListGroupStatsPage, ListGroupStatsFixedSizeCollection> {
        private ListGroupStatsFixedSizeCollection(List<ListGroupStatsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGroupStatsFixedSizeCollection createEmptyCollection() {
            return new ListGroupStatsFixedSizeCollection(null, 0);
        }

        protected ListGroupStatsFixedSizeCollection createCollection(List<ListGroupStatsPage> pages, int collectionSize) {
            return new ListGroupStatsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGroupStatsPage
    extends AbstractPage<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats, ListGroupStatsPage> {
        private ListGroupStatsPage(PageContext<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> context, ListGroupStatsResponse response) {
            super(context, (Object)response);
        }

        private static ListGroupStatsPage createEmptyPage() {
            return new ListGroupStatsPage(null, null);
        }

        protected ListGroupStatsPage createPage(PageContext<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> context, ListGroupStatsResponse response) {
            return new ListGroupStatsPage(context, response);
        }

        public ApiFuture<ListGroupStatsPage> createPageAsync(PageContext<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> context, ApiFuture<ListGroupStatsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGroupStatsPagedResponse
    extends AbstractPagedListResponse<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats, ListGroupStatsPage, ListGroupStatsFixedSizeCollection> {
        public static ApiFuture<ListGroupStatsPagedResponse> createAsync(PageContext<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> context, ApiFuture<ListGroupStatsResponse> futureResponse) {
            ApiFuture<ListGroupStatsPage> futurePage = ListGroupStatsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGroupStatsPagedResponse((ListGroupStatsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGroupStatsPagedResponse(ListGroupStatsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGroupStatsFixedSizeCollection.createEmptyCollection());
        }
    }
}

