/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorEventRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorEventResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorsServiceGrpc;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class ReportErrorsServiceSettings
extends ClientSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "clouderrorreporting.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private final SimpleCallSettings<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventSettings;

    public SimpleCallSettings<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventSettings() {
        return this.reportErrorEventSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setServiceAddress(DEFAULT_SERVICE_ADDRESS).setPort(443).setGeneratorHeader(DEFAULT_GAPIC_NAME, ReportErrorsServiceSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)ReportErrorsServiceSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        String packageVersion = ReportErrorsServiceSettings.class.getPackage().getImplementationVersion();
        return packageVersion != null ? packageVersion : DEFAULT_GAPIC_VERSION;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ReportErrorsServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.reportErrorEventSettings = settingsBuilder.reportErrorEventSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(ReportErrorsServiceSettings.defaultChannelProviderBuilder().build());
            this.reportErrorEventSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ReportErrorsServiceGrpc.METHOD_REPORT_ERROR_EVENT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.reportErrorEventSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.reportErrorEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(ReportErrorsServiceSettings settings) {
            super((ClientSettings)settings);
            this.reportErrorEventSettings = settings.reportErrorEventSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.reportErrorEventSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventSettings() {
            return this.reportErrorEventSettings;
        }

        public ReportErrorsServiceSettings build() throws IOException {
            return new ReportErrorsServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)20000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

