/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.domains.v1beta1.AuthorizationCode;
import com.google.cloud.domains.v1beta1.ConfigureContactSettingsRequest;
import com.google.cloud.domains.v1beta1.ConfigureDnsSettingsRequest;
import com.google.cloud.domains.v1beta1.ConfigureManagementSettingsRequest;
import com.google.cloud.domains.v1beta1.DeleteRegistrationRequest;
import com.google.cloud.domains.v1beta1.DomainsClient;
import com.google.cloud.domains.v1beta1.ExportRegistrationRequest;
import com.google.cloud.domains.v1beta1.GetRegistrationRequest;
import com.google.cloud.domains.v1beta1.ListRegistrationsRequest;
import com.google.cloud.domains.v1beta1.ListRegistrationsResponse;
import com.google.cloud.domains.v1beta1.OperationMetadata;
import com.google.cloud.domains.v1beta1.RegisterDomainRequest;
import com.google.cloud.domains.v1beta1.Registration;
import com.google.cloud.domains.v1beta1.ResetAuthorizationCodeRequest;
import com.google.cloud.domains.v1beta1.RetrieveAuthorizationCodeRequest;
import com.google.cloud.domains.v1beta1.RetrieveRegisterParametersRequest;
import com.google.cloud.domains.v1beta1.RetrieveRegisterParametersResponse;
import com.google.cloud.domains.v1beta1.RetrieveTransferParametersRequest;
import com.google.cloud.domains.v1beta1.RetrieveTransferParametersResponse;
import com.google.cloud.domains.v1beta1.SearchDomainsRequest;
import com.google.cloud.domains.v1beta1.SearchDomainsResponse;
import com.google.cloud.domains.v1beta1.TransferDomainRequest;
import com.google.cloud.domains.v1beta1.UpdateRegistrationRequest;
import com.google.cloud.domains.v1beta1.stub.DomainsStub;
import com.google.cloud.domains.v1beta1.stub.GrpcDomainsStub;
import com.google.cloud.domains.v1beta1.stub.HttpJsonDomainsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DomainsStubSettings
extends StubSettings<DomainsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<SearchDomainsRequest, SearchDomainsResponse> searchDomainsSettings;
    private final UnaryCallSettings<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersSettings;
    private final UnaryCallSettings<RegisterDomainRequest, Operation> registerDomainSettings;
    private final OperationCallSettings<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationSettings;
    private final UnaryCallSettings<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersSettings;
    private final UnaryCallSettings<TransferDomainRequest, Operation> transferDomainSettings;
    private final OperationCallSettings<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationSettings;
    private final PagedCallSettings<ListRegistrationsRequest, ListRegistrationsResponse, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsSettings;
    private final UnaryCallSettings<GetRegistrationRequest, Registration> getRegistrationSettings;
    private final UnaryCallSettings<UpdateRegistrationRequest, Operation> updateRegistrationSettings;
    private final OperationCallSettings<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationSettings;
    private final UnaryCallSettings<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsSettings;
    private final OperationCallSettings<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationSettings;
    private final UnaryCallSettings<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsSettings;
    private final OperationCallSettings<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationSettings;
    private final UnaryCallSettings<ConfigureContactSettingsRequest, Operation> configureContactSettingsSettings;
    private final OperationCallSettings<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationSettings;
    private final UnaryCallSettings<ExportRegistrationRequest, Operation> exportRegistrationSettings;
    private final OperationCallSettings<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationSettings;
    private final UnaryCallSettings<DeleteRegistrationRequest, Operation> deleteRegistrationSettings;
    private final OperationCallSettings<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationSettings;
    private final UnaryCallSettings<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeSettings;
    private final UnaryCallSettings<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeSettings;
    private static final PagedListDescriptor<ListRegistrationsRequest, ListRegistrationsResponse, Registration> LIST_REGISTRATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRegistrationsRequest, ListRegistrationsResponse, Registration>(){

        public String emptyToken() {
            return "";
        }

        public ListRegistrationsRequest injectToken(ListRegistrationsRequest payload, String token) {
            return ListRegistrationsRequest.newBuilder((ListRegistrationsRequest)payload).setPageToken(token).build();
        }

        public ListRegistrationsRequest injectPageSize(ListRegistrationsRequest payload, int pageSize) {
            return ListRegistrationsRequest.newBuilder((ListRegistrationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRegistrationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRegistrationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Registration> extractResources(ListRegistrationsResponse payload) {
            return payload.getRegistrationsList() == null ? ImmutableList.of() : payload.getRegistrationsList();
        }
    };
    private static final PagedListResponseFactory<ListRegistrationsRequest, ListRegistrationsResponse, DomainsClient.ListRegistrationsPagedResponse> LIST_REGISTRATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegistrationsRequest, ListRegistrationsResponse, DomainsClient.ListRegistrationsPagedResponse>(){

        public ApiFuture<DomainsClient.ListRegistrationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegistrationsRequest, ListRegistrationsResponse> callable, ListRegistrationsRequest request, ApiCallContext context, ApiFuture<ListRegistrationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGISTRATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DomainsClient.ListRegistrationsPagedResponse.createAsync((PageContext<ListRegistrationsRequest, ListRegistrationsResponse, Registration>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<SearchDomainsRequest, SearchDomainsResponse> searchDomainsSettings() {
        return this.searchDomainsSettings;
    }

    public UnaryCallSettings<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersSettings() {
        return this.retrieveRegisterParametersSettings;
    }

    public UnaryCallSettings<RegisterDomainRequest, Operation> registerDomainSettings() {
        return this.registerDomainSettings;
    }

    public OperationCallSettings<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationSettings() {
        return this.registerDomainOperationSettings;
    }

    public UnaryCallSettings<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersSettings() {
        return this.retrieveTransferParametersSettings;
    }

    public UnaryCallSettings<TransferDomainRequest, Operation> transferDomainSettings() {
        return this.transferDomainSettings;
    }

    public OperationCallSettings<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationSettings() {
        return this.transferDomainOperationSettings;
    }

    public PagedCallSettings<ListRegistrationsRequest, ListRegistrationsResponse, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsSettings() {
        return this.listRegistrationsSettings;
    }

    public UnaryCallSettings<GetRegistrationRequest, Registration> getRegistrationSettings() {
        return this.getRegistrationSettings;
    }

    public UnaryCallSettings<UpdateRegistrationRequest, Operation> updateRegistrationSettings() {
        return this.updateRegistrationSettings;
    }

    public OperationCallSettings<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationSettings() {
        return this.updateRegistrationOperationSettings;
    }

    public UnaryCallSettings<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsSettings() {
        return this.configureManagementSettingsSettings;
    }

    public OperationCallSettings<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationSettings() {
        return this.configureManagementSettingsOperationSettings;
    }

    public UnaryCallSettings<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsSettings() {
        return this.configureDnsSettingsSettings;
    }

    public OperationCallSettings<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationSettings() {
        return this.configureDnsSettingsOperationSettings;
    }

    public UnaryCallSettings<ConfigureContactSettingsRequest, Operation> configureContactSettingsSettings() {
        return this.configureContactSettingsSettings;
    }

    public OperationCallSettings<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationSettings() {
        return this.configureContactSettingsOperationSettings;
    }

    public UnaryCallSettings<ExportRegistrationRequest, Operation> exportRegistrationSettings() {
        return this.exportRegistrationSettings;
    }

    public OperationCallSettings<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationSettings() {
        return this.exportRegistrationOperationSettings;
    }

    public UnaryCallSettings<DeleteRegistrationRequest, Operation> deleteRegistrationSettings() {
        return this.deleteRegistrationSettings;
    }

    public OperationCallSettings<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationSettings() {
        return this.deleteRegistrationOperationSettings;
    }

    public UnaryCallSettings<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeSettings() {
        return this.retrieveAuthorizationCodeSettings;
    }

    public UnaryCallSettings<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeSettings() {
        return this.resetAuthorizationCodeSettings;
    }

    public DomainsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDomainsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDomainsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "domains";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "domains.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "domains.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DomainsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DomainsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DomainsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DomainsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DomainsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchDomainsSettings = settingsBuilder.searchDomainsSettings().build();
        this.retrieveRegisterParametersSettings = settingsBuilder.retrieveRegisterParametersSettings().build();
        this.registerDomainSettings = settingsBuilder.registerDomainSettings().build();
        this.registerDomainOperationSettings = settingsBuilder.registerDomainOperationSettings().build();
        this.retrieveTransferParametersSettings = settingsBuilder.retrieveTransferParametersSettings().build();
        this.transferDomainSettings = settingsBuilder.transferDomainSettings().build();
        this.transferDomainOperationSettings = settingsBuilder.transferDomainOperationSettings().build();
        this.listRegistrationsSettings = settingsBuilder.listRegistrationsSettings().build();
        this.getRegistrationSettings = settingsBuilder.getRegistrationSettings().build();
        this.updateRegistrationSettings = settingsBuilder.updateRegistrationSettings().build();
        this.updateRegistrationOperationSettings = settingsBuilder.updateRegistrationOperationSettings().build();
        this.configureManagementSettingsSettings = settingsBuilder.configureManagementSettingsSettings().build();
        this.configureManagementSettingsOperationSettings = settingsBuilder.configureManagementSettingsOperationSettings().build();
        this.configureDnsSettingsSettings = settingsBuilder.configureDnsSettingsSettings().build();
        this.configureDnsSettingsOperationSettings = settingsBuilder.configureDnsSettingsOperationSettings().build();
        this.configureContactSettingsSettings = settingsBuilder.configureContactSettingsSettings().build();
        this.configureContactSettingsOperationSettings = settingsBuilder.configureContactSettingsOperationSettings().build();
        this.exportRegistrationSettings = settingsBuilder.exportRegistrationSettings().build();
        this.exportRegistrationOperationSettings = settingsBuilder.exportRegistrationOperationSettings().build();
        this.deleteRegistrationSettings = settingsBuilder.deleteRegistrationSettings().build();
        this.deleteRegistrationOperationSettings = settingsBuilder.deleteRegistrationOperationSettings().build();
        this.retrieveAuthorizationCodeSettings = settingsBuilder.retrieveAuthorizationCodeSettings().build();
        this.resetAuthorizationCodeSettings = settingsBuilder.resetAuthorizationCodeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DomainsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<SearchDomainsRequest, SearchDomainsResponse> searchDomainsSettings;
        private final UnaryCallSettings.Builder<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersSettings;
        private final UnaryCallSettings.Builder<RegisterDomainRequest, Operation> registerDomainSettings;
        private final OperationCallSettings.Builder<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationSettings;
        private final UnaryCallSettings.Builder<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersSettings;
        private final UnaryCallSettings.Builder<TransferDomainRequest, Operation> transferDomainSettings;
        private final OperationCallSettings.Builder<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationSettings;
        private final PagedCallSettings.Builder<ListRegistrationsRequest, ListRegistrationsResponse, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsSettings;
        private final UnaryCallSettings.Builder<GetRegistrationRequest, Registration> getRegistrationSettings;
        private final UnaryCallSettings.Builder<UpdateRegistrationRequest, Operation> updateRegistrationSettings;
        private final OperationCallSettings.Builder<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationSettings;
        private final UnaryCallSettings.Builder<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsSettings;
        private final OperationCallSettings.Builder<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationSettings;
        private final UnaryCallSettings.Builder<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsSettings;
        private final OperationCallSettings.Builder<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationSettings;
        private final UnaryCallSettings.Builder<ConfigureContactSettingsRequest, Operation> configureContactSettingsSettings;
        private final OperationCallSettings.Builder<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationSettings;
        private final UnaryCallSettings.Builder<ExportRegistrationRequest, Operation> exportRegistrationSettings;
        private final OperationCallSettings.Builder<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRegistrationRequest, Operation> deleteRegistrationSettings;
        private final OperationCallSettings.Builder<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationSettings;
        private final UnaryCallSettings.Builder<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeSettings;
        private final UnaryCallSettings.Builder<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchDomainsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.retrieveRegisterParametersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.registerDomainSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.registerDomainOperationSettings = OperationCallSettings.newBuilder();
            this.retrieveTransferParametersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.transferDomainSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.transferDomainOperationSettings = OperationCallSettings.newBuilder();
            this.listRegistrationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGISTRATIONS_PAGE_STR_FACT);
            this.getRegistrationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRegistrationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRegistrationOperationSettings = OperationCallSettings.newBuilder();
            this.configureManagementSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.configureManagementSettingsOperationSettings = OperationCallSettings.newBuilder();
            this.configureDnsSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.configureDnsSettingsOperationSettings = OperationCallSettings.newBuilder();
            this.configureContactSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.configureContactSettingsOperationSettings = OperationCallSettings.newBuilder();
            this.exportRegistrationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportRegistrationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRegistrationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRegistrationOperationSettings = OperationCallSettings.newBuilder();
            this.retrieveAuthorizationCodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetAuthorizationCodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchDomainsSettings, this.retrieveRegisterParametersSettings, this.registerDomainSettings, this.retrieveTransferParametersSettings, this.transferDomainSettings, this.listRegistrationsSettings, this.getRegistrationSettings, this.updateRegistrationSettings, this.configureManagementSettingsSettings, this.configureDnsSettingsSettings, this.configureContactSettingsSettings, this.exportRegistrationSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteRegistrationSettings, this.retrieveAuthorizationCodeSettings, this.resetAuthorizationCodeSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DomainsStubSettings settings) {
            super((StubSettings)settings);
            this.searchDomainsSettings = settings.searchDomainsSettings.toBuilder();
            this.retrieveRegisterParametersSettings = settings.retrieveRegisterParametersSettings.toBuilder();
            this.registerDomainSettings = settings.registerDomainSettings.toBuilder();
            this.registerDomainOperationSettings = settings.registerDomainOperationSettings.toBuilder();
            this.retrieveTransferParametersSettings = settings.retrieveTransferParametersSettings.toBuilder();
            this.transferDomainSettings = settings.transferDomainSettings.toBuilder();
            this.transferDomainOperationSettings = settings.transferDomainOperationSettings.toBuilder();
            this.listRegistrationsSettings = settings.listRegistrationsSettings.toBuilder();
            this.getRegistrationSettings = settings.getRegistrationSettings.toBuilder();
            this.updateRegistrationSettings = settings.updateRegistrationSettings.toBuilder();
            this.updateRegistrationOperationSettings = settings.updateRegistrationOperationSettings.toBuilder();
            this.configureManagementSettingsSettings = settings.configureManagementSettingsSettings.toBuilder();
            this.configureManagementSettingsOperationSettings = settings.configureManagementSettingsOperationSettings.toBuilder();
            this.configureDnsSettingsSettings = settings.configureDnsSettingsSettings.toBuilder();
            this.configureDnsSettingsOperationSettings = settings.configureDnsSettingsOperationSettings.toBuilder();
            this.configureContactSettingsSettings = settings.configureContactSettingsSettings.toBuilder();
            this.configureContactSettingsOperationSettings = settings.configureContactSettingsOperationSettings.toBuilder();
            this.exportRegistrationSettings = settings.exportRegistrationSettings.toBuilder();
            this.exportRegistrationOperationSettings = settings.exportRegistrationOperationSettings.toBuilder();
            this.deleteRegistrationSettings = settings.deleteRegistrationSettings.toBuilder();
            this.deleteRegistrationOperationSettings = settings.deleteRegistrationOperationSettings.toBuilder();
            this.retrieveAuthorizationCodeSettings = settings.retrieveAuthorizationCodeSettings.toBuilder();
            this.resetAuthorizationCodeSettings = settings.resetAuthorizationCodeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchDomainsSettings, this.retrieveRegisterParametersSettings, this.registerDomainSettings, this.retrieveTransferParametersSettings, this.transferDomainSettings, this.listRegistrationsSettings, this.getRegistrationSettings, this.updateRegistrationSettings, this.configureManagementSettingsSettings, this.configureDnsSettingsSettings, this.configureContactSettingsSettings, this.exportRegistrationSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteRegistrationSettings, this.retrieveAuthorizationCodeSettings, this.resetAuthorizationCodeSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DomainsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DomainsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DomainsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DomainsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DomainsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DomainsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DomainsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DomainsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchDomainsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.retrieveRegisterParametersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.registerDomainSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.retrieveTransferParametersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.transferDomainSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRegistrationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getRegistrationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateRegistrationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.configureManagementSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.configureDnsSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.configureContactSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportRegistrationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteRegistrationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.retrieveAuthorizationCodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.resetAuthorizationCodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.registerDomainOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.transferDomainOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateRegistrationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.configureManagementSettingsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.configureDnsSettingsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.configureContactSettingsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportRegistrationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Registration.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRegistrationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<SearchDomainsRequest, SearchDomainsResponse> searchDomainsSettings() {
            return this.searchDomainsSettings;
        }

        public UnaryCallSettings.Builder<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersSettings() {
            return this.retrieveRegisterParametersSettings;
        }

        public UnaryCallSettings.Builder<RegisterDomainRequest, Operation> registerDomainSettings() {
            return this.registerDomainSettings;
        }

        public OperationCallSettings.Builder<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationSettings() {
            return this.registerDomainOperationSettings;
        }

        public UnaryCallSettings.Builder<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersSettings() {
            return this.retrieveTransferParametersSettings;
        }

        public UnaryCallSettings.Builder<TransferDomainRequest, Operation> transferDomainSettings() {
            return this.transferDomainSettings;
        }

        public OperationCallSettings.Builder<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationSettings() {
            return this.transferDomainOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegistrationsRequest, ListRegistrationsResponse, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsSettings() {
            return this.listRegistrationsSettings;
        }

        public UnaryCallSettings.Builder<GetRegistrationRequest, Registration> getRegistrationSettings() {
            return this.getRegistrationSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegistrationRequest, Operation> updateRegistrationSettings() {
            return this.updateRegistrationSettings;
        }

        public OperationCallSettings.Builder<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationSettings() {
            return this.updateRegistrationOperationSettings;
        }

        public UnaryCallSettings.Builder<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsSettings() {
            return this.configureManagementSettingsSettings;
        }

        public OperationCallSettings.Builder<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationSettings() {
            return this.configureManagementSettingsOperationSettings;
        }

        public UnaryCallSettings.Builder<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsSettings() {
            return this.configureDnsSettingsSettings;
        }

        public OperationCallSettings.Builder<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationSettings() {
            return this.configureDnsSettingsOperationSettings;
        }

        public UnaryCallSettings.Builder<ConfigureContactSettingsRequest, Operation> configureContactSettingsSettings() {
            return this.configureContactSettingsSettings;
        }

        public OperationCallSettings.Builder<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationSettings() {
            return this.configureContactSettingsOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportRegistrationRequest, Operation> exportRegistrationSettings() {
            return this.exportRegistrationSettings;
        }

        public OperationCallSettings.Builder<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationSettings() {
            return this.exportRegistrationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegistrationRequest, Operation> deleteRegistrationSettings() {
            return this.deleteRegistrationSettings;
        }

        public OperationCallSettings.Builder<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationSettings() {
            return this.deleteRegistrationOperationSettings;
        }

        public UnaryCallSettings.Builder<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeSettings() {
            return this.retrieveAuthorizationCodeSettings;
        }

        public UnaryCallSettings.Builder<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeSettings() {
            return this.resetAuthorizationCodeSettings;
        }

        public DomainsStubSettings build() throws IOException {
            return new DomainsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

