/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1alpha2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.domains.v1alpha2.AuthorizationCode;
import com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest;
import com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest;
import com.google.cloud.domains.v1alpha2.ConfigureManagementSettingsRequest;
import com.google.cloud.domains.v1alpha2.DeleteRegistrationRequest;
import com.google.cloud.domains.v1alpha2.DomainsClient;
import com.google.cloud.domains.v1alpha2.ExportRegistrationRequest;
import com.google.cloud.domains.v1alpha2.GetRegistrationRequest;
import com.google.cloud.domains.v1alpha2.ListRegistrationsRequest;
import com.google.cloud.domains.v1alpha2.ListRegistrationsResponse;
import com.google.cloud.domains.v1alpha2.OperationMetadata;
import com.google.cloud.domains.v1alpha2.RegisterDomainRequest;
import com.google.cloud.domains.v1alpha2.Registration;
import com.google.cloud.domains.v1alpha2.ResetAuthorizationCodeRequest;
import com.google.cloud.domains.v1alpha2.RetrieveAuthorizationCodeRequest;
import com.google.cloud.domains.v1alpha2.RetrieveRegisterParametersRequest;
import com.google.cloud.domains.v1alpha2.RetrieveRegisterParametersResponse;
import com.google.cloud.domains.v1alpha2.RetrieveTransferParametersRequest;
import com.google.cloud.domains.v1alpha2.RetrieveTransferParametersResponse;
import com.google.cloud.domains.v1alpha2.SearchDomainsRequest;
import com.google.cloud.domains.v1alpha2.SearchDomainsResponse;
import com.google.cloud.domains.v1alpha2.TransferDomainRequest;
import com.google.cloud.domains.v1alpha2.UpdateRegistrationRequest;
import com.google.cloud.domains.v1alpha2.stub.DomainsStub;
import com.google.cloud.domains.v1alpha2.stub.DomainsStubSettings;
import com.google.cloud.domains.v1alpha2.stub.GrpcDomainsCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDomainsStub
extends DomainsStub {
    private static final MethodDescriptor<SearchDomainsRequest, SearchDomainsResponse> searchDomainsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/SearchDomains").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchDomainsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchDomainsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/RetrieveRegisterParameters").setRequestMarshaller(ProtoUtils.marshaller((Message)RetrieveRegisterParametersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RetrieveRegisterParametersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RegisterDomainRequest, Operation> registerDomainMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/RegisterDomain").setRequestMarshaller(ProtoUtils.marshaller((Message)RegisterDomainRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/RetrieveTransferParameters").setRequestMarshaller(ProtoUtils.marshaller((Message)RetrieveTransferParametersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RetrieveTransferParametersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<TransferDomainRequest, Operation> transferDomainMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/TransferDomain").setRequestMarshaller(ProtoUtils.marshaller((Message)TransferDomainRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/ListRegistrations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRegistrationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRegistrationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRegistrationRequest, Registration> getRegistrationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/GetRegistration").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRegistrationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Registration.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateRegistrationRequest, Operation> updateRegistrationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/UpdateRegistration").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRegistrationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/ConfigureManagementSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)ConfigureManagementSettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/ConfigureDnsSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)ConfigureDnsSettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ConfigureContactSettingsRequest, Operation> configureContactSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/ConfigureContactSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)ConfigureContactSettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportRegistrationRequest, Operation> exportRegistrationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/ExportRegistration").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportRegistrationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRegistrationRequest, Operation> deleteRegistrationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/DeleteRegistration").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRegistrationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/RetrieveAuthorizationCode").setRequestMarshaller(ProtoUtils.marshaller((Message)RetrieveAuthorizationCodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AuthorizationCode.getDefaultInstance())).build();
    private static final MethodDescriptor<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.domains.v1alpha2.Domains/ResetAuthorizationCode").setRequestMarshaller(ProtoUtils.marshaller((Message)ResetAuthorizationCodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AuthorizationCode.getDefaultInstance())).build();
    private final UnaryCallable<SearchDomainsRequest, SearchDomainsResponse> searchDomainsCallable;
    private final UnaryCallable<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersCallable;
    private final UnaryCallable<RegisterDomainRequest, Operation> registerDomainCallable;
    private final OperationCallable<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationCallable;
    private final UnaryCallable<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersCallable;
    private final UnaryCallable<TransferDomainRequest, Operation> transferDomainCallable;
    private final OperationCallable<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationCallable;
    private final UnaryCallable<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsCallable;
    private final UnaryCallable<ListRegistrationsRequest, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsPagedCallable;
    private final UnaryCallable<GetRegistrationRequest, Registration> getRegistrationCallable;
    private final UnaryCallable<UpdateRegistrationRequest, Operation> updateRegistrationCallable;
    private final OperationCallable<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationCallable;
    private final UnaryCallable<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsCallable;
    private final OperationCallable<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationCallable;
    private final UnaryCallable<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsCallable;
    private final OperationCallable<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationCallable;
    private final UnaryCallable<ConfigureContactSettingsRequest, Operation> configureContactSettingsCallable;
    private final OperationCallable<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationCallable;
    private final UnaryCallable<ExportRegistrationRequest, Operation> exportRegistrationCallable;
    private final OperationCallable<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationCallable;
    private final UnaryCallable<DeleteRegistrationRequest, Operation> deleteRegistrationCallable;
    private final OperationCallable<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationCallable;
    private final UnaryCallable<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeCallable;
    private final UnaryCallable<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDomainsStub create(DomainsStubSettings settings) throws IOException {
        return new GrpcDomainsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDomainsStub create(ClientContext clientContext) throws IOException {
        return new GrpcDomainsStub(DomainsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDomainsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDomainsStub(DomainsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDomainsStub(DomainsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDomainsCallableFactory());
    }

    protected GrpcDomainsStub(DomainsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchDomainsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchDomainsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        GrpcCallSettings retrieveRegisterParametersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(retrieveRegisterParametersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        GrpcCallSettings registerDomainTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(registerDomainMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings retrieveTransferParametersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(retrieveTransferParametersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        GrpcCallSettings transferDomainTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(transferDomainMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listRegistrationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRegistrationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRegistrationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRegistrationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateRegistrationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRegistrationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration.name", String.valueOf(request.getRegistration().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings configureManagementSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(configureManagementSettingsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        GrpcCallSettings configureDnsSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(configureDnsSettingsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        GrpcCallSettings configureContactSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(configureContactSettingsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        GrpcCallSettings exportRegistrationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportRegistrationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteRegistrationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRegistrationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings retrieveAuthorizationCodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(retrieveAuthorizationCodeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        GrpcCallSettings resetAuthorizationCodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resetAuthorizationCodeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        this.searchDomainsCallable = callableFactory.createUnaryCallable(searchDomainsTransportSettings, settings.searchDomainsSettings(), clientContext);
        this.retrieveRegisterParametersCallable = callableFactory.createUnaryCallable(retrieveRegisterParametersTransportSettings, settings.retrieveRegisterParametersSettings(), clientContext);
        this.registerDomainCallable = callableFactory.createUnaryCallable(registerDomainTransportSettings, settings.registerDomainSettings(), clientContext);
        this.registerDomainOperationCallable = callableFactory.createOperationCallable(registerDomainTransportSettings, settings.registerDomainOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.retrieveTransferParametersCallable = callableFactory.createUnaryCallable(retrieveTransferParametersTransportSettings, settings.retrieveTransferParametersSettings(), clientContext);
        this.transferDomainCallable = callableFactory.createUnaryCallable(transferDomainTransportSettings, settings.transferDomainSettings(), clientContext);
        this.transferDomainOperationCallable = callableFactory.createOperationCallable(transferDomainTransportSettings, settings.transferDomainOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listRegistrationsCallable = callableFactory.createUnaryCallable(listRegistrationsTransportSettings, settings.listRegistrationsSettings(), clientContext);
        this.listRegistrationsPagedCallable = callableFactory.createPagedCallable(listRegistrationsTransportSettings, settings.listRegistrationsSettings(), clientContext);
        this.getRegistrationCallable = callableFactory.createUnaryCallable(getRegistrationTransportSettings, settings.getRegistrationSettings(), clientContext);
        this.updateRegistrationCallable = callableFactory.createUnaryCallable(updateRegistrationTransportSettings, settings.updateRegistrationSettings(), clientContext);
        this.updateRegistrationOperationCallable = callableFactory.createOperationCallable(updateRegistrationTransportSettings, settings.updateRegistrationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.configureManagementSettingsCallable = callableFactory.createUnaryCallable(configureManagementSettingsTransportSettings, settings.configureManagementSettingsSettings(), clientContext);
        this.configureManagementSettingsOperationCallable = callableFactory.createOperationCallable(configureManagementSettingsTransportSettings, settings.configureManagementSettingsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.configureDnsSettingsCallable = callableFactory.createUnaryCallable(configureDnsSettingsTransportSettings, settings.configureDnsSettingsSettings(), clientContext);
        this.configureDnsSettingsOperationCallable = callableFactory.createOperationCallable(configureDnsSettingsTransportSettings, settings.configureDnsSettingsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.configureContactSettingsCallable = callableFactory.createUnaryCallable(configureContactSettingsTransportSettings, settings.configureContactSettingsSettings(), clientContext);
        this.configureContactSettingsOperationCallable = callableFactory.createOperationCallable(configureContactSettingsTransportSettings, settings.configureContactSettingsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportRegistrationCallable = callableFactory.createUnaryCallable(exportRegistrationTransportSettings, settings.exportRegistrationSettings(), clientContext);
        this.exportRegistrationOperationCallable = callableFactory.createOperationCallable(exportRegistrationTransportSettings, settings.exportRegistrationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteRegistrationCallable = callableFactory.createUnaryCallable(deleteRegistrationTransportSettings, settings.deleteRegistrationSettings(), clientContext);
        this.deleteRegistrationOperationCallable = callableFactory.createOperationCallable(deleteRegistrationTransportSettings, settings.deleteRegistrationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.retrieveAuthorizationCodeCallable = callableFactory.createUnaryCallable(retrieveAuthorizationCodeTransportSettings, settings.retrieveAuthorizationCodeSettings(), clientContext);
        this.resetAuthorizationCodeCallable = callableFactory.createUnaryCallable(resetAuthorizationCodeTransportSettings, settings.resetAuthorizationCodeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchDomainsRequest, SearchDomainsResponse> searchDomainsCallable() {
        return this.searchDomainsCallable;
    }

    @Override
    public UnaryCallable<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersCallable() {
        return this.retrieveRegisterParametersCallable;
    }

    @Override
    public UnaryCallable<RegisterDomainRequest, Operation> registerDomainCallable() {
        return this.registerDomainCallable;
    }

    @Override
    public OperationCallable<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationCallable() {
        return this.registerDomainOperationCallable;
    }

    @Override
    public UnaryCallable<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersCallable() {
        return this.retrieveTransferParametersCallable;
    }

    @Override
    public UnaryCallable<TransferDomainRequest, Operation> transferDomainCallable() {
        return this.transferDomainCallable;
    }

    @Override
    public OperationCallable<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationCallable() {
        return this.transferDomainOperationCallable;
    }

    @Override
    public UnaryCallable<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsCallable() {
        return this.listRegistrationsCallable;
    }

    @Override
    public UnaryCallable<ListRegistrationsRequest, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsPagedCallable() {
        return this.listRegistrationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRegistrationRequest, Registration> getRegistrationCallable() {
        return this.getRegistrationCallable;
    }

    @Override
    public UnaryCallable<UpdateRegistrationRequest, Operation> updateRegistrationCallable() {
        return this.updateRegistrationCallable;
    }

    @Override
    public OperationCallable<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationCallable() {
        return this.updateRegistrationOperationCallable;
    }

    @Override
    public UnaryCallable<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsCallable() {
        return this.configureManagementSettingsCallable;
    }

    @Override
    public OperationCallable<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationCallable() {
        return this.configureManagementSettingsOperationCallable;
    }

    @Override
    public UnaryCallable<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsCallable() {
        return this.configureDnsSettingsCallable;
    }

    @Override
    public OperationCallable<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationCallable() {
        return this.configureDnsSettingsOperationCallable;
    }

    @Override
    public UnaryCallable<ConfigureContactSettingsRequest, Operation> configureContactSettingsCallable() {
        return this.configureContactSettingsCallable;
    }

    @Override
    public OperationCallable<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationCallable() {
        return this.configureContactSettingsOperationCallable;
    }

    @Override
    public UnaryCallable<ExportRegistrationRequest, Operation> exportRegistrationCallable() {
        return this.exportRegistrationCallable;
    }

    @Override
    public OperationCallable<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationCallable() {
        return this.exportRegistrationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRegistrationRequest, Operation> deleteRegistrationCallable() {
        return this.deleteRegistrationCallable;
    }

    @Override
    public OperationCallable<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationCallable() {
        return this.deleteRegistrationOperationCallable;
    }

    @Override
    public UnaryCallable<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeCallable() {
        return this.retrieveAuthorizationCodeCallable;
    }

    @Override
    public UnaryCallable<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeCallable() {
        return this.resetAuthorizationCodeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

