/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.domains.v1beta1.AuthorizationCode;
import com.google.cloud.domains.v1beta1.ConfigureContactSettingsRequest;
import com.google.cloud.domains.v1beta1.ConfigureDnsSettingsRequest;
import com.google.cloud.domains.v1beta1.ConfigureManagementSettingsRequest;
import com.google.cloud.domains.v1beta1.ContactSettings;
import com.google.cloud.domains.v1beta1.DeleteRegistrationRequest;
import com.google.cloud.domains.v1beta1.DnsSettings;
import com.google.cloud.domains.v1beta1.DomainsSettings;
import com.google.cloud.domains.v1beta1.ExportRegistrationRequest;
import com.google.cloud.domains.v1beta1.GetRegistrationRequest;
import com.google.cloud.domains.v1beta1.ListRegistrationsRequest;
import com.google.cloud.domains.v1beta1.ListRegistrationsResponse;
import com.google.cloud.domains.v1beta1.LocationName;
import com.google.cloud.domains.v1beta1.ManagementSettings;
import com.google.cloud.domains.v1beta1.OperationMetadata;
import com.google.cloud.domains.v1beta1.RegisterDomainRequest;
import com.google.cloud.domains.v1beta1.Registration;
import com.google.cloud.domains.v1beta1.RegistrationName;
import com.google.cloud.domains.v1beta1.ResetAuthorizationCodeRequest;
import com.google.cloud.domains.v1beta1.RetrieveAuthorizationCodeRequest;
import com.google.cloud.domains.v1beta1.RetrieveRegisterParametersRequest;
import com.google.cloud.domains.v1beta1.RetrieveRegisterParametersResponse;
import com.google.cloud.domains.v1beta1.SearchDomainsRequest;
import com.google.cloud.domains.v1beta1.SearchDomainsResponse;
import com.google.cloud.domains.v1beta1.UpdateRegistrationRequest;
import com.google.cloud.domains.v1beta1.stub.DomainsStub;
import com.google.cloud.domains.v1beta1.stub.DomainsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.type.Money;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DomainsClient
implements BackgroundResource {
    private final DomainsSettings settings;
    private final DomainsStub stub;
    private final OperationsClient operationsClient;

    public static final DomainsClient create() throws IOException {
        return DomainsClient.create(DomainsSettings.newBuilder().build());
    }

    public static final DomainsClient create(DomainsSettings settings) throws IOException {
        return new DomainsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DomainsClient create(DomainsStub stub) {
        return new DomainsClient(stub);
    }

    protected DomainsClient(DomainsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DomainsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DomainsClient(DomainsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DomainsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DomainsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final SearchDomainsResponse searchDomains(LocationName location, String query) {
        SearchDomainsRequest request = SearchDomainsRequest.newBuilder().setLocation(location == null ? null : location.toString()).setQuery(query).build();
        return this.searchDomains(request);
    }

    public final SearchDomainsResponse searchDomains(String location, String query) {
        SearchDomainsRequest request = SearchDomainsRequest.newBuilder().setLocation(location).setQuery(query).build();
        return this.searchDomains(request);
    }

    public final SearchDomainsResponse searchDomains(SearchDomainsRequest request) {
        return (SearchDomainsResponse)this.searchDomainsCallable().call((Object)request);
    }

    public final UnaryCallable<SearchDomainsRequest, SearchDomainsResponse> searchDomainsCallable() {
        return this.stub.searchDomainsCallable();
    }

    public final RetrieveRegisterParametersResponse retrieveRegisterParameters(LocationName location, String domainName) {
        RetrieveRegisterParametersRequest request = RetrieveRegisterParametersRequest.newBuilder().setLocation(location == null ? null : location.toString()).setDomainName(domainName).build();
        return this.retrieveRegisterParameters(request);
    }

    public final RetrieveRegisterParametersResponse retrieveRegisterParameters(String location, String domainName) {
        RetrieveRegisterParametersRequest request = RetrieveRegisterParametersRequest.newBuilder().setLocation(location).setDomainName(domainName).build();
        return this.retrieveRegisterParameters(request);
    }

    public final RetrieveRegisterParametersResponse retrieveRegisterParameters(RetrieveRegisterParametersRequest request) {
        return (RetrieveRegisterParametersResponse)this.retrieveRegisterParametersCallable().call((Object)request);
    }

    public final UnaryCallable<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersCallable() {
        return this.stub.retrieveRegisterParametersCallable();
    }

    public final OperationFuture<Registration, OperationMetadata> registerDomainAsync(LocationName parent, Registration registration, Money yearlyPrice) {
        RegisterDomainRequest request = RegisterDomainRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRegistration(registration).setYearlyPrice(yearlyPrice).build();
        return this.registerDomainAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> registerDomainAsync(String parent, Registration registration, Money yearlyPrice) {
        RegisterDomainRequest request = RegisterDomainRequest.newBuilder().setParent(parent).setRegistration(registration).setYearlyPrice(yearlyPrice).build();
        return this.registerDomainAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> registerDomainAsync(RegisterDomainRequest request) {
        return this.registerDomainOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationCallable() {
        return this.stub.registerDomainOperationCallable();
    }

    public final UnaryCallable<RegisterDomainRequest, Operation> registerDomainCallable() {
        return this.stub.registerDomainCallable();
    }

    public final ListRegistrationsPagedResponse listRegistrations(LocationName parent) {
        ListRegistrationsRequest request = ListRegistrationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRegistrations(request);
    }

    public final ListRegistrationsPagedResponse listRegistrations(String parent) {
        ListRegistrationsRequest request = ListRegistrationsRequest.newBuilder().setParent(parent).build();
        return this.listRegistrations(request);
    }

    public final ListRegistrationsPagedResponse listRegistrations(ListRegistrationsRequest request) {
        return (ListRegistrationsPagedResponse)((Object)this.listRegistrationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegistrationsRequest, ListRegistrationsPagedResponse> listRegistrationsPagedCallable() {
        return this.stub.listRegistrationsPagedCallable();
    }

    public final UnaryCallable<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsCallable() {
        return this.stub.listRegistrationsCallable();
    }

    public final Registration getRegistration(RegistrationName name) {
        GetRegistrationRequest request = GetRegistrationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRegistration(request);
    }

    public final Registration getRegistration(String name) {
        GetRegistrationRequest request = GetRegistrationRequest.newBuilder().setName(name).build();
        return this.getRegistration(request);
    }

    public final Registration getRegistration(GetRegistrationRequest request) {
        return (Registration)this.getRegistrationCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegistrationRequest, Registration> getRegistrationCallable() {
        return this.stub.getRegistrationCallable();
    }

    public final OperationFuture<Registration, OperationMetadata> updateRegistrationAsync(Registration registration, FieldMask updateMask) {
        UpdateRegistrationRequest request = UpdateRegistrationRequest.newBuilder().setRegistration(registration).setUpdateMask(updateMask).build();
        return this.updateRegistrationAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> updateRegistrationAsync(UpdateRegistrationRequest request) {
        return this.updateRegistrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationCallable() {
        return this.stub.updateRegistrationOperationCallable();
    }

    public final UnaryCallable<UpdateRegistrationRequest, Operation> updateRegistrationCallable() {
        return this.stub.updateRegistrationCallable();
    }

    public final OperationFuture<Registration, OperationMetadata> configureManagementSettingsAsync(RegistrationName registration, ManagementSettings managementSettings, FieldMask updateMask) {
        ConfigureManagementSettingsRequest request = ConfigureManagementSettingsRequest.newBuilder().setRegistration(registration == null ? null : registration.toString()).setManagementSettings(managementSettings).setUpdateMask(updateMask).build();
        return this.configureManagementSettingsAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> configureManagementSettingsAsync(String registration, ManagementSettings managementSettings, FieldMask updateMask) {
        ConfigureManagementSettingsRequest request = ConfigureManagementSettingsRequest.newBuilder().setRegistration(registration).setManagementSettings(managementSettings).setUpdateMask(updateMask).build();
        return this.configureManagementSettingsAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> configureManagementSettingsAsync(ConfigureManagementSettingsRequest request) {
        return this.configureManagementSettingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationCallable() {
        return this.stub.configureManagementSettingsOperationCallable();
    }

    public final UnaryCallable<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsCallable() {
        return this.stub.configureManagementSettingsCallable();
    }

    public final OperationFuture<Registration, OperationMetadata> configureDnsSettingsAsync(RegistrationName registration, DnsSettings dnsSettings, FieldMask updateMask) {
        ConfigureDnsSettingsRequest request = ConfigureDnsSettingsRequest.newBuilder().setRegistration(registration == null ? null : registration.toString()).setDnsSettings(dnsSettings).setUpdateMask(updateMask).build();
        return this.configureDnsSettingsAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> configureDnsSettingsAsync(String registration, DnsSettings dnsSettings, FieldMask updateMask) {
        ConfigureDnsSettingsRequest request = ConfigureDnsSettingsRequest.newBuilder().setRegistration(registration).setDnsSettings(dnsSettings).setUpdateMask(updateMask).build();
        return this.configureDnsSettingsAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> configureDnsSettingsAsync(ConfigureDnsSettingsRequest request) {
        return this.configureDnsSettingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationCallable() {
        return this.stub.configureDnsSettingsOperationCallable();
    }

    public final UnaryCallable<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsCallable() {
        return this.stub.configureDnsSettingsCallable();
    }

    public final OperationFuture<Registration, OperationMetadata> configureContactSettingsAsync(RegistrationName registration, ContactSettings contactSettings, FieldMask updateMask) {
        ConfigureContactSettingsRequest request = ConfigureContactSettingsRequest.newBuilder().setRegistration(registration == null ? null : registration.toString()).setContactSettings(contactSettings).setUpdateMask(updateMask).build();
        return this.configureContactSettingsAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> configureContactSettingsAsync(String registration, ContactSettings contactSettings, FieldMask updateMask) {
        ConfigureContactSettingsRequest request = ConfigureContactSettingsRequest.newBuilder().setRegistration(registration).setContactSettings(contactSettings).setUpdateMask(updateMask).build();
        return this.configureContactSettingsAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> configureContactSettingsAsync(ConfigureContactSettingsRequest request) {
        return this.configureContactSettingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationCallable() {
        return this.stub.configureContactSettingsOperationCallable();
    }

    public final UnaryCallable<ConfigureContactSettingsRequest, Operation> configureContactSettingsCallable() {
        return this.stub.configureContactSettingsCallable();
    }

    public final OperationFuture<Registration, OperationMetadata> exportRegistrationAsync(RegistrationName name) {
        ExportRegistrationRequest request = ExportRegistrationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.exportRegistrationAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> exportRegistrationAsync(String name) {
        ExportRegistrationRequest request = ExportRegistrationRequest.newBuilder().setName(name).build();
        return this.exportRegistrationAsync(request);
    }

    public final OperationFuture<Registration, OperationMetadata> exportRegistrationAsync(ExportRegistrationRequest request) {
        return this.exportRegistrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationCallable() {
        return this.stub.exportRegistrationOperationCallable();
    }

    public final UnaryCallable<ExportRegistrationRequest, Operation> exportRegistrationCallable() {
        return this.stub.exportRegistrationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRegistrationAsync(RegistrationName name) {
        DeleteRegistrationRequest request = DeleteRegistrationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRegistrationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRegistrationAsync(String name) {
        DeleteRegistrationRequest request = DeleteRegistrationRequest.newBuilder().setName(name).build();
        return this.deleteRegistrationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRegistrationAsync(DeleteRegistrationRequest request) {
        return this.deleteRegistrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationCallable() {
        return this.stub.deleteRegistrationOperationCallable();
    }

    public final UnaryCallable<DeleteRegistrationRequest, Operation> deleteRegistrationCallable() {
        return this.stub.deleteRegistrationCallable();
    }

    public final AuthorizationCode retrieveAuthorizationCode(RegistrationName registration) {
        RetrieveAuthorizationCodeRequest request = RetrieveAuthorizationCodeRequest.newBuilder().setRegistration(registration == null ? null : registration.toString()).build();
        return this.retrieveAuthorizationCode(request);
    }

    public final AuthorizationCode retrieveAuthorizationCode(String registration) {
        RetrieveAuthorizationCodeRequest request = RetrieveAuthorizationCodeRequest.newBuilder().setRegistration(registration).build();
        return this.retrieveAuthorizationCode(request);
    }

    public final AuthorizationCode retrieveAuthorizationCode(RetrieveAuthorizationCodeRequest request) {
        return (AuthorizationCode)this.retrieveAuthorizationCodeCallable().call((Object)request);
    }

    public final UnaryCallable<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeCallable() {
        return this.stub.retrieveAuthorizationCodeCallable();
    }

    public final AuthorizationCode resetAuthorizationCode(RegistrationName registration) {
        ResetAuthorizationCodeRequest request = ResetAuthorizationCodeRequest.newBuilder().setRegistration(registration == null ? null : registration.toString()).build();
        return this.resetAuthorizationCode(request);
    }

    public final AuthorizationCode resetAuthorizationCode(String registration) {
        ResetAuthorizationCodeRequest request = ResetAuthorizationCodeRequest.newBuilder().setRegistration(registration).build();
        return this.resetAuthorizationCode(request);
    }

    public final AuthorizationCode resetAuthorizationCode(ResetAuthorizationCodeRequest request) {
        return (AuthorizationCode)this.resetAuthorizationCodeCallable().call((Object)request);
    }

    public final UnaryCallable<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeCallable() {
        return this.stub.resetAuthorizationCodeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegistrationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegistrationsRequest, ListRegistrationsResponse, Registration, ListRegistrationsPage, ListRegistrationsFixedSizeCollection> {
        private ListRegistrationsFixedSizeCollection(List<ListRegistrationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegistrationsFixedSizeCollection createEmptyCollection() {
            return new ListRegistrationsFixedSizeCollection(null, 0);
        }

        protected ListRegistrationsFixedSizeCollection createCollection(List<ListRegistrationsPage> pages, int collectionSize) {
            return new ListRegistrationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegistrationsPage
    extends AbstractPage<ListRegistrationsRequest, ListRegistrationsResponse, Registration, ListRegistrationsPage> {
        private ListRegistrationsPage(PageContext<ListRegistrationsRequest, ListRegistrationsResponse, Registration> context, ListRegistrationsResponse response) {
            super(context, (Object)response);
        }

        private static ListRegistrationsPage createEmptyPage() {
            return new ListRegistrationsPage(null, null);
        }

        protected ListRegistrationsPage createPage(PageContext<ListRegistrationsRequest, ListRegistrationsResponse, Registration> context, ListRegistrationsResponse response) {
            return new ListRegistrationsPage(context, response);
        }

        public ApiFuture<ListRegistrationsPage> createPageAsync(PageContext<ListRegistrationsRequest, ListRegistrationsResponse, Registration> context, ApiFuture<ListRegistrationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegistrationsPagedResponse
    extends AbstractPagedListResponse<ListRegistrationsRequest, ListRegistrationsResponse, Registration, ListRegistrationsPage, ListRegistrationsFixedSizeCollection> {
        public static ApiFuture<ListRegistrationsPagedResponse> createAsync(PageContext<ListRegistrationsRequest, ListRegistrationsResponse, Registration> context, ApiFuture<ListRegistrationsResponse> futureResponse) {
            ApiFuture<ListRegistrationsPage> futurePage = ListRegistrationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRegistrationsPagedResponse((ListRegistrationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRegistrationsPagedResponse(ListRegistrationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegistrationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

