/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsRequest;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsResponse;
import com.google.cloud.documentai.v1beta3.Dataset;
import com.google.cloud.documentai.v1beta3.DatasetSchema;
import com.google.cloud.documentai.v1beta3.DocumentServiceClient;
import com.google.cloud.documentai.v1beta3.GetDatasetSchemaRequest;
import com.google.cloud.documentai.v1beta3.GetDocumentRequest;
import com.google.cloud.documentai.v1beta3.GetDocumentResponse;
import com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata;
import com.google.cloud.documentai.v1beta3.ImportDocumentsRequest;
import com.google.cloud.documentai.v1beta3.ImportDocumentsResponse;
import com.google.cloud.documentai.v1beta3.ListDocumentsRequest;
import com.google.cloud.documentai.v1beta3.ListDocumentsResponse;
import com.google.cloud.documentai.v1beta3.UpdateDatasetOperationMetadata;
import com.google.cloud.documentai.v1beta3.UpdateDatasetRequest;
import com.google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest;
import com.google.cloud.documentai.v1beta3.stub.DocumentServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentServiceStubSettings;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDocumentServiceStub
extends DocumentServiceStub {
    private static final MethodDescriptor<UpdateDatasetRequest, Operation> updateDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/UpdateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportDocumentsRequest, Operation> importDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/ImportDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDocumentRequest, GetDocumentResponse> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/GetDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetDocumentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/ListDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/BatchDeleteDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchDeleteDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/GetDatasetSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatasetSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DatasetSchema.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentService/UpdateDatasetSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DatasetSchema.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<UpdateDatasetRequest, Operation> updateDatasetCallable;
    private final OperationCallable<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationCallable;
    private final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable;
    private final OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationCallable;
    private final UnaryCallable<GetDocumentRequest, GetDocumentResponse> getDocumentCallable;
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsCallable;
    private final OperationCallable<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationCallable;
    private final UnaryCallable<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaCallable;
    private final UnaryCallable<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DocumentServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentServiceStub create(DocumentServiceStubSettings settings) throws IOException {
        return new GrpcDocumentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentServiceStub(DocumentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentServiceStub(DocumentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentServiceStub(DocumentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentServiceCallableFactory());
    }

    protected GrpcDocumentServiceStub(DocumentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings updateDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset.name", String.valueOf(request.getDataset().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings importDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDocumentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset", String.valueOf(request.getDataset()));
            return builder.build();
        }).build();
        GrpcCallSettings getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset", String.valueOf(request.getDataset()));
            return builder.build();
        }).build();
        GrpcCallSettings listDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset", String.valueOf(request.getDataset()));
            return builder.build();
        }).build();
        GrpcCallSettings batchDeleteDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchDeleteDocumentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset", String.valueOf(request.getDataset()));
            return builder.build();
        }).build();
        GrpcCallSettings getDatasetSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatasetSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDatasetSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset_schema.name", String.valueOf(request.getDatasetSchema().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.updateDatasetCallable = callableFactory.createUnaryCallable(updateDatasetTransportSettings, settings.updateDatasetSettings(), clientContext);
        this.updateDatasetOperationCallable = callableFactory.createOperationCallable(updateDatasetTransportSettings, settings.updateDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDocumentsCallable = callableFactory.createUnaryCallable(importDocumentsTransportSettings, settings.importDocumentsSettings(), clientContext);
        this.importDocumentsOperationCallable = callableFactory.createOperationCallable(importDocumentsTransportSettings, settings.importDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.batchDeleteDocumentsCallable = callableFactory.createUnaryCallable(batchDeleteDocumentsTransportSettings, settings.batchDeleteDocumentsSettings(), clientContext);
        this.batchDeleteDocumentsOperationCallable = callableFactory.createOperationCallable(batchDeleteDocumentsTransportSettings, settings.batchDeleteDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDatasetSchemaCallable = callableFactory.createUnaryCallable(getDatasetSchemaTransportSettings, settings.getDatasetSchemaSettings(), clientContext);
        this.updateDatasetSchemaCallable = callableFactory.createUnaryCallable(updateDatasetSchemaTransportSettings, settings.updateDatasetSchemaSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<UpdateDatasetRequest, Operation> updateDatasetCallable() {
        return this.updateDatasetCallable;
    }

    @Override
    public OperationCallable<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationCallable() {
        return this.updateDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.importDocumentsCallable;
    }

    @Override
    public OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.importDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, GetDocumentResponse> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsCallable() {
        return this.batchDeleteDocumentsCallable;
    }

    @Override
    public OperationCallable<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationCallable() {
        return this.batchDeleteDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaCallable() {
        return this.getDatasetSchemaCallable;
    }

    @Override
    public UnaryCallable<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaCallable() {
        return this.updateDatasetSchemaCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DocumentServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

