/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.CreateProcessorRequest;
import com.google.cloud.documentai.v1beta3.DeleteProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DeleteProcessorRequest;
import com.google.cloud.documentai.v1beta3.DeleteProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.DeleteProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.DeployProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.DeployProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.DeployProcessorVersionResponse;
import com.google.cloud.documentai.v1beta3.DisableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DisableProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorResponse;
import com.google.cloud.documentai.v1beta3.DocumentProcessorServiceClient;
import com.google.cloud.documentai.v1beta3.EnableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.EnableProcessorRequest;
import com.google.cloud.documentai.v1beta3.EnableProcessorResponse;
import com.google.cloud.documentai.v1beta3.EvaluateProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.EvaluateProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.EvaluateProcessorVersionResponse;
import com.google.cloud.documentai.v1beta3.Evaluation;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesRequest;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesResponse;
import com.google.cloud.documentai.v1beta3.GetEvaluationRequest;
import com.google.cloud.documentai.v1beta3.GetProcessorRequest;
import com.google.cloud.documentai.v1beta3.GetProcessorTypeRequest;
import com.google.cloud.documentai.v1beta3.GetProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.ImportProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.ImportProcessorVersionResponse;
import com.google.cloud.documentai.v1beta3.ListEvaluationsRequest;
import com.google.cloud.documentai.v1beta3.ListEvaluationsResponse;
import com.google.cloud.documentai.v1beta3.ListProcessorTypesRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorTypesResponse;
import com.google.cloud.documentai.v1beta3.ListProcessorVersionsRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorVersionsResponse;
import com.google.cloud.documentai.v1beta3.ListProcessorsRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorsResponse;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.Processor;
import com.google.cloud.documentai.v1beta3.ProcessorType;
import com.google.cloud.documentai.v1beta3.ProcessorVersion;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.SetDefaultProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.SetDefaultProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.SetDefaultProcessorVersionResponse;
import com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.TrainProcessorVersionResponse;
import com.google.cloud.documentai.v1beta3.UndeployProcessorVersionMetadata;
import com.google.cloud.documentai.v1beta3.UndeployProcessorVersionRequest;
import com.google.cloud.documentai.v1beta3.UndeployProcessorVersionResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.HttpJsonDocumentProcessorServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DocumentProcessorServiceStubSettings
extends StubSettings<DocumentProcessorServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ProcessRequest, ProcessResponse> processDocumentSettings;
    private final UnaryCallSettings<BatchProcessRequest, Operation> batchProcessDocumentsSettings;
    private final OperationCallSettings<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings;
    private final UnaryCallSettings<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings;
    private final PagedCallSettings<ListProcessorTypesRequest, ListProcessorTypesResponse, DocumentProcessorServiceClient.ListProcessorTypesPagedResponse> listProcessorTypesSettings;
    private final UnaryCallSettings<GetProcessorTypeRequest, ProcessorType> getProcessorTypeSettings;
    private final PagedCallSettings<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings;
    private final UnaryCallSettings<GetProcessorRequest, Processor> getProcessorSettings;
    private final UnaryCallSettings<TrainProcessorVersionRequest, Operation> trainProcessorVersionSettings;
    private final OperationCallSettings<TrainProcessorVersionRequest, TrainProcessorVersionResponse, TrainProcessorVersionMetadata> trainProcessorVersionOperationSettings;
    private final UnaryCallSettings<GetProcessorVersionRequest, ProcessorVersion> getProcessorVersionSettings;
    private final PagedCallSettings<ListProcessorVersionsRequest, ListProcessorVersionsResponse, DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse> listProcessorVersionsSettings;
    private final UnaryCallSettings<DeleteProcessorVersionRequest, Operation> deleteProcessorVersionSettings;
    private final OperationCallSettings<DeleteProcessorVersionRequest, Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionOperationSettings;
    private final UnaryCallSettings<DeployProcessorVersionRequest, Operation> deployProcessorVersionSettings;
    private final OperationCallSettings<DeployProcessorVersionRequest, DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionOperationSettings;
    private final UnaryCallSettings<UndeployProcessorVersionRequest, Operation> undeployProcessorVersionSettings;
    private final OperationCallSettings<UndeployProcessorVersionRequest, UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionOperationSettings;
    private final UnaryCallSettings<CreateProcessorRequest, Processor> createProcessorSettings;
    private final UnaryCallSettings<DeleteProcessorRequest, Operation> deleteProcessorSettings;
    private final OperationCallSettings<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings;
    private final UnaryCallSettings<EnableProcessorRequest, Operation> enableProcessorSettings;
    private final OperationCallSettings<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings;
    private final UnaryCallSettings<DisableProcessorRequest, Operation> disableProcessorSettings;
    private final OperationCallSettings<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings;
    private final UnaryCallSettings<SetDefaultProcessorVersionRequest, Operation> setDefaultProcessorVersionSettings;
    private final OperationCallSettings<SetDefaultProcessorVersionRequest, SetDefaultProcessorVersionResponse, SetDefaultProcessorVersionMetadata> setDefaultProcessorVersionOperationSettings;
    private final UnaryCallSettings<ReviewDocumentRequest, Operation> reviewDocumentSettings;
    private final OperationCallSettings<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings;
    private final UnaryCallSettings<EvaluateProcessorVersionRequest, Operation> evaluateProcessorVersionSettings;
    private final OperationCallSettings<EvaluateProcessorVersionRequest, EvaluateProcessorVersionResponse, EvaluateProcessorVersionMetadata> evaluateProcessorVersionOperationSettings;
    private final UnaryCallSettings<GetEvaluationRequest, Evaluation> getEvaluationSettings;
    private final PagedCallSettings<ListEvaluationsRequest, ListEvaluationsResponse, DocumentProcessorServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings;
    private final UnaryCallSettings<ImportProcessorVersionRequest, Operation> importProcessorVersionSettings;
    private final OperationCallSettings<ImportProcessorVersionRequest, ImportProcessorVersionResponse, ImportProcessorVersionMetadata> importProcessorVersionOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DocumentProcessorServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType> LIST_PROCESSOR_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessorTypesRequest injectToken(ListProcessorTypesRequest payload, String token) {
            return ListProcessorTypesRequest.newBuilder((ListProcessorTypesRequest)payload).setPageToken(token).build();
        }

        public ListProcessorTypesRequest injectPageSize(ListProcessorTypesRequest payload, int pageSize) {
            return ListProcessorTypesRequest.newBuilder((ListProcessorTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessorTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessorTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ProcessorType> extractResources(ListProcessorTypesResponse payload) {
            return payload.getProcessorTypesList() == null ? ImmutableList.of() : payload.getProcessorTypesList();
        }
    };
    private static final PagedListDescriptor<ListProcessorsRequest, ListProcessorsResponse, Processor> LIST_PROCESSORS_PAGE_STR_DESC = new PagedListDescriptor<ListProcessorsRequest, ListProcessorsResponse, Processor>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessorsRequest injectToken(ListProcessorsRequest payload, String token) {
            return ListProcessorsRequest.newBuilder((ListProcessorsRequest)payload).setPageToken(token).build();
        }

        public ListProcessorsRequest injectPageSize(ListProcessorsRequest payload, int pageSize) {
            return ListProcessorsRequest.newBuilder((ListProcessorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Processor> extractResources(ListProcessorsResponse payload) {
            return payload.getProcessorsList() == null ? ImmutableList.of() : payload.getProcessorsList();
        }
    };
    private static final PagedListDescriptor<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion> LIST_PROCESSOR_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessorVersionsRequest injectToken(ListProcessorVersionsRequest payload, String token) {
            return ListProcessorVersionsRequest.newBuilder((ListProcessorVersionsRequest)payload).setPageToken(token).build();
        }

        public ListProcessorVersionsRequest injectPageSize(ListProcessorVersionsRequest payload, int pageSize) {
            return ListProcessorVersionsRequest.newBuilder((ListProcessorVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessorVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessorVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ProcessorVersion> extractResources(ListProcessorVersionsResponse payload) {
            return payload.getProcessorVersionsList() == null ? ImmutableList.of() : payload.getProcessorVersionsList();
        }
    };
    private static final PagedListDescriptor<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation> LIST_EVALUATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation>(){

        public String emptyToken() {
            return "";
        }

        public ListEvaluationsRequest injectToken(ListEvaluationsRequest payload, String token) {
            return ListEvaluationsRequest.newBuilder((ListEvaluationsRequest)payload).setPageToken(token).build();
        }

        public ListEvaluationsRequest injectPageSize(ListEvaluationsRequest payload, int pageSize) {
            return ListEvaluationsRequest.newBuilder((ListEvaluationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEvaluationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEvaluationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Evaluation> extractResources(ListEvaluationsResponse payload) {
            return payload.getEvaluationsList() == null ? ImmutableList.of() : payload.getEvaluationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListProcessorTypesRequest, ListProcessorTypesResponse, DocumentProcessorServiceClient.ListProcessorTypesPagedResponse> LIST_PROCESSOR_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessorTypesRequest, ListProcessorTypesResponse, DocumentProcessorServiceClient.ListProcessorTypesPagedResponse>(){

        public ApiFuture<DocumentProcessorServiceClient.ListProcessorTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessorTypesRequest, ListProcessorTypesResponse> callable, ListProcessorTypesRequest request, ApiCallContext context, ApiFuture<ListProcessorTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSOR_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentProcessorServiceClient.ListProcessorTypesPagedResponse.createAsync((PageContext<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> LIST_PROCESSORS_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse>(){

        public ApiFuture<DocumentProcessorServiceClient.ListProcessorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> callable, ListProcessorsRequest request, ApiCallContext context, ApiFuture<ListProcessorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentProcessorServiceClient.ListProcessorsPagedResponse.createAsync((PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProcessorVersionsRequest, ListProcessorVersionsResponse, DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse> LIST_PROCESSOR_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessorVersionsRequest, ListProcessorVersionsResponse, DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse>(){

        public ApiFuture<DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessorVersionsRequest, ListProcessorVersionsResponse> callable, ListProcessorVersionsRequest request, ApiCallContext context, ApiFuture<ListProcessorVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSOR_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse.createAsync((PageContext<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEvaluationsRequest, ListEvaluationsResponse, DocumentProcessorServiceClient.ListEvaluationsPagedResponse> LIST_EVALUATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListEvaluationsRequest, ListEvaluationsResponse, DocumentProcessorServiceClient.ListEvaluationsPagedResponse>(){

        public ApiFuture<DocumentProcessorServiceClient.ListEvaluationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEvaluationsRequest, ListEvaluationsResponse> callable, ListEvaluationsRequest request, ApiCallContext context, ApiFuture<ListEvaluationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVALUATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentProcessorServiceClient.ListEvaluationsPagedResponse.createAsync((PageContext<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DocumentProcessorServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DocumentProcessorServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DocumentProcessorServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentProcessorServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ProcessRequest, ProcessResponse> processDocumentSettings() {
        return this.processDocumentSettings;
    }

    public UnaryCallSettings<BatchProcessRequest, Operation> batchProcessDocumentsSettings() {
        return this.batchProcessDocumentsSettings;
    }

    public OperationCallSettings<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings() {
        return this.batchProcessDocumentsOperationSettings;
    }

    public UnaryCallSettings<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings() {
        return this.fetchProcessorTypesSettings;
    }

    public PagedCallSettings<ListProcessorTypesRequest, ListProcessorTypesResponse, DocumentProcessorServiceClient.ListProcessorTypesPagedResponse> listProcessorTypesSettings() {
        return this.listProcessorTypesSettings;
    }

    public UnaryCallSettings<GetProcessorTypeRequest, ProcessorType> getProcessorTypeSettings() {
        return this.getProcessorTypeSettings;
    }

    public PagedCallSettings<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings() {
        return this.listProcessorsSettings;
    }

    public UnaryCallSettings<GetProcessorRequest, Processor> getProcessorSettings() {
        return this.getProcessorSettings;
    }

    public UnaryCallSettings<TrainProcessorVersionRequest, Operation> trainProcessorVersionSettings() {
        return this.trainProcessorVersionSettings;
    }

    public OperationCallSettings<TrainProcessorVersionRequest, TrainProcessorVersionResponse, TrainProcessorVersionMetadata> trainProcessorVersionOperationSettings() {
        return this.trainProcessorVersionOperationSettings;
    }

    public UnaryCallSettings<GetProcessorVersionRequest, ProcessorVersion> getProcessorVersionSettings() {
        return this.getProcessorVersionSettings;
    }

    public PagedCallSettings<ListProcessorVersionsRequest, ListProcessorVersionsResponse, DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse> listProcessorVersionsSettings() {
        return this.listProcessorVersionsSettings;
    }

    public UnaryCallSettings<DeleteProcessorVersionRequest, Operation> deleteProcessorVersionSettings() {
        return this.deleteProcessorVersionSettings;
    }

    public OperationCallSettings<DeleteProcessorVersionRequest, Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionOperationSettings() {
        return this.deleteProcessorVersionOperationSettings;
    }

    public UnaryCallSettings<DeployProcessorVersionRequest, Operation> deployProcessorVersionSettings() {
        return this.deployProcessorVersionSettings;
    }

    public OperationCallSettings<DeployProcessorVersionRequest, DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionOperationSettings() {
        return this.deployProcessorVersionOperationSettings;
    }

    public UnaryCallSettings<UndeployProcessorVersionRequest, Operation> undeployProcessorVersionSettings() {
        return this.undeployProcessorVersionSettings;
    }

    public OperationCallSettings<UndeployProcessorVersionRequest, UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionOperationSettings() {
        return this.undeployProcessorVersionOperationSettings;
    }

    public UnaryCallSettings<CreateProcessorRequest, Processor> createProcessorSettings() {
        return this.createProcessorSettings;
    }

    public UnaryCallSettings<DeleteProcessorRequest, Operation> deleteProcessorSettings() {
        return this.deleteProcessorSettings;
    }

    public OperationCallSettings<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings() {
        return this.deleteProcessorOperationSettings;
    }

    public UnaryCallSettings<EnableProcessorRequest, Operation> enableProcessorSettings() {
        return this.enableProcessorSettings;
    }

    public OperationCallSettings<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings() {
        return this.enableProcessorOperationSettings;
    }

    public UnaryCallSettings<DisableProcessorRequest, Operation> disableProcessorSettings() {
        return this.disableProcessorSettings;
    }

    public OperationCallSettings<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings() {
        return this.disableProcessorOperationSettings;
    }

    public UnaryCallSettings<SetDefaultProcessorVersionRequest, Operation> setDefaultProcessorVersionSettings() {
        return this.setDefaultProcessorVersionSettings;
    }

    public OperationCallSettings<SetDefaultProcessorVersionRequest, SetDefaultProcessorVersionResponse, SetDefaultProcessorVersionMetadata> setDefaultProcessorVersionOperationSettings() {
        return this.setDefaultProcessorVersionOperationSettings;
    }

    public UnaryCallSettings<ReviewDocumentRequest, Operation> reviewDocumentSettings() {
        return this.reviewDocumentSettings;
    }

    public OperationCallSettings<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings() {
        return this.reviewDocumentOperationSettings;
    }

    public UnaryCallSettings<EvaluateProcessorVersionRequest, Operation> evaluateProcessorVersionSettings() {
        return this.evaluateProcessorVersionSettings;
    }

    public OperationCallSettings<EvaluateProcessorVersionRequest, EvaluateProcessorVersionResponse, EvaluateProcessorVersionMetadata> evaluateProcessorVersionOperationSettings() {
        return this.evaluateProcessorVersionOperationSettings;
    }

    public UnaryCallSettings<GetEvaluationRequest, Evaluation> getEvaluationSettings() {
        return this.getEvaluationSettings;
    }

    public PagedCallSettings<ListEvaluationsRequest, ListEvaluationsResponse, DocumentProcessorServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings() {
        return this.listEvaluationsSettings;
    }

    public UnaryCallSettings<ImportProcessorVersionRequest, Operation> importProcessorVersionSettings() {
        return this.importProcessorVersionSettings;
    }

    public OperationCallSettings<ImportProcessorVersionRequest, ImportProcessorVersionResponse, ImportProcessorVersionMetadata> importProcessorVersionOperationSettings() {
        return this.importProcessorVersionOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DocumentProcessorServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DocumentProcessorServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentProcessorServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDocumentProcessorServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "documentai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "documentai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentProcessorServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentProcessorServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentProcessorServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DocumentProcessorServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentProcessorServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.processDocumentSettings = settingsBuilder.processDocumentSettings().build();
        this.batchProcessDocumentsSettings = settingsBuilder.batchProcessDocumentsSettings().build();
        this.batchProcessDocumentsOperationSettings = settingsBuilder.batchProcessDocumentsOperationSettings().build();
        this.fetchProcessorTypesSettings = settingsBuilder.fetchProcessorTypesSettings().build();
        this.listProcessorTypesSettings = settingsBuilder.listProcessorTypesSettings().build();
        this.getProcessorTypeSettings = settingsBuilder.getProcessorTypeSettings().build();
        this.listProcessorsSettings = settingsBuilder.listProcessorsSettings().build();
        this.getProcessorSettings = settingsBuilder.getProcessorSettings().build();
        this.trainProcessorVersionSettings = settingsBuilder.trainProcessorVersionSettings().build();
        this.trainProcessorVersionOperationSettings = settingsBuilder.trainProcessorVersionOperationSettings().build();
        this.getProcessorVersionSettings = settingsBuilder.getProcessorVersionSettings().build();
        this.listProcessorVersionsSettings = settingsBuilder.listProcessorVersionsSettings().build();
        this.deleteProcessorVersionSettings = settingsBuilder.deleteProcessorVersionSettings().build();
        this.deleteProcessorVersionOperationSettings = settingsBuilder.deleteProcessorVersionOperationSettings().build();
        this.deployProcessorVersionSettings = settingsBuilder.deployProcessorVersionSettings().build();
        this.deployProcessorVersionOperationSettings = settingsBuilder.deployProcessorVersionOperationSettings().build();
        this.undeployProcessorVersionSettings = settingsBuilder.undeployProcessorVersionSettings().build();
        this.undeployProcessorVersionOperationSettings = settingsBuilder.undeployProcessorVersionOperationSettings().build();
        this.createProcessorSettings = settingsBuilder.createProcessorSettings().build();
        this.deleteProcessorSettings = settingsBuilder.deleteProcessorSettings().build();
        this.deleteProcessorOperationSettings = settingsBuilder.deleteProcessorOperationSettings().build();
        this.enableProcessorSettings = settingsBuilder.enableProcessorSettings().build();
        this.enableProcessorOperationSettings = settingsBuilder.enableProcessorOperationSettings().build();
        this.disableProcessorSettings = settingsBuilder.disableProcessorSettings().build();
        this.disableProcessorOperationSettings = settingsBuilder.disableProcessorOperationSettings().build();
        this.setDefaultProcessorVersionSettings = settingsBuilder.setDefaultProcessorVersionSettings().build();
        this.setDefaultProcessorVersionOperationSettings = settingsBuilder.setDefaultProcessorVersionOperationSettings().build();
        this.reviewDocumentSettings = settingsBuilder.reviewDocumentSettings().build();
        this.reviewDocumentOperationSettings = settingsBuilder.reviewDocumentOperationSettings().build();
        this.evaluateProcessorVersionSettings = settingsBuilder.evaluateProcessorVersionSettings().build();
        this.evaluateProcessorVersionOperationSettings = settingsBuilder.evaluateProcessorVersionOperationSettings().build();
        this.getEvaluationSettings = settingsBuilder.getEvaluationSettings().build();
        this.listEvaluationsSettings = settingsBuilder.listEvaluationsSettings().build();
        this.importProcessorVersionSettings = settingsBuilder.importProcessorVersionSettings().build();
        this.importProcessorVersionOperationSettings = settingsBuilder.importProcessorVersionOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentProcessorServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ProcessRequest, ProcessResponse> processDocumentSettings;
        private final UnaryCallSettings.Builder<BatchProcessRequest, Operation> batchProcessDocumentsSettings;
        private final OperationCallSettings.Builder<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings;
        private final PagedCallSettings.Builder<ListProcessorTypesRequest, ListProcessorTypesResponse, DocumentProcessorServiceClient.ListProcessorTypesPagedResponse> listProcessorTypesSettings;
        private final UnaryCallSettings.Builder<GetProcessorTypeRequest, ProcessorType> getProcessorTypeSettings;
        private final PagedCallSettings.Builder<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings;
        private final UnaryCallSettings.Builder<GetProcessorRequest, Processor> getProcessorSettings;
        private final UnaryCallSettings.Builder<TrainProcessorVersionRequest, Operation> trainProcessorVersionSettings;
        private final OperationCallSettings.Builder<TrainProcessorVersionRequest, TrainProcessorVersionResponse, TrainProcessorVersionMetadata> trainProcessorVersionOperationSettings;
        private final UnaryCallSettings.Builder<GetProcessorVersionRequest, ProcessorVersion> getProcessorVersionSettings;
        private final PagedCallSettings.Builder<ListProcessorVersionsRequest, ListProcessorVersionsResponse, DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse> listProcessorVersionsSettings;
        private final UnaryCallSettings.Builder<DeleteProcessorVersionRequest, Operation> deleteProcessorVersionSettings;
        private final OperationCallSettings.Builder<DeleteProcessorVersionRequest, Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionOperationSettings;
        private final UnaryCallSettings.Builder<DeployProcessorVersionRequest, Operation> deployProcessorVersionSettings;
        private final OperationCallSettings.Builder<DeployProcessorVersionRequest, DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionOperationSettings;
        private final UnaryCallSettings.Builder<UndeployProcessorVersionRequest, Operation> undeployProcessorVersionSettings;
        private final OperationCallSettings.Builder<UndeployProcessorVersionRequest, UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionOperationSettings;
        private final UnaryCallSettings.Builder<CreateProcessorRequest, Processor> createProcessorSettings;
        private final UnaryCallSettings.Builder<DeleteProcessorRequest, Operation> deleteProcessorSettings;
        private final OperationCallSettings.Builder<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings;
        private final UnaryCallSettings.Builder<EnableProcessorRequest, Operation> enableProcessorSettings;
        private final OperationCallSettings.Builder<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings;
        private final UnaryCallSettings.Builder<DisableProcessorRequest, Operation> disableProcessorSettings;
        private final OperationCallSettings.Builder<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings;
        private final UnaryCallSettings.Builder<SetDefaultProcessorVersionRequest, Operation> setDefaultProcessorVersionSettings;
        private final OperationCallSettings.Builder<SetDefaultProcessorVersionRequest, SetDefaultProcessorVersionResponse, SetDefaultProcessorVersionMetadata> setDefaultProcessorVersionOperationSettings;
        private final UnaryCallSettings.Builder<ReviewDocumentRequest, Operation> reviewDocumentSettings;
        private final OperationCallSettings.Builder<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings;
        private final UnaryCallSettings.Builder<EvaluateProcessorVersionRequest, Operation> evaluateProcessorVersionSettings;
        private final OperationCallSettings.Builder<EvaluateProcessorVersionRequest, EvaluateProcessorVersionResponse, EvaluateProcessorVersionMetadata> evaluateProcessorVersionOperationSettings;
        private final UnaryCallSettings.Builder<GetEvaluationRequest, Evaluation> getEvaluationSettings;
        private final PagedCallSettings.Builder<ListEvaluationsRequest, ListEvaluationsResponse, DocumentProcessorServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings;
        private final UnaryCallSettings.Builder<ImportProcessorVersionRequest, Operation> importProcessorVersionSettings;
        private final OperationCallSettings.Builder<ImportProcessorVersionRequest, ImportProcessorVersionResponse, ImportProcessorVersionMetadata> importProcessorVersionOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DocumentProcessorServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.processDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchProcessDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchProcessDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.fetchProcessorTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProcessorTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSOR_TYPES_PAGE_STR_FACT);
            this.getProcessorTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProcessorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSORS_PAGE_STR_FACT);
            this.getProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.trainProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.trainProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.getProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProcessorVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSOR_VERSIONS_PAGE_STR_FACT);
            this.deleteProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.deployProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.undeployProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.createProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.enableProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.disableProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.setDefaultProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDefaultProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.reviewDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reviewDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.evaluateProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.evaluateProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.getEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEvaluationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVALUATIONS_PAGE_STR_FACT);
            this.importProcessorVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importProcessorVersionOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processDocumentSettings, this.batchProcessDocumentsSettings, this.fetchProcessorTypesSettings, this.listProcessorTypesSettings, this.getProcessorTypeSettings, this.listProcessorsSettings, this.getProcessorSettings, this.trainProcessorVersionSettings, this.getProcessorVersionSettings, this.listProcessorVersionsSettings, this.deleteProcessorVersionSettings, this.deployProcessorVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.undeployProcessorVersionSettings, this.createProcessorSettings, this.deleteProcessorSettings, this.enableProcessorSettings, this.disableProcessorSettings, this.setDefaultProcessorVersionSettings, this.reviewDocumentSettings, this.evaluateProcessorVersionSettings, this.getEvaluationSettings, this.listEvaluationsSettings, this.importProcessorVersionSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DocumentProcessorServiceStubSettings settings) {
            super((StubSettings)settings);
            this.processDocumentSettings = settings.processDocumentSettings.toBuilder();
            this.batchProcessDocumentsSettings = settings.batchProcessDocumentsSettings.toBuilder();
            this.batchProcessDocumentsOperationSettings = settings.batchProcessDocumentsOperationSettings.toBuilder();
            this.fetchProcessorTypesSettings = settings.fetchProcessorTypesSettings.toBuilder();
            this.listProcessorTypesSettings = settings.listProcessorTypesSettings.toBuilder();
            this.getProcessorTypeSettings = settings.getProcessorTypeSettings.toBuilder();
            this.listProcessorsSettings = settings.listProcessorsSettings.toBuilder();
            this.getProcessorSettings = settings.getProcessorSettings.toBuilder();
            this.trainProcessorVersionSettings = settings.trainProcessorVersionSettings.toBuilder();
            this.trainProcessorVersionOperationSettings = settings.trainProcessorVersionOperationSettings.toBuilder();
            this.getProcessorVersionSettings = settings.getProcessorVersionSettings.toBuilder();
            this.listProcessorVersionsSettings = settings.listProcessorVersionsSettings.toBuilder();
            this.deleteProcessorVersionSettings = settings.deleteProcessorVersionSettings.toBuilder();
            this.deleteProcessorVersionOperationSettings = settings.deleteProcessorVersionOperationSettings.toBuilder();
            this.deployProcessorVersionSettings = settings.deployProcessorVersionSettings.toBuilder();
            this.deployProcessorVersionOperationSettings = settings.deployProcessorVersionOperationSettings.toBuilder();
            this.undeployProcessorVersionSettings = settings.undeployProcessorVersionSettings.toBuilder();
            this.undeployProcessorVersionOperationSettings = settings.undeployProcessorVersionOperationSettings.toBuilder();
            this.createProcessorSettings = settings.createProcessorSettings.toBuilder();
            this.deleteProcessorSettings = settings.deleteProcessorSettings.toBuilder();
            this.deleteProcessorOperationSettings = settings.deleteProcessorOperationSettings.toBuilder();
            this.enableProcessorSettings = settings.enableProcessorSettings.toBuilder();
            this.enableProcessorOperationSettings = settings.enableProcessorOperationSettings.toBuilder();
            this.disableProcessorSettings = settings.disableProcessorSettings.toBuilder();
            this.disableProcessorOperationSettings = settings.disableProcessorOperationSettings.toBuilder();
            this.setDefaultProcessorVersionSettings = settings.setDefaultProcessorVersionSettings.toBuilder();
            this.setDefaultProcessorVersionOperationSettings = settings.setDefaultProcessorVersionOperationSettings.toBuilder();
            this.reviewDocumentSettings = settings.reviewDocumentSettings.toBuilder();
            this.reviewDocumentOperationSettings = settings.reviewDocumentOperationSettings.toBuilder();
            this.evaluateProcessorVersionSettings = settings.evaluateProcessorVersionSettings.toBuilder();
            this.evaluateProcessorVersionOperationSettings = settings.evaluateProcessorVersionOperationSettings.toBuilder();
            this.getEvaluationSettings = settings.getEvaluationSettings.toBuilder();
            this.listEvaluationsSettings = settings.listEvaluationsSettings.toBuilder();
            this.importProcessorVersionSettings = settings.importProcessorVersionSettings.toBuilder();
            this.importProcessorVersionOperationSettings = settings.importProcessorVersionOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processDocumentSettings, this.batchProcessDocumentsSettings, this.fetchProcessorTypesSettings, this.listProcessorTypesSettings, this.getProcessorTypeSettings, this.listProcessorsSettings, this.getProcessorSettings, this.trainProcessorVersionSettings, this.getProcessorVersionSettings, this.listProcessorVersionsSettings, this.deleteProcessorVersionSettings, this.deployProcessorVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.undeployProcessorVersionSettings, this.createProcessorSettings, this.deleteProcessorSettings, this.enableProcessorSettings, this.disableProcessorSettings, this.setDefaultProcessorVersionSettings, this.reviewDocumentSettings, this.evaluateProcessorVersionSettings, this.getEvaluationSettings, this.listEvaluationsSettings, this.importProcessorVersionSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentProcessorServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentProcessorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentProcessorServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentProcessorServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DocumentProcessorServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DocumentProcessorServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DocumentProcessorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentProcessorServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentProcessorServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DocumentProcessorServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.processDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchProcessDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.fetchProcessorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProcessorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getProcessorTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProcessorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.trainProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProcessorVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deployProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.undeployProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.enableProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.disableProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setDefaultProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.reviewDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.evaluateProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEvaluationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importProcessorVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchProcessDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchProcessResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchProcessMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.trainProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TrainProcessorVersionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(TrainProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeployProcessorVersionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeployProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UndeployProcessorVersionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeployProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteProcessorMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.enableProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EnableProcessorResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(EnableProcessorMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.disableProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DisableProcessorResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DisableProcessorMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.setDefaultProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SetDefaultProcessorVersionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SetDefaultProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reviewDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReviewDocumentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ReviewDocumentOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.evaluateProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EvaluateProcessorVersionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(EvaluateProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importProcessorVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportProcessorVersionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportProcessorVersionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ProcessRequest, ProcessResponse> processDocumentSettings() {
            return this.processDocumentSettings;
        }

        public UnaryCallSettings.Builder<BatchProcessRequest, Operation> batchProcessDocumentsSettings() {
            return this.batchProcessDocumentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings() {
            return this.batchProcessDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings() {
            return this.fetchProcessorTypesSettings;
        }

        public PagedCallSettings.Builder<ListProcessorTypesRequest, ListProcessorTypesResponse, DocumentProcessorServiceClient.ListProcessorTypesPagedResponse> listProcessorTypesSettings() {
            return this.listProcessorTypesSettings;
        }

        public UnaryCallSettings.Builder<GetProcessorTypeRequest, ProcessorType> getProcessorTypeSettings() {
            return this.getProcessorTypeSettings;
        }

        public PagedCallSettings.Builder<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings() {
            return this.listProcessorsSettings;
        }

        public UnaryCallSettings.Builder<GetProcessorRequest, Processor> getProcessorSettings() {
            return this.getProcessorSettings;
        }

        public UnaryCallSettings.Builder<TrainProcessorVersionRequest, Operation> trainProcessorVersionSettings() {
            return this.trainProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TrainProcessorVersionRequest, TrainProcessorVersionResponse, TrainProcessorVersionMetadata> trainProcessorVersionOperationSettings() {
            return this.trainProcessorVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetProcessorVersionRequest, ProcessorVersion> getProcessorVersionSettings() {
            return this.getProcessorVersionSettings;
        }

        public PagedCallSettings.Builder<ListProcessorVersionsRequest, ListProcessorVersionsResponse, DocumentProcessorServiceClient.ListProcessorVersionsPagedResponse> listProcessorVersionsSettings() {
            return this.listProcessorVersionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteProcessorVersionRequest, Operation> deleteProcessorVersionSettings() {
            return this.deleteProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteProcessorVersionRequest, Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionOperationSettings() {
            return this.deleteProcessorVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployProcessorVersionRequest, Operation> deployProcessorVersionSettings() {
            return this.deployProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeployProcessorVersionRequest, DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionOperationSettings() {
            return this.deployProcessorVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployProcessorVersionRequest, Operation> undeployProcessorVersionSettings() {
            return this.undeployProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UndeployProcessorVersionRequest, UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionOperationSettings() {
            return this.undeployProcessorVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateProcessorRequest, Processor> createProcessorSettings() {
            return this.createProcessorSettings;
        }

        public UnaryCallSettings.Builder<DeleteProcessorRequest, Operation> deleteProcessorSettings() {
            return this.deleteProcessorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings() {
            return this.deleteProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<EnableProcessorRequest, Operation> enableProcessorSettings() {
            return this.enableProcessorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings() {
            return this.enableProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<DisableProcessorRequest, Operation> disableProcessorSettings() {
            return this.disableProcessorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings() {
            return this.disableProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<SetDefaultProcessorVersionRequest, Operation> setDefaultProcessorVersionSettings() {
            return this.setDefaultProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetDefaultProcessorVersionRequest, SetDefaultProcessorVersionResponse, SetDefaultProcessorVersionMetadata> setDefaultProcessorVersionOperationSettings() {
            return this.setDefaultProcessorVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<ReviewDocumentRequest, Operation> reviewDocumentSettings() {
            return this.reviewDocumentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings() {
            return this.reviewDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<EvaluateProcessorVersionRequest, Operation> evaluateProcessorVersionSettings() {
            return this.evaluateProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<EvaluateProcessorVersionRequest, EvaluateProcessorVersionResponse, EvaluateProcessorVersionMetadata> evaluateProcessorVersionOperationSettings() {
            return this.evaluateProcessorVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEvaluationRequest, Evaluation> getEvaluationSettings() {
            return this.getEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListEvaluationsRequest, ListEvaluationsResponse, DocumentProcessorServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings() {
            return this.listEvaluationsSettings;
        }

        public UnaryCallSettings.Builder<ImportProcessorVersionRequest, Operation> importProcessorVersionSettings() {
            return this.importProcessorVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportProcessorVersionRequest, ImportProcessorVersionResponse, ImportProcessorVersionMetadata> importProcessorVersionOperationSettings() {
            return this.importProcessorVersionOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DocumentProcessorServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DocumentProcessorServiceStubSettings build() throws IOException {
            return new DocumentProcessorServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

