/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStubSettings;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentProcessorServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcDocumentProcessorServiceStub
extends DocumentProcessorServiceStub {
    private static final MethodDescriptor<ProcessRequest, ProcessResponse> processDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ProcessDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ProcessRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProcessResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchProcessRequest, Operation> batchProcessDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/BatchProcessDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchProcessRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ReviewDocumentRequest, Operation> reviewDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ReviewDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ReviewDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable;
    private final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable;
    private final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable;
    private final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable;
    private final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentProcessorServiceStub create(DocumentProcessorServiceStubSettings settings) throws IOException {
        return new GrpcDocumentProcessorServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentProcessorServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentProcessorServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentProcessorServiceCallableFactory());
    }

    protected GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings processDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(processDocumentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ProcessRequest>(){

            public Map<String, String> extract(ProcessRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchProcessDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchProcessDocumentsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchProcessRequest>(){

            public Map<String, String> extract(BatchProcessRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings reviewDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reviewDocumentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReviewDocumentRequest>(){

            public Map<String, String> extract(ReviewDocumentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"human_review_config", (Object)String.valueOf(request.getHumanReviewConfig()));
                return params.build();
            }
        }).build();
        this.processDocumentCallable = callableFactory.createUnaryCallable(processDocumentTransportSettings, settings.processDocumentSettings(), clientContext);
        this.batchProcessDocumentsCallable = callableFactory.createUnaryCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsSettings(), clientContext);
        this.batchProcessDocumentsOperationCallable = callableFactory.createOperationCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reviewDocumentCallable = callableFactory.createUnaryCallable(reviewDocumentTransportSettings, settings.reviewDocumentSettings(), clientContext);
        this.reviewDocumentOperationCallable = callableFactory.createOperationCallable(reviewDocumentTransportSettings, settings.reviewDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.processDocumentCallable;
    }

    @Override
    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.batchProcessDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.batchProcessDocumentsCallable;
    }

    @Override
    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.reviewDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.reviewDocumentCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

