/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.core.ApiFunction;
import com.google.api.services.dns.model.Change;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.dns.RecordSet;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class ChangeRequestInfo
implements Serializable {
    static final Function<Change, ChangeRequestInfo> FROM_PB_FUNCTION = new Function<Change, ChangeRequestInfo>(){

        public ChangeRequestInfo apply(Change pb) {
            return ChangeRequestInfo.fromPb(pb);
        }
    };
    private static final long serialVersionUID = -6029143477639439169L;
    private final List<RecordSet> additions;
    private final List<RecordSet> deletions;
    private final String generatedId;
    private final Long startTimeMillis;
    private final Status status;

    ChangeRequestInfo(BuilderImpl builder) {
        this.additions = ImmutableList.copyOf((Collection)builder.additions);
        this.deletions = ImmutableList.copyOf((Collection)builder.deletions);
        this.generatedId = builder.generatedId;
        this.startTimeMillis = builder.startTimeMillis;
        this.status = builder.status;
    }

    public static Builder newBuilder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public List<RecordSet> getAdditions() {
        return this.additions;
    }

    public List<RecordSet> getDeletions() {
        return this.deletions;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Status status() {
        return this.getStatus();
    }

    public Status getStatus() {
        return this.status;
    }

    Change toPb() {
        Change pb = new Change();
        if (this.getGeneratedId() != null) {
            pb.setId(this.getGeneratedId());
        }
        if (this.getStartTimeMillis() != null) {
            pb.setStartTime(ISODateTimeFormat.dateTime().withZoneUTC().print(this.getStartTimeMillis().longValue()));
        }
        if (this.status() != null) {
            pb.setStatus(this.status().name().toLowerCase());
        }
        pb.setAdditions(Lists.transform(this.getAdditions(), RecordSet.TO_PB_FUNCTION));
        pb.setDeletions(Lists.transform(this.getDeletions(), RecordSet.TO_PB_FUNCTION));
        return pb;
    }

    static ChangeRequestInfo fromPb(Change pb) {
        Builder builder = ChangeRequestInfo.newBuilder();
        if (pb.getId() != null) {
            builder.setGeneratedId(pb.getId());
        }
        if (pb.getStartTime() != null) {
            builder.setStartTime(DateTime.parse((String)pb.getStartTime()).getMillis());
        }
        if (pb.getStatus() != null) {
            builder.setStatus(Status.valueOf(pb.getStatus().toUpperCase()));
        }
        if (pb.getDeletions() != null) {
            builder.setDeletions(Lists.transform((List)pb.getDeletions(), RecordSet.FROM_PB_FUNCTION));
        }
        if (pb.getAdditions() != null) {
            builder.setAdditions(Lists.transform((List)pb.getAdditions(), RecordSet.FROM_PB_FUNCTION));
        }
        return builder.build();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ChangeRequestInfo.class) && this.toPb().equals((Object)((ChangeRequestInfo)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additions, this.deletions, this.generatedId, this.startTimeMillis, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("additions", this.additions).add("deletions", this.deletions).add("generatedId", (Object)this.generatedId).add("startTimeMillis", (Object)this.startTimeMillis).add("status", (Object)this.status).toString();
    }

    static class BuilderImpl
    extends Builder {
        private List<RecordSet> additions;
        private List<RecordSet> deletions;
        private String generatedId;
        private Long startTimeMillis;
        private Status status;

        BuilderImpl() {
            this.additions = new LinkedList<RecordSet>();
            this.deletions = new LinkedList<RecordSet>();
        }

        BuilderImpl(ChangeRequestInfo info) {
            this.additions = Lists.newLinkedList(info.getAdditions());
            this.deletions = Lists.newLinkedList(info.getDeletions());
            this.generatedId = info.generatedId;
            this.startTimeMillis = info.startTimeMillis;
            this.status = info.status;
        }

        @Override
        public Builder setAdditions(List<RecordSet> additions) {
            this.additions = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(additions)));
            return this;
        }

        @Override
        public Builder setDeletions(List<RecordSet> deletions) {
            this.deletions = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(deletions)));
            return this;
        }

        @Override
        public Builder add(RecordSet recordSet) {
            this.additions.add((RecordSet)Preconditions.checkNotNull((Object)recordSet));
            return this;
        }

        @Override
        public Builder delete(RecordSet recordSet) {
            this.deletions.add((RecordSet)Preconditions.checkNotNull((Object)recordSet));
            return this;
        }

        @Override
        public Builder clearAdditions() {
            this.additions.clear();
            return this;
        }

        @Override
        public Builder clearDeletions() {
            this.deletions.clear();
            return this;
        }

        @Override
        public Builder removeAddition(RecordSet recordSet) {
            this.additions.remove(recordSet);
            return this;
        }

        @Override
        public Builder removeDeletion(RecordSet recordSet) {
            this.deletions.remove(recordSet);
            return this;
        }

        @Override
        public ChangeRequestInfo build() {
            return new ChangeRequestInfo(this);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = (String)Preconditions.checkNotNull((Object)generatedId);
            return this;
        }

        @Override
        Builder setStartTime(long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            return this;
        }

        @Override
        Builder setStatus(Status status) {
            this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
            return this;
        }
    }

    public static abstract class Builder {
        public abstract Builder setAdditions(List<RecordSet> var1);

        public abstract Builder setDeletions(List<RecordSet> var1);

        public abstract Builder add(RecordSet var1);

        public abstract Builder delete(RecordSet var1);

        public abstract Builder clearAdditions();

        public abstract Builder clearDeletions();

        public abstract Builder removeAddition(RecordSet var1);

        public abstract Builder removeDeletion(RecordSet var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setStartTime(long var1);

        abstract Builder setStatus(Status var1);

        public abstract ChangeRequestInfo build();
    }

    public static final class Status
    extends StringEnumValue {
        private static final long serialVersionUID = -294992980062438246L;
        private static final ApiFunction<String, Status> CONSTRUCTOR = new ApiFunction<String, Status>(){

            public Status apply(String constant) {
                return new Status(constant);
            }
        };
        private static final StringEnumType<Status> type = new StringEnumType(Status.class, CONSTRUCTOR);
        public static final Status PENDING = (Status)((Object)type.createAndRegister("PENDING"));
        public static final Status DONE = (Status)((Object)type.createAndRegister("DONE"));

        private Status(String constant) {
            super(constant);
        }

        public static Status valueOfStrict(String constant) {
            return (Status)((Object)type.valueOfStrict(constant));
        }

        public static Status valueOf(String constant) {
            return (Status)((Object)type.valueOf(constant));
        }

        public static Status[] values() {
            return (Status[])type.values();
        }
    }
}

