/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.CommitConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.ConnectionProfile;
import com.google.cloud.clouddms.v1.ConnectionProfileName;
import com.google.cloud.clouddms.v1.ConversionWorkspace;
import com.google.cloud.clouddms.v1.ConversionWorkspaceName;
import com.google.cloud.clouddms.v1.ConvertConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.CreateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.CreateConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.CreateMigrationJobRequest;
import com.google.cloud.clouddms.v1.CreatePrivateConnectionRequest;
import com.google.cloud.clouddms.v1.DataMigrationServiceSettings;
import com.google.cloud.clouddms.v1.DatabaseEntity;
import com.google.cloud.clouddms.v1.DeleteConnectionProfileRequest;
import com.google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.DeleteMigrationJobRequest;
import com.google.cloud.clouddms.v1.DeletePrivateConnectionRequest;
import com.google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsRequest;
import com.google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse;
import com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest;
import com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesResponse;
import com.google.cloud.clouddms.v1.FetchStaticIpsRequest;
import com.google.cloud.clouddms.v1.FetchStaticIpsResponse;
import com.google.cloud.clouddms.v1.GenerateSshScriptRequest;
import com.google.cloud.clouddms.v1.GetConnectionProfileRequest;
import com.google.cloud.clouddms.v1.GetConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.GetMigrationJobRequest;
import com.google.cloud.clouddms.v1.GetPrivateConnectionRequest;
import com.google.cloud.clouddms.v1.ImportMappingRulesRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesResponse;
import com.google.cloud.clouddms.v1.ListConversionWorkspacesRequest;
import com.google.cloud.clouddms.v1.ListConversionWorkspacesResponse;
import com.google.cloud.clouddms.v1.ListMigrationJobsRequest;
import com.google.cloud.clouddms.v1.ListMigrationJobsResponse;
import com.google.cloud.clouddms.v1.ListPrivateConnectionsRequest;
import com.google.cloud.clouddms.v1.ListPrivateConnectionsResponse;
import com.google.cloud.clouddms.v1.LocationName;
import com.google.cloud.clouddms.v1.MigrationJob;
import com.google.cloud.clouddms.v1.MigrationJobName;
import com.google.cloud.clouddms.v1.OperationMetadata;
import com.google.cloud.clouddms.v1.PrivateConnection;
import com.google.cloud.clouddms.v1.PrivateConnectionName;
import com.google.cloud.clouddms.v1.PromoteMigrationJobRequest;
import com.google.cloud.clouddms.v1.RestartMigrationJobRequest;
import com.google.cloud.clouddms.v1.ResumeMigrationJobRequest;
import com.google.cloud.clouddms.v1.RollbackConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.SearchBackgroundJobsRequest;
import com.google.cloud.clouddms.v1.SearchBackgroundJobsResponse;
import com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.SshScript;
import com.google.cloud.clouddms.v1.StartMigrationJobRequest;
import com.google.cloud.clouddms.v1.StopMigrationJobRequest;
import com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.UpdateMigrationJobRequest;
import com.google.cloud.clouddms.v1.VerifyMigrationJobRequest;
import com.google.cloud.clouddms.v1.stub.DataMigrationServiceStub;
import com.google.cloud.clouddms.v1.stub.DataMigrationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataMigrationServiceClient
implements BackgroundResource {
    private final DataMigrationServiceSettings settings;
    private final DataMigrationServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DataMigrationServiceClient create() throws IOException {
        return DataMigrationServiceClient.create(DataMigrationServiceSettings.newBuilder().build());
    }

    public static final DataMigrationServiceClient create(DataMigrationServiceSettings settings) throws IOException {
        return new DataMigrationServiceClient(settings);
    }

    public static final DataMigrationServiceClient create(DataMigrationServiceStub stub) {
        return new DataMigrationServiceClient(stub);
    }

    protected DataMigrationServiceClient(DataMigrationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataMigrationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected DataMigrationServiceClient(DataMigrationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataMigrationServiceSettings getSettings() {
        return this.settings;
    }

    public DataMigrationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListMigrationJobsPagedResponse listMigrationJobs(LocationName parent) {
        ListMigrationJobsRequest request = ListMigrationJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMigrationJobs(request);
    }

    public final ListMigrationJobsPagedResponse listMigrationJobs(String parent) {
        ListMigrationJobsRequest request = ListMigrationJobsRequest.newBuilder().setParent(parent).build();
        return this.listMigrationJobs(request);
    }

    public final ListMigrationJobsPagedResponse listMigrationJobs(ListMigrationJobsRequest request) {
        return (ListMigrationJobsPagedResponse)((Object)this.listMigrationJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMigrationJobsRequest, ListMigrationJobsPagedResponse> listMigrationJobsPagedCallable() {
        return this.stub.listMigrationJobsPagedCallable();
    }

    public final UnaryCallable<ListMigrationJobsRequest, ListMigrationJobsResponse> listMigrationJobsCallable() {
        return this.stub.listMigrationJobsCallable();
    }

    public final MigrationJob getMigrationJob(MigrationJobName name) {
        GetMigrationJobRequest request = GetMigrationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMigrationJob(request);
    }

    public final MigrationJob getMigrationJob(String name) {
        GetMigrationJobRequest request = GetMigrationJobRequest.newBuilder().setName(name).build();
        return this.getMigrationJob(request);
    }

    public final MigrationJob getMigrationJob(GetMigrationJobRequest request) {
        return (MigrationJob)this.getMigrationJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetMigrationJobRequest, MigrationJob> getMigrationJobCallable() {
        return this.stub.getMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> createMigrationJobAsync(LocationName parent, MigrationJob migrationJob, String migrationJobId) {
        CreateMigrationJobRequest request = CreateMigrationJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMigrationJob(migrationJob).setMigrationJobId(migrationJobId).build();
        return this.createMigrationJobAsync(request);
    }

    public final OperationFuture<MigrationJob, OperationMetadata> createMigrationJobAsync(String parent, MigrationJob migrationJob, String migrationJobId) {
        CreateMigrationJobRequest request = CreateMigrationJobRequest.newBuilder().setParent(parent).setMigrationJob(migrationJob).setMigrationJobId(migrationJobId).build();
        return this.createMigrationJobAsync(request);
    }

    public final OperationFuture<MigrationJob, OperationMetadata> createMigrationJobAsync(CreateMigrationJobRequest request) {
        return this.createMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMigrationJobRequest, MigrationJob, OperationMetadata> createMigrationJobOperationCallable() {
        return this.stub.createMigrationJobOperationCallable();
    }

    public final UnaryCallable<CreateMigrationJobRequest, Operation> createMigrationJobCallable() {
        return this.stub.createMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> updateMigrationJobAsync(MigrationJob migrationJob, FieldMask updateMask) {
        UpdateMigrationJobRequest request = UpdateMigrationJobRequest.newBuilder().setMigrationJob(migrationJob).setUpdateMask(updateMask).build();
        return this.updateMigrationJobAsync(request);
    }

    public final OperationFuture<MigrationJob, OperationMetadata> updateMigrationJobAsync(UpdateMigrationJobRequest request) {
        return this.updateMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMigrationJobRequest, MigrationJob, OperationMetadata> updateMigrationJobOperationCallable() {
        return this.stub.updateMigrationJobOperationCallable();
    }

    public final UnaryCallable<UpdateMigrationJobRequest, Operation> updateMigrationJobCallable() {
        return this.stub.updateMigrationJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigrationJobAsync(MigrationJobName name) {
        DeleteMigrationJobRequest request = DeleteMigrationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMigrationJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigrationJobAsync(String name) {
        DeleteMigrationJobRequest request = DeleteMigrationJobRequest.newBuilder().setName(name).build();
        return this.deleteMigrationJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigrationJobAsync(DeleteMigrationJobRequest request) {
        return this.deleteMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMigrationJobRequest, Empty, OperationMetadata> deleteMigrationJobOperationCallable() {
        return this.stub.deleteMigrationJobOperationCallable();
    }

    public final UnaryCallable<DeleteMigrationJobRequest, Operation> deleteMigrationJobCallable() {
        return this.stub.deleteMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> startMigrationJobAsync(StartMigrationJobRequest request) {
        return this.startMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartMigrationJobRequest, MigrationJob, OperationMetadata> startMigrationJobOperationCallable() {
        return this.stub.startMigrationJobOperationCallable();
    }

    public final UnaryCallable<StartMigrationJobRequest, Operation> startMigrationJobCallable() {
        return this.stub.startMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> stopMigrationJobAsync(StopMigrationJobRequest request) {
        return this.stopMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopMigrationJobRequest, MigrationJob, OperationMetadata> stopMigrationJobOperationCallable() {
        return this.stub.stopMigrationJobOperationCallable();
    }

    public final UnaryCallable<StopMigrationJobRequest, Operation> stopMigrationJobCallable() {
        return this.stub.stopMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> resumeMigrationJobAsync(ResumeMigrationJobRequest request) {
        return this.resumeMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeMigrationJobRequest, MigrationJob, OperationMetadata> resumeMigrationJobOperationCallable() {
        return this.stub.resumeMigrationJobOperationCallable();
    }

    public final UnaryCallable<ResumeMigrationJobRequest, Operation> resumeMigrationJobCallable() {
        return this.stub.resumeMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> promoteMigrationJobAsync(PromoteMigrationJobRequest request) {
        return this.promoteMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PromoteMigrationJobRequest, MigrationJob, OperationMetadata> promoteMigrationJobOperationCallable() {
        return this.stub.promoteMigrationJobOperationCallable();
    }

    public final UnaryCallable<PromoteMigrationJobRequest, Operation> promoteMigrationJobCallable() {
        return this.stub.promoteMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> verifyMigrationJobAsync(VerifyMigrationJobRequest request) {
        return this.verifyMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<VerifyMigrationJobRequest, MigrationJob, OperationMetadata> verifyMigrationJobOperationCallable() {
        return this.stub.verifyMigrationJobOperationCallable();
    }

    public final UnaryCallable<VerifyMigrationJobRequest, Operation> verifyMigrationJobCallable() {
        return this.stub.verifyMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> restartMigrationJobAsync(RestartMigrationJobRequest request) {
        return this.restartMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestartMigrationJobRequest, MigrationJob, OperationMetadata> restartMigrationJobOperationCallable() {
        return this.stub.restartMigrationJobOperationCallable();
    }

    public final UnaryCallable<RestartMigrationJobRequest, Operation> restartMigrationJobCallable() {
        return this.stub.restartMigrationJobCallable();
    }

    public final SshScript generateSshScript(GenerateSshScriptRequest request) {
        return (SshScript)this.generateSshScriptCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateSshScriptRequest, SshScript> generateSshScriptCallable() {
        return this.stub.generateSshScriptCallable();
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(LocationName parent) {
        ListConnectionProfilesRequest request = ListConnectionProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnectionProfiles(request);
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(String parent) {
        ListConnectionProfilesRequest request = ListConnectionProfilesRequest.newBuilder().setParent(parent).build();
        return this.listConnectionProfiles(request);
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(ListConnectionProfilesRequest request) {
        return (ListConnectionProfilesPagedResponse)((Object)this.listConnectionProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable() {
        return this.stub.listConnectionProfilesPagedCallable();
    }

    public final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable() {
        return this.stub.listConnectionProfilesCallable();
    }

    public final ConnectionProfile getConnectionProfile(ConnectionProfileName name) {
        GetConnectionProfileRequest request = GetConnectionProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnectionProfile(request);
    }

    public final ConnectionProfile getConnectionProfile(String name) {
        GetConnectionProfileRequest request = GetConnectionProfileRequest.newBuilder().setName(name).build();
        return this.getConnectionProfile(request);
    }

    public final ConnectionProfile getConnectionProfile(GetConnectionProfileRequest request) {
        return (ConnectionProfile)this.getConnectionProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable() {
        return this.stub.getConnectionProfileCallable();
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(ConnectionProfileName parent, ConnectionProfile connectionProfile, String connectionProfileId) {
        CreateConnectionProfileRequest request = CreateConnectionProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnectionProfile(connectionProfile).setConnectionProfileId(connectionProfileId).build();
        return this.createConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(String parent, ConnectionProfile connectionProfile, String connectionProfileId) {
        CreateConnectionProfileRequest request = CreateConnectionProfileRequest.newBuilder().setParent(parent).setConnectionProfile(connectionProfile).setConnectionProfileId(connectionProfileId).build();
        return this.createConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(CreateConnectionProfileRequest request) {
        return this.createConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable() {
        return this.stub.createConnectionProfileOperationCallable();
    }

    public final UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable() {
        return this.stub.createConnectionProfileCallable();
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> updateConnectionProfileAsync(ConnectionProfile connectionProfile, FieldMask updateMask) {
        UpdateConnectionProfileRequest request = UpdateConnectionProfileRequest.newBuilder().setConnectionProfile(connectionProfile).setUpdateMask(updateMask).build();
        return this.updateConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> updateConnectionProfileAsync(UpdateConnectionProfileRequest request) {
        return this.updateConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable() {
        return this.stub.updateConnectionProfileOperationCallable();
    }

    public final UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable() {
        return this.stub.updateConnectionProfileCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(ConnectionProfileName name) {
        DeleteConnectionProfileRequest request = DeleteConnectionProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectionProfileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(String name) {
        DeleteConnectionProfileRequest request = DeleteConnectionProfileRequest.newBuilder().setName(name).build();
        return this.deleteConnectionProfileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(DeleteConnectionProfileRequest request) {
        return this.deleteConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable() {
        return this.stub.deleteConnectionProfileOperationCallable();
    }

    public final UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable() {
        return this.stub.deleteConnectionProfileCallable();
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(LocationName parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(String parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(CreatePrivateConnectionRequest request) {
        return this.createPrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable() {
        return this.stub.createPrivateConnectionOperationCallable();
    }

    public final UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable() {
        return this.stub.createPrivateConnectionCallable();
    }

    public final PrivateConnection getPrivateConnection(PrivateConnectionName name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(String name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(GetPrivateConnectionRequest request) {
        return (PrivateConnection)this.getPrivateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable() {
        return this.stub.getPrivateConnectionCallable();
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(LocationName parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(String parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(ListPrivateConnectionsRequest request) {
        return (ListPrivateConnectionsPagedResponse)((Object)this.listPrivateConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable() {
        return this.stub.listPrivateConnectionsPagedCallable();
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable() {
        return this.stub.listPrivateConnectionsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(PrivateConnectionName name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(String name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(DeletePrivateConnectionRequest request) {
        return this.deletePrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable() {
        return this.stub.deletePrivateConnectionOperationCallable();
    }

    public final UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable() {
        return this.stub.deletePrivateConnectionCallable();
    }

    public final ConversionWorkspace getConversionWorkspace(ConversionWorkspaceName name) {
        GetConversionWorkspaceRequest request = GetConversionWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversionWorkspace(request);
    }

    public final ConversionWorkspace getConversionWorkspace(String name) {
        GetConversionWorkspaceRequest request = GetConversionWorkspaceRequest.newBuilder().setName(name).build();
        return this.getConversionWorkspace(request);
    }

    public final ConversionWorkspace getConversionWorkspace(GetConversionWorkspaceRequest request) {
        return (ConversionWorkspace)this.getConversionWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversionWorkspaceRequest, ConversionWorkspace> getConversionWorkspaceCallable() {
        return this.stub.getConversionWorkspaceCallable();
    }

    public final ListConversionWorkspacesPagedResponse listConversionWorkspaces(LocationName parent) {
        ListConversionWorkspacesRequest request = ListConversionWorkspacesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversionWorkspaces(request);
    }

    public final ListConversionWorkspacesPagedResponse listConversionWorkspaces(String parent) {
        ListConversionWorkspacesRequest request = ListConversionWorkspacesRequest.newBuilder().setParent(parent).build();
        return this.listConversionWorkspaces(request);
    }

    public final ListConversionWorkspacesPagedResponse listConversionWorkspaces(ListConversionWorkspacesRequest request) {
        return (ListConversionWorkspacesPagedResponse)((Object)this.listConversionWorkspacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversionWorkspacesRequest, ListConversionWorkspacesPagedResponse> listConversionWorkspacesPagedCallable() {
        return this.stub.listConversionWorkspacesPagedCallable();
    }

    public final UnaryCallable<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse> listConversionWorkspacesCallable() {
        return this.stub.listConversionWorkspacesCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> createConversionWorkspaceAsync(LocationName parent, ConversionWorkspace conversionWorkspace, String conversionWorkspaceId) {
        CreateConversionWorkspaceRequest request = CreateConversionWorkspaceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversionWorkspace(conversionWorkspace).setConversionWorkspaceId(conversionWorkspaceId).build();
        return this.createConversionWorkspaceAsync(request);
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> createConversionWorkspaceAsync(String parent, ConversionWorkspace conversionWorkspace, String conversionWorkspaceId) {
        CreateConversionWorkspaceRequest request = CreateConversionWorkspaceRequest.newBuilder().setParent(parent).setConversionWorkspace(conversionWorkspace).setConversionWorkspaceId(conversionWorkspaceId).build();
        return this.createConversionWorkspaceAsync(request);
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> createConversionWorkspaceAsync(CreateConversionWorkspaceRequest request) {
        return this.createConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> createConversionWorkspaceOperationCallable() {
        return this.stub.createConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<CreateConversionWorkspaceRequest, Operation> createConversionWorkspaceCallable() {
        return this.stub.createConversionWorkspaceCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> updateConversionWorkspaceAsync(ConversionWorkspace conversionWorkspace, FieldMask updateMask) {
        UpdateConversionWorkspaceRequest request = UpdateConversionWorkspaceRequest.newBuilder().setConversionWorkspace(conversionWorkspace).setUpdateMask(updateMask).build();
        return this.updateConversionWorkspaceAsync(request);
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> updateConversionWorkspaceAsync(UpdateConversionWorkspaceRequest request) {
        return this.updateConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> updateConversionWorkspaceOperationCallable() {
        return this.stub.updateConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<UpdateConversionWorkspaceRequest, Operation> updateConversionWorkspaceCallable() {
        return this.stub.updateConversionWorkspaceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConversionWorkspaceAsync(ConversionWorkspaceName name) {
        DeleteConversionWorkspaceRequest request = DeleteConversionWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConversionWorkspaceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConversionWorkspaceAsync(String name) {
        DeleteConversionWorkspaceRequest request = DeleteConversionWorkspaceRequest.newBuilder().setName(name).build();
        return this.deleteConversionWorkspaceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConversionWorkspaceAsync(DeleteConversionWorkspaceRequest request) {
        return this.deleteConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConversionWorkspaceRequest, Empty, OperationMetadata> deleteConversionWorkspaceOperationCallable() {
        return this.stub.deleteConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<DeleteConversionWorkspaceRequest, Operation> deleteConversionWorkspaceCallable() {
        return this.stub.deleteConversionWorkspaceCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> seedConversionWorkspaceAsync(SeedConversionWorkspaceRequest request) {
        return this.seedConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SeedConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> seedConversionWorkspaceOperationCallable() {
        return this.stub.seedConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<SeedConversionWorkspaceRequest, Operation> seedConversionWorkspaceCallable() {
        return this.stub.seedConversionWorkspaceCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> importMappingRulesAsync(ImportMappingRulesRequest request) {
        return this.importMappingRulesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportMappingRulesRequest, ConversionWorkspace, OperationMetadata> importMappingRulesOperationCallable() {
        return this.stub.importMappingRulesOperationCallable();
    }

    public final UnaryCallable<ImportMappingRulesRequest, Operation> importMappingRulesCallable() {
        return this.stub.importMappingRulesCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> convertConversionWorkspaceAsync(ConvertConversionWorkspaceRequest request) {
        return this.convertConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ConvertConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> convertConversionWorkspaceOperationCallable() {
        return this.stub.convertConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<ConvertConversionWorkspaceRequest, Operation> convertConversionWorkspaceCallable() {
        return this.stub.convertConversionWorkspaceCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> commitConversionWorkspaceAsync(CommitConversionWorkspaceRequest request) {
        return this.commitConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CommitConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> commitConversionWorkspaceOperationCallable() {
        return this.stub.commitConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<CommitConversionWorkspaceRequest, Operation> commitConversionWorkspaceCallable() {
        return this.stub.commitConversionWorkspaceCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> rollbackConversionWorkspaceAsync(RollbackConversionWorkspaceRequest request) {
        return this.rollbackConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RollbackConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> rollbackConversionWorkspaceOperationCallable() {
        return this.stub.rollbackConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<RollbackConversionWorkspaceRequest, Operation> rollbackConversionWorkspaceCallable() {
        return this.stub.rollbackConversionWorkspaceCallable();
    }

    public final OperationFuture<ConversionWorkspace, OperationMetadata> applyConversionWorkspaceAsync(ApplyConversionWorkspaceRequest request) {
        return this.applyConversionWorkspaceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ApplyConversionWorkspaceRequest, ConversionWorkspace, OperationMetadata> applyConversionWorkspaceOperationCallable() {
        return this.stub.applyConversionWorkspaceOperationCallable();
    }

    public final UnaryCallable<ApplyConversionWorkspaceRequest, Operation> applyConversionWorkspaceCallable() {
        return this.stub.applyConversionWorkspaceCallable();
    }

    public final DescribeDatabaseEntitiesPagedResponse describeDatabaseEntities(DescribeDatabaseEntitiesRequest request) {
        return (DescribeDatabaseEntitiesPagedResponse)((Object)this.describeDatabaseEntitiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesPagedResponse> describeDatabaseEntitiesPagedCallable() {
        return this.stub.describeDatabaseEntitiesPagedCallable();
    }

    public final UnaryCallable<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse> describeDatabaseEntitiesCallable() {
        return this.stub.describeDatabaseEntitiesCallable();
    }

    public final SearchBackgroundJobsResponse searchBackgroundJobs(SearchBackgroundJobsRequest request) {
        return (SearchBackgroundJobsResponse)this.searchBackgroundJobsCallable().call((Object)request);
    }

    public final UnaryCallable<SearchBackgroundJobsRequest, SearchBackgroundJobsResponse> searchBackgroundJobsCallable() {
        return this.stub.searchBackgroundJobsCallable();
    }

    public final DescribeConversionWorkspaceRevisionsResponse describeConversionWorkspaceRevisions(DescribeConversionWorkspaceRevisionsRequest request) {
        return (DescribeConversionWorkspaceRevisionsResponse)this.describeConversionWorkspaceRevisionsCallable().call((Object)request);
    }

    public final UnaryCallable<DescribeConversionWorkspaceRevisionsRequest, DescribeConversionWorkspaceRevisionsResponse> describeConversionWorkspaceRevisionsCallable() {
        return this.stub.describeConversionWorkspaceRevisionsCallable();
    }

    public final FetchStaticIpsPagedResponse fetchStaticIps(LocationName name) {
        FetchStaticIpsRequest request = FetchStaticIpsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.fetchStaticIps(request);
    }

    public final FetchStaticIpsPagedResponse fetchStaticIps(String name) {
        FetchStaticIpsRequest request = FetchStaticIpsRequest.newBuilder().setName(name).build();
        return this.fetchStaticIps(request);
    }

    public final FetchStaticIpsPagedResponse fetchStaticIps(FetchStaticIpsRequest request) {
        return (FetchStaticIpsPagedResponse)((Object)this.fetchStaticIpsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsPagedResponse> fetchStaticIpsPagedCallable() {
        return this.stub.fetchStaticIpsPagedCallable();
    }

    public final UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsCallable() {
        return this.stub.fetchStaticIpsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class FetchStaticIpsFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchStaticIpsRequest, FetchStaticIpsResponse, String, FetchStaticIpsPage, FetchStaticIpsFixedSizeCollection> {
        private FetchStaticIpsFixedSizeCollection(List<FetchStaticIpsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchStaticIpsFixedSizeCollection createEmptyCollection() {
            return new FetchStaticIpsFixedSizeCollection(null, 0);
        }

        protected FetchStaticIpsFixedSizeCollection createCollection(List<FetchStaticIpsPage> pages, int collectionSize) {
            return new FetchStaticIpsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchStaticIpsPage
    extends AbstractPage<FetchStaticIpsRequest, FetchStaticIpsResponse, String, FetchStaticIpsPage> {
        private FetchStaticIpsPage(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, FetchStaticIpsResponse response) {
            super(context, (Object)response);
        }

        private static FetchStaticIpsPage createEmptyPage() {
            return new FetchStaticIpsPage(null, null);
        }

        protected FetchStaticIpsPage createPage(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, FetchStaticIpsResponse response) {
            return new FetchStaticIpsPage(context, response);
        }

        public ApiFuture<FetchStaticIpsPage> createPageAsync(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, ApiFuture<FetchStaticIpsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchStaticIpsPagedResponse
    extends AbstractPagedListResponse<FetchStaticIpsRequest, FetchStaticIpsResponse, String, FetchStaticIpsPage, FetchStaticIpsFixedSizeCollection> {
        public static ApiFuture<FetchStaticIpsPagedResponse> createAsync(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, ApiFuture<FetchStaticIpsResponse> futureResponse) {
            ApiFuture<FetchStaticIpsPage> futurePage = FetchStaticIpsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchStaticIpsPagedResponse((FetchStaticIpsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchStaticIpsPagedResponse(FetchStaticIpsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchStaticIpsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class DescribeDatabaseEntitiesFixedSizeCollection
    extends AbstractFixedSizeCollection<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity, DescribeDatabaseEntitiesPage, DescribeDatabaseEntitiesFixedSizeCollection> {
        private DescribeDatabaseEntitiesFixedSizeCollection(List<DescribeDatabaseEntitiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static DescribeDatabaseEntitiesFixedSizeCollection createEmptyCollection() {
            return new DescribeDatabaseEntitiesFixedSizeCollection(null, 0);
        }

        protected DescribeDatabaseEntitiesFixedSizeCollection createCollection(List<DescribeDatabaseEntitiesPage> pages, int collectionSize) {
            return new DescribeDatabaseEntitiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class DescribeDatabaseEntitiesPage
    extends AbstractPage<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity, DescribeDatabaseEntitiesPage> {
        private DescribeDatabaseEntitiesPage(PageContext<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity> context, DescribeDatabaseEntitiesResponse response) {
            super(context, (Object)response);
        }

        private static DescribeDatabaseEntitiesPage createEmptyPage() {
            return new DescribeDatabaseEntitiesPage(null, null);
        }

        protected DescribeDatabaseEntitiesPage createPage(PageContext<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity> context, DescribeDatabaseEntitiesResponse response) {
            return new DescribeDatabaseEntitiesPage(context, response);
        }

        public ApiFuture<DescribeDatabaseEntitiesPage> createPageAsync(PageContext<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity> context, ApiFuture<DescribeDatabaseEntitiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class DescribeDatabaseEntitiesPagedResponse
    extends AbstractPagedListResponse<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity, DescribeDatabaseEntitiesPage, DescribeDatabaseEntitiesFixedSizeCollection> {
        public static ApiFuture<DescribeDatabaseEntitiesPagedResponse> createAsync(PageContext<DescribeDatabaseEntitiesRequest, DescribeDatabaseEntitiesResponse, DatabaseEntity> context, ApiFuture<DescribeDatabaseEntitiesResponse> futureResponse) {
            ApiFuture<DescribeDatabaseEntitiesPage> futurePage = DescribeDatabaseEntitiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new DescribeDatabaseEntitiesPagedResponse((DescribeDatabaseEntitiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private DescribeDatabaseEntitiesPagedResponse(DescribeDatabaseEntitiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)DescribeDatabaseEntitiesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversionWorkspacesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace, ListConversionWorkspacesPage, ListConversionWorkspacesFixedSizeCollection> {
        private ListConversionWorkspacesFixedSizeCollection(List<ListConversionWorkspacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversionWorkspacesFixedSizeCollection createEmptyCollection() {
            return new ListConversionWorkspacesFixedSizeCollection(null, 0);
        }

        protected ListConversionWorkspacesFixedSizeCollection createCollection(List<ListConversionWorkspacesPage> pages, int collectionSize) {
            return new ListConversionWorkspacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversionWorkspacesPage
    extends AbstractPage<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace, ListConversionWorkspacesPage> {
        private ListConversionWorkspacesPage(PageContext<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace> context, ListConversionWorkspacesResponse response) {
            super(context, (Object)response);
        }

        private static ListConversionWorkspacesPage createEmptyPage() {
            return new ListConversionWorkspacesPage(null, null);
        }

        protected ListConversionWorkspacesPage createPage(PageContext<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace> context, ListConversionWorkspacesResponse response) {
            return new ListConversionWorkspacesPage(context, response);
        }

        public ApiFuture<ListConversionWorkspacesPage> createPageAsync(PageContext<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace> context, ApiFuture<ListConversionWorkspacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversionWorkspacesPagedResponse
    extends AbstractPagedListResponse<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace, ListConversionWorkspacesPage, ListConversionWorkspacesFixedSizeCollection> {
        public static ApiFuture<ListConversionWorkspacesPagedResponse> createAsync(PageContext<ListConversionWorkspacesRequest, ListConversionWorkspacesResponse, ConversionWorkspace> context, ApiFuture<ListConversionWorkspacesResponse> futureResponse) {
            ApiFuture<ListConversionWorkspacesPage> futurePage = ListConversionWorkspacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversionWorkspacesPagedResponse((ListConversionWorkspacesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversionWorkspacesPagedResponse(ListConversionWorkspacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversionWorkspacesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        private ListPrivateConnectionsFixedSizeCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateConnectionsFixedSizeCollection(null, 0);
        }

        protected ListPrivateConnectionsFixedSizeCollection createCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            return new ListPrivateConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateConnectionsPage
    extends AbstractPage<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage> {
        private ListPrivateConnectionsPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateConnectionsPage createEmptyPage() {
            return new ListPrivateConnectionsPage(null, null);
        }

        protected ListPrivateConnectionsPage createPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            return new ListPrivateConnectionsPage(context, response);
        }

        public ApiFuture<ListPrivateConnectionsPage> createPageAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateConnectionsPagedResponse
    extends AbstractPagedListResponse<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        public static ApiFuture<ListPrivateConnectionsPagedResponse> createAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            ApiFuture<ListPrivateConnectionsPage> futurePage = ListPrivateConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateConnectionsPagedResponse((ListPrivateConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateConnectionsPagedResponse(ListPrivateConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectionProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage, ListConnectionProfilesFixedSizeCollection> {
        private ListConnectionProfilesFixedSizeCollection(List<ListConnectionProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionProfilesFixedSizeCollection createEmptyCollection() {
            return new ListConnectionProfilesFixedSizeCollection(null, 0);
        }

        protected ListConnectionProfilesFixedSizeCollection createCollection(List<ListConnectionProfilesPage> pages, int collectionSize) {
            return new ListConnectionProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionProfilesPage
    extends AbstractPage<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage> {
        private ListConnectionProfilesPage(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ListConnectionProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionProfilesPage createEmptyPage() {
            return new ListConnectionProfilesPage(null, null);
        }

        protected ListConnectionProfilesPage createPage(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ListConnectionProfilesResponse response) {
            return new ListConnectionProfilesPage(context, response);
        }

        public ApiFuture<ListConnectionProfilesPage> createPageAsync(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionProfilesPagedResponse
    extends AbstractPagedListResponse<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage, ListConnectionProfilesFixedSizeCollection> {
        public static ApiFuture<ListConnectionProfilesPagedResponse> createAsync(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            ApiFuture<ListConnectionProfilesPage> futurePage = ListConnectionProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectionProfilesPagedResponse((ListConnectionProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionProfilesPagedResponse(ListConnectionProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMigrationJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob, ListMigrationJobsPage, ListMigrationJobsFixedSizeCollection> {
        private ListMigrationJobsFixedSizeCollection(List<ListMigrationJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMigrationJobsFixedSizeCollection createEmptyCollection() {
            return new ListMigrationJobsFixedSizeCollection(null, 0);
        }

        protected ListMigrationJobsFixedSizeCollection createCollection(List<ListMigrationJobsPage> pages, int collectionSize) {
            return new ListMigrationJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMigrationJobsPage
    extends AbstractPage<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob, ListMigrationJobsPage> {
        private ListMigrationJobsPage(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ListMigrationJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListMigrationJobsPage createEmptyPage() {
            return new ListMigrationJobsPage(null, null);
        }

        protected ListMigrationJobsPage createPage(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ListMigrationJobsResponse response) {
            return new ListMigrationJobsPage(context, response);
        }

        public ApiFuture<ListMigrationJobsPage> createPageAsync(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ApiFuture<ListMigrationJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMigrationJobsPagedResponse
    extends AbstractPagedListResponse<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob, ListMigrationJobsPage, ListMigrationJobsFixedSizeCollection> {
        public static ApiFuture<ListMigrationJobsPagedResponse> createAsync(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ApiFuture<ListMigrationJobsResponse> futureResponse) {
            ApiFuture<ListMigrationJobsPage> futurePage = ListMigrationJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMigrationJobsPagedResponse((ListMigrationJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMigrationJobsPagedResponse(ListMigrationJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMigrationJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

