/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.OperationCallSettings;
import com.google.api.gax.grpc.OperationTimedPollAlgorithm;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.longrunning.Operation;
import com.google.privacy.dlp.v2beta1.CreateInspectOperationRequest;
import com.google.privacy.dlp.v2beta1.InspectContentRequest;
import com.google.privacy.dlp.v2beta1.InspectContentResponse;
import com.google.privacy.dlp.v2beta1.InspectOperationMetadata;
import com.google.privacy.dlp.v2beta1.InspectOperationResult;
import com.google.privacy.dlp.v2beta1.ListInfoTypesRequest;
import com.google.privacy.dlp.v2beta1.ListInfoTypesResponse;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsRequest;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsResponse;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesRequest;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesResponse;
import com.google.privacy.dlp.v2beta1.RedactContentRequest;
import com.google.privacy.dlp.v2beta1.RedactContentResponse;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DlpServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/dlp/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<InspectContentRequest, InspectContentResponse> METHOD_INSPECT_CONTENT;
    private static final MethodDescriptor<RedactContentRequest, RedactContentResponse> METHOD_REDACT_CONTENT;
    private static final MethodDescriptor<CreateInspectOperationRequest, Operation> METHOD_CREATE_INSPECT_OPERATION;
    private static final MethodDescriptor<ListInspectFindingsRequest, ListInspectFindingsResponse> METHOD_LIST_INSPECT_FINDINGS;
    private static final MethodDescriptor<ListInfoTypesRequest, ListInfoTypesResponse> METHOD_LIST_INFO_TYPES;
    private static final MethodDescriptor<ListRootCategoriesRequest, ListRootCategoriesResponse> METHOD_LIST_ROOT_CATEGORIES;
    private final SimpleCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings;
    private final SimpleCallSettings<RedactContentRequest, RedactContentResponse> redactContentSettings;
    private final OperationCallSettings<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationSettings;
    private final SimpleCallSettings<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings;
    private final SimpleCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
    private final SimpleCallSettings<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings;

    public SimpleCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
        return this.inspectContentSettings;
    }

    public SimpleCallSettings<RedactContentRequest, RedactContentResponse> redactContentSettings() {
        return this.redactContentSettings;
    }

    public OperationCallSettings<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationSettings() {
        return this.createInspectOperationSettings;
    }

    public SimpleCallSettings<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings() {
        return this.listInspectFindingsSettings;
    }

    public SimpleCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
        return this.listInfoTypesSettings;
    }

    public SimpleCallSettings<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings() {
        return this.listRootCategoriesSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dlp.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(DlpServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, DlpServiceSettings.getGapicVersion());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(DlpServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DlpServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider(), settingsBuilder.getCredentialsProvider());
        this.inspectContentSettings = settingsBuilder.inspectContentSettings().build();
        this.redactContentSettings = settingsBuilder.redactContentSettings().build();
        this.createInspectOperationSettings = settingsBuilder.createInspectOperationSettings().build();
        this.listInspectFindingsSettings = settingsBuilder.listInspectFindingsSettings().build();
        this.listInfoTypesSettings = settingsBuilder.listInfoTypesSettings().build();
        this.listRootCategoriesSettings = settingsBuilder.listRootCategoriesSettings().build();
    }

    static {
        METHOD_INSPECT_CONTENT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.privacy.dlp.v2beta1.DlpService/InspectContent", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)InspectContentRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)InspectContentResponse.getDefaultInstance()));
        METHOD_REDACT_CONTENT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.privacy.dlp.v2beta1.DlpService/RedactContent", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RedactContentRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RedactContentResponse.getDefaultInstance()));
        METHOD_CREATE_INSPECT_OPERATION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.privacy.dlp.v2beta1.DlpService/CreateInspectOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CreateInspectOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Operation.getDefaultInstance()));
        METHOD_LIST_INSPECT_FINDINGS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.privacy.dlp.v2beta1.DlpService/ListInspectFindings", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListInspectFindingsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListInspectFindingsResponse.getDefaultInstance()));
        METHOD_LIST_INFO_TYPES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.privacy.dlp.v2beta1.DlpService/ListInfoTypes", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListInfoTypesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListInfoTypesResponse.getDefaultInstance()));
        METHOD_LIST_ROOT_CATEGORIES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.privacy.dlp.v2beta1.DlpService/ListRootCategories", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListRootCategoriesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListRootCategoriesResponse.getDefaultInstance()));
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings;
        private final SimpleCallSettings.Builder<RedactContentRequest, RedactContentResponse> redactContentSettings;
        private final OperationCallSettings.Builder<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationSettings;
        private final SimpleCallSettings.Builder<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings;
        private final SimpleCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
        private final SimpleCallSettings.Builder<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DlpServiceSettings.defaultChannelProviderBuilder().build());
            this.setCredentialsProvider((CredentialsProvider)DlpServiceSettings.defaultCredentialsProviderBuilder().build());
            this.inspectContentSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_INSPECT_CONTENT);
            this.redactContentSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_REDACT_CONTENT);
            this.createInspectOperationSettings = OperationCallSettings.newBuilder();
            this.listInspectFindingsSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_INSPECT_FINDINGS);
            this.listInfoTypesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_INFO_TYPES);
            this.listRootCategoriesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_ROOT_CATEGORIES);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactContentSettings, this.listInspectFindingsSettings, this.listInfoTypesSettings, this.listRootCategoriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.inspectContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.redactContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInspectFindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInfoTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRootCategoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createInspectOperationSettings().setInitialCallSettings(SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_CREATE_INSPECT_OPERATION).setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseClass(InspectOperationResult.class).setMetadataClass(InspectOperationMetadata.class).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        private Builder(DlpServiceSettings settings) {
            super((ClientSettings)settings);
            this.inspectContentSettings = settings.inspectContentSettings.toBuilder();
            this.redactContentSettings = settings.redactContentSettings.toBuilder();
            this.createInspectOperationSettings = settings.createInspectOperationSettings.toBuilder();
            this.listInspectFindingsSettings = settings.listInspectFindingsSettings.toBuilder();
            this.listInfoTypesSettings = settings.listInfoTypesSettings.toBuilder();
            this.listRootCategoriesSettings = settings.listRootCategoriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactContentSettings, this.listInspectFindingsSettings, this.listInfoTypesSettings, this.listRootCategoriesSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
            return this.inspectContentSettings;
        }

        public SimpleCallSettings.Builder<RedactContentRequest, RedactContentResponse> redactContentSettings() {
            return this.redactContentSettings;
        }

        public OperationCallSettings.Builder<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationSettings() {
            return this.createInspectOperationSettings;
        }

        public SimpleCallSettings.Builder<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings() {
            return this.listInspectFindingsSettings;
        }

        public SimpleCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
            return this.listInfoTypesSettings;
        }

        public SimpleCallSettings.Builder<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings() {
            return this.listRootCategoriesSettings;
        }

        public DlpServiceSettings build() throws IOException {
            return new DlpServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

