/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.BatchCreateTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesRequest;
import com.google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesResponse;
import com.google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesMetadata;
import com.google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesRequest;
import com.google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesResponse;
import com.google.cloud.discoveryengine.v1alpha.CreateTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateTargetSiteRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteTargetSiteRequest;
import com.google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchMetadata;
import com.google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchRequest;
import com.google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchResponse;
import com.google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchMetadata;
import com.google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchRequest;
import com.google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchResponse;
import com.google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusRequest;
import com.google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusResponse;
import com.google.cloud.discoveryengine.v1alpha.GetSiteSearchEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.GetTargetSiteRequest;
import com.google.cloud.discoveryengine.v1alpha.GetUriPatternDocumentDataRequest;
import com.google.cloud.discoveryengine.v1alpha.GetUriPatternDocumentDataResponse;
import com.google.cloud.discoveryengine.v1alpha.ListTargetSitesRequest;
import com.google.cloud.discoveryengine.v1alpha.ListTargetSitesResponse;
import com.google.cloud.discoveryengine.v1alpha.RecrawlUrisMetadata;
import com.google.cloud.discoveryengine.v1alpha.RecrawlUrisRequest;
import com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse;
import com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataMetadata;
import com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest;
import com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataResponse;
import com.google.cloud.discoveryengine.v1alpha.SiteSearchEngine;
import com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineName;
import com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.TargetSite;
import com.google.cloud.discoveryengine.v1alpha.TargetSiteName;
import com.google.cloud.discoveryengine.v1alpha.UpdateTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1alpha.UpdateTargetSiteRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.SiteSearchEngineServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SiteSearchEngineServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SiteSearchEngineServiceClient
implements BackgroundResource {
    private final SiteSearchEngineServiceSettings settings;
    private final SiteSearchEngineServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SiteSearchEngineServiceClient create() throws IOException {
        return SiteSearchEngineServiceClient.create(SiteSearchEngineServiceSettings.newBuilder().build());
    }

    public static final SiteSearchEngineServiceClient create(SiteSearchEngineServiceSettings settings) throws IOException {
        return new SiteSearchEngineServiceClient(settings);
    }

    public static final SiteSearchEngineServiceClient create(SiteSearchEngineServiceStub stub) {
        return new SiteSearchEngineServiceClient(stub);
    }

    protected SiteSearchEngineServiceClient(SiteSearchEngineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SiteSearchEngineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SiteSearchEngineServiceClient(SiteSearchEngineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SiteSearchEngineServiceSettings getSettings() {
        return this.settings;
    }

    public SiteSearchEngineServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final SiteSearchEngine getSiteSearchEngine(SiteSearchEngineName name) {
        GetSiteSearchEngineRequest request = GetSiteSearchEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSiteSearchEngine(request);
    }

    public final SiteSearchEngine getSiteSearchEngine(String name) {
        GetSiteSearchEngineRequest request = GetSiteSearchEngineRequest.newBuilder().setName(name).build();
        return this.getSiteSearchEngine(request);
    }

    public final SiteSearchEngine getSiteSearchEngine(GetSiteSearchEngineRequest request) {
        return (SiteSearchEngine)this.getSiteSearchEngineCallable().call((Object)request);
    }

    public final UnaryCallable<GetSiteSearchEngineRequest, SiteSearchEngine> getSiteSearchEngineCallable() {
        return this.stub.getSiteSearchEngineCallable();
    }

    public final OperationFuture<TargetSite, CreateTargetSiteMetadata> createTargetSiteAsync(SiteSearchEngineName parent, TargetSite targetSite) {
        CreateTargetSiteRequest request = CreateTargetSiteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTargetSite(targetSite).build();
        return this.createTargetSiteAsync(request);
    }

    public final OperationFuture<TargetSite, CreateTargetSiteMetadata> createTargetSiteAsync(String parent, TargetSite targetSite) {
        CreateTargetSiteRequest request = CreateTargetSiteRequest.newBuilder().setParent(parent).setTargetSite(targetSite).build();
        return this.createTargetSiteAsync(request);
    }

    public final OperationFuture<TargetSite, CreateTargetSiteMetadata> createTargetSiteAsync(CreateTargetSiteRequest request) {
        return this.createTargetSiteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTargetSiteRequest, TargetSite, CreateTargetSiteMetadata> createTargetSiteOperationCallable() {
        return this.stub.createTargetSiteOperationCallable();
    }

    public final UnaryCallable<CreateTargetSiteRequest, Operation> createTargetSiteCallable() {
        return this.stub.createTargetSiteCallable();
    }

    public final OperationFuture<BatchCreateTargetSitesResponse, BatchCreateTargetSiteMetadata> batchCreateTargetSitesAsync(BatchCreateTargetSitesRequest request) {
        return this.batchCreateTargetSitesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreateTargetSitesRequest, BatchCreateTargetSitesResponse, BatchCreateTargetSiteMetadata> batchCreateTargetSitesOperationCallable() {
        return this.stub.batchCreateTargetSitesOperationCallable();
    }

    public final UnaryCallable<BatchCreateTargetSitesRequest, Operation> batchCreateTargetSitesCallable() {
        return this.stub.batchCreateTargetSitesCallable();
    }

    public final TargetSite getTargetSite(TargetSiteName name) {
        GetTargetSiteRequest request = GetTargetSiteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTargetSite(request);
    }

    public final TargetSite getTargetSite(String name) {
        GetTargetSiteRequest request = GetTargetSiteRequest.newBuilder().setName(name).build();
        return this.getTargetSite(request);
    }

    public final TargetSite getTargetSite(GetTargetSiteRequest request) {
        return (TargetSite)this.getTargetSiteCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetSiteRequest, TargetSite> getTargetSiteCallable() {
        return this.stub.getTargetSiteCallable();
    }

    public final OperationFuture<TargetSite, UpdateTargetSiteMetadata> updateTargetSiteAsync(TargetSite targetSite) {
        UpdateTargetSiteRequest request = UpdateTargetSiteRequest.newBuilder().setTargetSite(targetSite).build();
        return this.updateTargetSiteAsync(request);
    }

    public final OperationFuture<TargetSite, UpdateTargetSiteMetadata> updateTargetSiteAsync(UpdateTargetSiteRequest request) {
        return this.updateTargetSiteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTargetSiteRequest, TargetSite, UpdateTargetSiteMetadata> updateTargetSiteOperationCallable() {
        return this.stub.updateTargetSiteOperationCallable();
    }

    public final UnaryCallable<UpdateTargetSiteRequest, Operation> updateTargetSiteCallable() {
        return this.stub.updateTargetSiteCallable();
    }

    public final OperationFuture<Empty, DeleteTargetSiteMetadata> deleteTargetSiteAsync(TargetSiteName name) {
        DeleteTargetSiteRequest request = DeleteTargetSiteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTargetSiteAsync(request);
    }

    public final OperationFuture<Empty, DeleteTargetSiteMetadata> deleteTargetSiteAsync(String name) {
        DeleteTargetSiteRequest request = DeleteTargetSiteRequest.newBuilder().setName(name).build();
        return this.deleteTargetSiteAsync(request);
    }

    public final OperationFuture<Empty, DeleteTargetSiteMetadata> deleteTargetSiteAsync(DeleteTargetSiteRequest request) {
        return this.deleteTargetSiteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetSiteRequest, Empty, DeleteTargetSiteMetadata> deleteTargetSiteOperationCallable() {
        return this.stub.deleteTargetSiteOperationCallable();
    }

    public final UnaryCallable<DeleteTargetSiteRequest, Operation> deleteTargetSiteCallable() {
        return this.stub.deleteTargetSiteCallable();
    }

    public final ListTargetSitesPagedResponse listTargetSites(SiteSearchEngineName parent) {
        ListTargetSitesRequest request = ListTargetSitesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTargetSites(request);
    }

    public final ListTargetSitesPagedResponse listTargetSites(String parent) {
        ListTargetSitesRequest request = ListTargetSitesRequest.newBuilder().setParent(parent).build();
        return this.listTargetSites(request);
    }

    public final ListTargetSitesPagedResponse listTargetSites(ListTargetSitesRequest request) {
        return (ListTargetSitesPagedResponse)((Object)this.listTargetSitesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetSitesRequest, ListTargetSitesPagedResponse> listTargetSitesPagedCallable() {
        return this.stub.listTargetSitesPagedCallable();
    }

    public final UnaryCallable<ListTargetSitesRequest, ListTargetSitesResponse> listTargetSitesCallable() {
        return this.stub.listTargetSitesCallable();
    }

    public final OperationFuture<EnableAdvancedSiteSearchResponse, EnableAdvancedSiteSearchMetadata> enableAdvancedSiteSearchAsync(EnableAdvancedSiteSearchRequest request) {
        return this.enableAdvancedSiteSearchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableAdvancedSiteSearchRequest, EnableAdvancedSiteSearchResponse, EnableAdvancedSiteSearchMetadata> enableAdvancedSiteSearchOperationCallable() {
        return this.stub.enableAdvancedSiteSearchOperationCallable();
    }

    public final UnaryCallable<EnableAdvancedSiteSearchRequest, Operation> enableAdvancedSiteSearchCallable() {
        return this.stub.enableAdvancedSiteSearchCallable();
    }

    public final OperationFuture<DisableAdvancedSiteSearchResponse, DisableAdvancedSiteSearchMetadata> disableAdvancedSiteSearchAsync(DisableAdvancedSiteSearchRequest request) {
        return this.disableAdvancedSiteSearchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableAdvancedSiteSearchRequest, DisableAdvancedSiteSearchResponse, DisableAdvancedSiteSearchMetadata> disableAdvancedSiteSearchOperationCallable() {
        return this.stub.disableAdvancedSiteSearchOperationCallable();
    }

    public final UnaryCallable<DisableAdvancedSiteSearchRequest, Operation> disableAdvancedSiteSearchCallable() {
        return this.stub.disableAdvancedSiteSearchCallable();
    }

    public final OperationFuture<RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisAsync(RecrawlUrisRequest request) {
        return this.recrawlUrisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RecrawlUrisRequest, RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisOperationCallable() {
        return this.stub.recrawlUrisOperationCallable();
    }

    public final UnaryCallable<RecrawlUrisRequest, Operation> recrawlUrisCallable() {
        return this.stub.recrawlUrisCallable();
    }

    public final OperationFuture<BatchVerifyTargetSitesResponse, BatchVerifyTargetSitesMetadata> batchVerifyTargetSitesAsync(BatchVerifyTargetSitesRequest request) {
        return this.batchVerifyTargetSitesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchVerifyTargetSitesRequest, BatchVerifyTargetSitesResponse, BatchVerifyTargetSitesMetadata> batchVerifyTargetSitesOperationCallable() {
        return this.stub.batchVerifyTargetSitesOperationCallable();
    }

    public final UnaryCallable<BatchVerifyTargetSitesRequest, Operation> batchVerifyTargetSitesCallable() {
        return this.stub.batchVerifyTargetSitesCallable();
    }

    public final FetchDomainVerificationStatusPagedResponse fetchDomainVerificationStatus(FetchDomainVerificationStatusRequest request) {
        return (FetchDomainVerificationStatusPagedResponse)((Object)this.fetchDomainVerificationStatusPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusPagedResponse> fetchDomainVerificationStatusPagedCallable() {
        return this.stub.fetchDomainVerificationStatusPagedCallable();
    }

    public final UnaryCallable<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse> fetchDomainVerificationStatusCallable() {
        return this.stub.fetchDomainVerificationStatusCallable();
    }

    public final OperationFuture<SetUriPatternDocumentDataResponse, SetUriPatternDocumentDataMetadata> setUriPatternDocumentDataAsync(SetUriPatternDocumentDataRequest request) {
        return this.setUriPatternDocumentDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetUriPatternDocumentDataRequest, SetUriPatternDocumentDataResponse, SetUriPatternDocumentDataMetadata> setUriPatternDocumentDataOperationCallable() {
        return this.stub.setUriPatternDocumentDataOperationCallable();
    }

    public final UnaryCallable<SetUriPatternDocumentDataRequest, Operation> setUriPatternDocumentDataCallable() {
        return this.stub.setUriPatternDocumentDataCallable();
    }

    public final GetUriPatternDocumentDataResponse getUriPatternDocumentData(GetUriPatternDocumentDataRequest request) {
        return (GetUriPatternDocumentDataResponse)this.getUriPatternDocumentDataCallable().call((Object)request);
    }

    public final UnaryCallable<GetUriPatternDocumentDataRequest, GetUriPatternDocumentDataResponse> getUriPatternDocumentDataCallable() {
        return this.stub.getUriPatternDocumentDataCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class FetchDomainVerificationStatusFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite, FetchDomainVerificationStatusPage, FetchDomainVerificationStatusFixedSizeCollection> {
        private FetchDomainVerificationStatusFixedSizeCollection(List<FetchDomainVerificationStatusPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchDomainVerificationStatusFixedSizeCollection createEmptyCollection() {
            return new FetchDomainVerificationStatusFixedSizeCollection(null, 0);
        }

        protected FetchDomainVerificationStatusFixedSizeCollection createCollection(List<FetchDomainVerificationStatusPage> pages, int collectionSize) {
            return new FetchDomainVerificationStatusFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchDomainVerificationStatusPage
    extends AbstractPage<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite, FetchDomainVerificationStatusPage> {
        private FetchDomainVerificationStatusPage(PageContext<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite> context, FetchDomainVerificationStatusResponse response) {
            super(context, (Object)response);
        }

        private static FetchDomainVerificationStatusPage createEmptyPage() {
            return new FetchDomainVerificationStatusPage(null, null);
        }

        protected FetchDomainVerificationStatusPage createPage(PageContext<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite> context, FetchDomainVerificationStatusResponse response) {
            return new FetchDomainVerificationStatusPage(context, response);
        }

        public ApiFuture<FetchDomainVerificationStatusPage> createPageAsync(PageContext<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite> context, ApiFuture<FetchDomainVerificationStatusResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchDomainVerificationStatusPagedResponse
    extends AbstractPagedListResponse<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite, FetchDomainVerificationStatusPage, FetchDomainVerificationStatusFixedSizeCollection> {
        public static ApiFuture<FetchDomainVerificationStatusPagedResponse> createAsync(PageContext<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite> context, ApiFuture<FetchDomainVerificationStatusResponse> futureResponse) {
            ApiFuture<FetchDomainVerificationStatusPage> futurePage = FetchDomainVerificationStatusPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchDomainVerificationStatusPagedResponse((FetchDomainVerificationStatusPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchDomainVerificationStatusPagedResponse(FetchDomainVerificationStatusPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchDomainVerificationStatusFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTargetSitesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite, ListTargetSitesPage, ListTargetSitesFixedSizeCollection> {
        private ListTargetSitesFixedSizeCollection(List<ListTargetSitesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetSitesFixedSizeCollection createEmptyCollection() {
            return new ListTargetSitesFixedSizeCollection(null, 0);
        }

        protected ListTargetSitesFixedSizeCollection createCollection(List<ListTargetSitesPage> pages, int collectionSize) {
            return new ListTargetSitesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetSitesPage
    extends AbstractPage<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite, ListTargetSitesPage> {
        private ListTargetSitesPage(PageContext<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite> context, ListTargetSitesResponse response) {
            super(context, (Object)response);
        }

        private static ListTargetSitesPage createEmptyPage() {
            return new ListTargetSitesPage(null, null);
        }

        protected ListTargetSitesPage createPage(PageContext<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite> context, ListTargetSitesResponse response) {
            return new ListTargetSitesPage(context, response);
        }

        public ApiFuture<ListTargetSitesPage> createPageAsync(PageContext<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite> context, ApiFuture<ListTargetSitesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetSitesPagedResponse
    extends AbstractPagedListResponse<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite, ListTargetSitesPage, ListTargetSitesFixedSizeCollection> {
        public static ApiFuture<ListTargetSitesPagedResponse> createAsync(PageContext<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite> context, ApiFuture<ListTargetSitesResponse> futureResponse) {
            ApiFuture<ListTargetSitesPage> futurePage = ListTargetSitesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTargetSitesPagedResponse((ListTargetSitesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetSitesPagedResponse(ListTargetSitesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetSitesFixedSizeCollection.createEmptyCollection());
        }
    }
}

