/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.Control;
import com.google.cloud.discoveryengine.v1beta.ControlServiceClient;
import com.google.cloud.discoveryengine.v1beta.CreateControlRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteControlRequest;
import com.google.cloud.discoveryengine.v1beta.GetControlRequest;
import com.google.cloud.discoveryengine.v1beta.ListControlsRequest;
import com.google.cloud.discoveryengine.v1beta.ListControlsResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateControlRequest;
import com.google.cloud.discoveryengine.v1beta.stub.ControlServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.ControlServiceStubSettings;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcControlServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcControlServiceStub
extends ControlServiceStub {
    private static final MethodDescriptor<CreateControlRequest, Control> createControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/CreateControl").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Control.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteControlRequest, Empty> deleteControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/DeleteControl").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateControlRequest, Control> updateControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/UpdateControl").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Control.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetControlRequest, Control> getControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/GetControl").setRequestMarshaller(ProtoUtils.marshaller((Message)GetControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Control.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListControlsRequest, ListControlsResponse> listControlsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/ListControls").setRequestMarshaller(ProtoUtils.marshaller((Message)ListControlsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListControlsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateControlRequest, Control> createControlCallable;
    private final UnaryCallable<DeleteControlRequest, Empty> deleteControlCallable;
    private final UnaryCallable<UpdateControlRequest, Control> updateControlCallable;
    private final UnaryCallable<GetControlRequest, Control> getControlCallable;
    private final UnaryCallable<ListControlsRequest, ListControlsResponse> listControlsCallable;
    private final UnaryCallable<ListControlsRequest, ControlServiceClient.ListControlsPagedResponse> listControlsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcControlServiceStub create(ControlServiceStubSettings settings) throws IOException {
        return new GrpcControlServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcControlServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcControlServiceStub(ControlServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcControlServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcControlServiceStub(ControlServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcControlServiceStub(ControlServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcControlServiceCallableFactory());
    }

    protected GrpcControlServiceStub(ControlServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("control.name", String.valueOf(request.getControl().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listControlsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listControlsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createControlCallable = callableFactory.createUnaryCallable(createControlTransportSettings, settings.createControlSettings(), clientContext);
        this.deleteControlCallable = callableFactory.createUnaryCallable(deleteControlTransportSettings, settings.deleteControlSettings(), clientContext);
        this.updateControlCallable = callableFactory.createUnaryCallable(updateControlTransportSettings, settings.updateControlSettings(), clientContext);
        this.getControlCallable = callableFactory.createUnaryCallable(getControlTransportSettings, settings.getControlSettings(), clientContext);
        this.listControlsCallable = callableFactory.createUnaryCallable(listControlsTransportSettings, settings.listControlsSettings(), clientContext);
        this.listControlsPagedCallable = callableFactory.createPagedCallable(listControlsTransportSettings, settings.listControlsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateControlRequest, Control> createControlCallable() {
        return this.createControlCallable;
    }

    @Override
    public UnaryCallable<DeleteControlRequest, Empty> deleteControlCallable() {
        return this.deleteControlCallable;
    }

    @Override
    public UnaryCallable<UpdateControlRequest, Control> updateControlCallable() {
        return this.updateControlCallable;
    }

    @Override
    public UnaryCallable<GetControlRequest, Control> getControlCallable() {
        return this.getControlCallable;
    }

    @Override
    public UnaryCallable<ListControlsRequest, ListControlsResponse> listControlsCallable() {
        return this.listControlsCallable;
    }

    @Override
    public UnaryCallable<ListControlsRequest, ControlServiceClient.ListControlsPagedResponse> listControlsPagedCallable() {
        return this.listControlsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

