/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.discoveryengine.v1.CmekConfig;
import com.google.cloud.discoveryengine.v1.DeleteCmekConfigMetadata;
import com.google.cloud.discoveryengine.v1.DeleteCmekConfigRequest;
import com.google.cloud.discoveryengine.v1.GetCmekConfigRequest;
import com.google.cloud.discoveryengine.v1.ListCmekConfigsRequest;
import com.google.cloud.discoveryengine.v1.ListCmekConfigsResponse;
import com.google.cloud.discoveryengine.v1.UpdateCmekConfigMetadata;
import com.google.cloud.discoveryengine.v1.UpdateCmekConfigRequest;
import com.google.cloud.discoveryengine.v1.stub.CmekConfigServiceStub;
import com.google.cloud.discoveryengine.v1.stub.GrpcCmekConfigServiceStub;
import com.google.cloud.discoveryengine.v1.stub.HttpJsonCmekConfigServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CmekConfigServiceStubSettings
extends StubSettings<CmekConfigServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<UpdateCmekConfigRequest, Operation> updateCmekConfigSettings;
    private final OperationCallSettings<UpdateCmekConfigRequest, CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigOperationSettings;
    private final UnaryCallSettings<GetCmekConfigRequest, CmekConfig> getCmekConfigSettings;
    private final UnaryCallSettings<ListCmekConfigsRequest, ListCmekConfigsResponse> listCmekConfigsSettings;
    private final UnaryCallSettings<DeleteCmekConfigRequest, Operation> deleteCmekConfigSettings;
    private final OperationCallSettings<DeleteCmekConfigRequest, Empty, DeleteCmekConfigMetadata> deleteCmekConfigOperationSettings;

    public UnaryCallSettings<UpdateCmekConfigRequest, Operation> updateCmekConfigSettings() {
        return this.updateCmekConfigSettings;
    }

    public OperationCallSettings<UpdateCmekConfigRequest, CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigOperationSettings() {
        return this.updateCmekConfigOperationSettings;
    }

    public UnaryCallSettings<GetCmekConfigRequest, CmekConfig> getCmekConfigSettings() {
        return this.getCmekConfigSettings;
    }

    public UnaryCallSettings<ListCmekConfigsRequest, ListCmekConfigsResponse> listCmekConfigsSettings() {
        return this.listCmekConfigsSettings;
    }

    public UnaryCallSettings<DeleteCmekConfigRequest, Operation> deleteCmekConfigSettings() {
        return this.deleteCmekConfigSettings;
    }

    public OperationCallSettings<DeleteCmekConfigRequest, Empty, DeleteCmekConfigMetadata> deleteCmekConfigOperationSettings() {
        return this.deleteCmekConfigOperationSettings;
    }

    public CmekConfigServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCmekConfigServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCmekConfigServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CmekConfigServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CmekConfigServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CmekConfigServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CmekConfigServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CmekConfigServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.updateCmekConfigSettings = settingsBuilder.updateCmekConfigSettings().build();
        this.updateCmekConfigOperationSettings = settingsBuilder.updateCmekConfigOperationSettings().build();
        this.getCmekConfigSettings = settingsBuilder.getCmekConfigSettings().build();
        this.listCmekConfigsSettings = settingsBuilder.listCmekConfigsSettings().build();
        this.deleteCmekConfigSettings = settingsBuilder.deleteCmekConfigSettings().build();
        this.deleteCmekConfigOperationSettings = settingsBuilder.deleteCmekConfigOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CmekConfigServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<UpdateCmekConfigRequest, Operation> updateCmekConfigSettings;
        private final OperationCallSettings.Builder<UpdateCmekConfigRequest, CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigOperationSettings;
        private final UnaryCallSettings.Builder<GetCmekConfigRequest, CmekConfig> getCmekConfigSettings;
        private final UnaryCallSettings.Builder<ListCmekConfigsRequest, ListCmekConfigsResponse> listCmekConfigsSettings;
        private final UnaryCallSettings.Builder<DeleteCmekConfigRequest, Operation> deleteCmekConfigSettings;
        private final OperationCallSettings.Builder<DeleteCmekConfigRequest, Empty, DeleteCmekConfigMetadata> deleteCmekConfigOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.updateCmekConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCmekConfigOperationSettings = OperationCallSettings.newBuilder();
            this.getCmekConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCmekConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCmekConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCmekConfigOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.updateCmekConfigSettings, this.getCmekConfigSettings, this.listCmekConfigsSettings, this.deleteCmekConfigSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CmekConfigServiceStubSettings settings) {
            super((StubSettings)settings);
            this.updateCmekConfigSettings = settings.updateCmekConfigSettings.toBuilder();
            this.updateCmekConfigOperationSettings = settings.updateCmekConfigOperationSettings.toBuilder();
            this.getCmekConfigSettings = settings.getCmekConfigSettings.toBuilder();
            this.listCmekConfigsSettings = settings.listCmekConfigsSettings.toBuilder();
            this.deleteCmekConfigSettings = settings.deleteCmekConfigSettings.toBuilder();
            this.deleteCmekConfigOperationSettings = settings.deleteCmekConfigOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.updateCmekConfigSettings, this.getCmekConfigSettings, this.listCmekConfigsSettings, this.deleteCmekConfigSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CmekConfigServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CmekConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CmekConfigServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CmekConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CmekConfigServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CmekConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CmekConfigServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CmekConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.updateCmekConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getCmekConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCmekConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteCmekConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateCmekConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CmekConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateCmekConfigMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteCmekConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteCmekConfigMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<UpdateCmekConfigRequest, Operation> updateCmekConfigSettings() {
            return this.updateCmekConfigSettings;
        }

        public OperationCallSettings.Builder<UpdateCmekConfigRequest, CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigOperationSettings() {
            return this.updateCmekConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<GetCmekConfigRequest, CmekConfig> getCmekConfigSettings() {
            return this.getCmekConfigSettings;
        }

        public UnaryCallSettings.Builder<ListCmekConfigsRequest, ListCmekConfigsResponse> listCmekConfigsSettings() {
            return this.listCmekConfigsSettings;
        }

        public UnaryCallSettings.Builder<DeleteCmekConfigRequest, Operation> deleteCmekConfigSettings() {
            return this.deleteCmekConfigSettings;
        }

        public OperationCallSettings.Builder<DeleteCmekConfigRequest, Empty, DeleteCmekConfigMetadata> deleteCmekConfigOperationSettings() {
            return this.deleteCmekConfigOperationSettings;
        }

        public CmekConfigServiceStubSettings build() throws IOException {
            return new CmekConfigServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

