/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.GetSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSchemasRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSchemasResponse;
import com.google.cloud.discoveryengine.v1alpha.Schema;
import com.google.cloud.discoveryengine.v1alpha.SchemaServiceClient;
import com.google.cloud.discoveryengine.v1alpha.UpdateSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.UpdateSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcSchemaServiceCallableFactory;
import com.google.cloud.discoveryengine.v1alpha.stub.SchemaServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SchemaServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSchemaServiceStub
extends SchemaServiceStub {
    private static final MethodDescriptor<GetSchemaRequest, Schema> getSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/GetSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schema.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSchemasRequest, ListSchemasResponse> listSchemasMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/ListSchemas").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSchemasRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSchemasResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateSchemaRequest, Operation> createSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/CreateSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateSchemaRequest, Operation> updateSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/UpdateSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSchemaRequest, Operation> deleteSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/DeleteSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable;
    private final UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable;
    private final UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable;
    private final UnaryCallable<CreateSchemaRequest, Operation> createSchemaCallable;
    private final OperationCallable<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationCallable;
    private final UnaryCallable<UpdateSchemaRequest, Operation> updateSchemaCallable;
    private final OperationCallable<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationCallable;
    private final UnaryCallable<DeleteSchemaRequest, Operation> deleteSchemaCallable;
    private final OperationCallable<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSchemaServiceStub create(SchemaServiceStubSettings settings) throws IOException {
        return new GrpcSchemaServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSchemaServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSchemaServiceStub(SchemaServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSchemaServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSchemaServiceStub(SchemaServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSchemaServiceCallableFactory());
    }

    protected GrpcSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSchemasTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSchemasMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("schema.name", String.valueOf(request.getSchema().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getSchemaCallable = callableFactory.createUnaryCallable(getSchemaTransportSettings, settings.getSchemaSettings(), clientContext);
        this.listSchemasCallable = callableFactory.createUnaryCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.listSchemasPagedCallable = callableFactory.createPagedCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.createSchemaCallable = callableFactory.createUnaryCallable(createSchemaTransportSettings, settings.createSchemaSettings(), clientContext);
        this.createSchemaOperationCallable = callableFactory.createOperationCallable(createSchemaTransportSettings, settings.createSchemaOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateSchemaCallable = callableFactory.createUnaryCallable(updateSchemaTransportSettings, settings.updateSchemaSettings(), clientContext);
        this.updateSchemaOperationCallable = callableFactory.createOperationCallable(updateSchemaTransportSettings, settings.updateSchemaOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteSchemaCallable = callableFactory.createUnaryCallable(deleteSchemaTransportSettings, settings.deleteSchemaSettings(), clientContext);
        this.deleteSchemaOperationCallable = callableFactory.createOperationCallable(deleteSchemaTransportSettings, settings.deleteSchemaOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable() {
        return this.getSchemaCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable() {
        return this.listSchemasCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable() {
        return this.listSchemasPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSchemaRequest, Operation> createSchemaCallable() {
        return this.createSchemaCallable;
    }

    @Override
    public OperationCallable<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationCallable() {
        return this.createSchemaOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateSchemaRequest, Operation> updateSchemaCallable() {
        return this.updateSchemaCallable;
    }

    @Override
    public OperationCallable<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationCallable() {
        return this.updateSchemaOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSchemaRequest, Operation> deleteSchemaCallable() {
        return this.deleteSchemaCallable;
    }

    @Override
    public OperationCallable<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationCallable() {
        return this.deleteSchemaOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

