/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.Conversation;
import com.google.cloud.discoveryengine.v1beta.ConversationName;
import com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceSettings;
import com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest;
import com.google.cloud.discoveryengine.v1beta.ConverseConversationResponse;
import com.google.cloud.discoveryengine.v1beta.CreateConversationRequest;
import com.google.cloud.discoveryengine.v1beta.DataStoreName;
import com.google.cloud.discoveryengine.v1beta.DeleteConversationRequest;
import com.google.cloud.discoveryengine.v1beta.GetConversationRequest;
import com.google.cloud.discoveryengine.v1beta.ListConversationsRequest;
import com.google.cloud.discoveryengine.v1beta.ListConversationsResponse;
import com.google.cloud.discoveryengine.v1beta.TextInput;
import com.google.cloud.discoveryengine.v1beta.UpdateConversationRequest;
import com.google.cloud.discoveryengine.v1beta.stub.ConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.ConversationalSearchServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConversationalSearchServiceClient
implements BackgroundResource {
    private final ConversationalSearchServiceSettings settings;
    private final ConversationalSearchServiceStub stub;

    public static final ConversationalSearchServiceClient create() throws IOException {
        return ConversationalSearchServiceClient.create(ConversationalSearchServiceSettings.newBuilder().build());
    }

    public static final ConversationalSearchServiceClient create(ConversationalSearchServiceSettings settings) throws IOException {
        return new ConversationalSearchServiceClient(settings);
    }

    public static final ConversationalSearchServiceClient create(ConversationalSearchServiceStub stub) {
        return new ConversationalSearchServiceClient(stub);
    }

    protected ConversationalSearchServiceClient(ConversationalSearchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationalSearchServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConversationalSearchServiceClient(ConversationalSearchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversationalSearchServiceSettings getSettings() {
        return this.settings;
    }

    public ConversationalSearchServiceStub getStub() {
        return this.stub;
    }

    public final ConverseConversationResponse converseConversation(ConversationName name, TextInput query) {
        ConverseConversationRequest request = ConverseConversationRequest.newBuilder().setName(name == null ? null : name.toString()).setQuery(query).build();
        return this.converseConversation(request);
    }

    public final ConverseConversationResponse converseConversation(String name, TextInput query) {
        ConverseConversationRequest request = ConverseConversationRequest.newBuilder().setName(name).setQuery(query).build();
        return this.converseConversation(request);
    }

    public final ConverseConversationResponse converseConversation(ConverseConversationRequest request) {
        return (ConverseConversationResponse)this.converseConversationCallable().call((Object)request);
    }

    public final UnaryCallable<ConverseConversationRequest, ConverseConversationResponse> converseConversationCallable() {
        return this.stub.converseConversationCallable();
    }

    public final Conversation createConversation(DataStoreName parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(String parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(CreateConversationRequest request) {
        return (Conversation)this.createConversationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.stub.createConversationCallable();
    }

    public final void deleteConversation(ConversationName name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(String name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(DeleteConversationRequest request) {
        this.deleteConversationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.stub.deleteConversationCallable();
    }

    public final Conversation updateConversation(Conversation conversation, FieldMask updateMask) {
        UpdateConversationRequest request = UpdateConversationRequest.newBuilder().setConversation(conversation).setUpdateMask(updateMask).build();
        return this.updateConversation(request);
    }

    public final Conversation updateConversation(UpdateConversationRequest request) {
        return (Conversation)this.updateConversationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConversationRequest, Conversation> updateConversationCallable() {
        return this.stub.updateConversationCallable();
    }

    public final Conversation getConversation(ConversationName name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(String name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(GetConversationRequest request) {
        return (Conversation)this.getConversationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.stub.getConversationCallable();
    }

    public final ListConversationsPagedResponse listConversations(DataStoreName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(String parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ListConversationsRequest request) {
        return (ListConversationsPagedResponse)((Object)this.listConversationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.stub.listConversationsPagedCallable();
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.stub.listConversationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConversationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        private ListConversationsFixedSizeCollection(List<ListConversationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationsFixedSizeCollection(null, 0);
        }

        protected ListConversationsFixedSizeCollection createCollection(List<ListConversationsPage> pages, int collectionSize) {
            return new ListConversationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationsPage
    extends AbstractPage<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage> {
        private ListConversationsPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationsPage createEmptyPage() {
            return new ListConversationsPage(null, null);
        }

        protected ListConversationsPage createPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            return new ListConversationsPage(context, response);
        }

        public ApiFuture<ListConversationsPage> createPageAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationsPagedResponse
    extends AbstractPagedListResponse<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        public static ApiFuture<ListConversationsPagedResponse> createAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            ApiFuture<ListConversationsPage> futurePage = ListConversationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationsPagedResponse((ListConversationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationsPagedResponse(ListConversationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

