/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.Chunk;
import com.google.cloud.discoveryengine.v1alpha.ChunkServiceClient;
import com.google.cloud.discoveryengine.v1alpha.GetChunkRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.ChunkServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.ChunkServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcChunkServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcChunkServiceStub
extends ChunkServiceStub {
    private static final MethodDescriptor<GetChunkRequest, Chunk> getChunkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.ChunkService/GetChunk").setRequestMarshaller(ProtoUtils.marshaller((Message)GetChunkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Chunk.getDefaultInstance())).build();
    private static final MethodDescriptor<ListChunksRequest, ListChunksResponse> listChunksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.ChunkService/ListChunks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListChunksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListChunksResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetChunkRequest, Chunk> getChunkCallable;
    private final UnaryCallable<ListChunksRequest, ListChunksResponse> listChunksCallable;
    private final UnaryCallable<ListChunksRequest, ChunkServiceClient.ListChunksPagedResponse> listChunksPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcChunkServiceStub create(ChunkServiceStubSettings settings) throws IOException {
        return new GrpcChunkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcChunkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcChunkServiceStub(ChunkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcChunkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcChunkServiceStub(ChunkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcChunkServiceStub(ChunkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcChunkServiceCallableFactory());
    }

    protected GrpcChunkServiceStub(ChunkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getChunkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getChunkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listChunksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listChunksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getChunkCallable = callableFactory.createUnaryCallable(getChunkTransportSettings, settings.getChunkSettings(), clientContext);
        this.listChunksCallable = callableFactory.createUnaryCallable(listChunksTransportSettings, settings.listChunksSettings(), clientContext);
        this.listChunksPagedCallable = callableFactory.createPagedCallable(listChunksTransportSettings, settings.listChunksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetChunkRequest, Chunk> getChunkCallable() {
        return this.getChunkCallable;
    }

    @Override
    public UnaryCallable<ListChunksRequest, ListChunksResponse> listChunksCallable() {
        return this.listChunksCallable;
    }

    @Override
    public UnaryCallable<ListChunksRequest, ChunkServiceClient.ListChunksPagedResponse> listChunksPagedCallable() {
        return this.listChunksPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

