/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.BatchCreateTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1beta.BatchCreateTargetSitesRequest;
import com.google.cloud.discoveryengine.v1beta.BatchCreateTargetSitesResponse;
import com.google.cloud.discoveryengine.v1beta.BatchVerifyTargetSitesMetadata;
import com.google.cloud.discoveryengine.v1beta.BatchVerifyTargetSitesRequest;
import com.google.cloud.discoveryengine.v1beta.BatchVerifyTargetSitesResponse;
import com.google.cloud.discoveryengine.v1beta.CreateTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1beta.CreateTargetSiteRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1beta.DeleteTargetSiteRequest;
import com.google.cloud.discoveryengine.v1beta.DisableAdvancedSiteSearchMetadata;
import com.google.cloud.discoveryengine.v1beta.DisableAdvancedSiteSearchRequest;
import com.google.cloud.discoveryengine.v1beta.DisableAdvancedSiteSearchResponse;
import com.google.cloud.discoveryengine.v1beta.EnableAdvancedSiteSearchMetadata;
import com.google.cloud.discoveryengine.v1beta.EnableAdvancedSiteSearchRequest;
import com.google.cloud.discoveryengine.v1beta.EnableAdvancedSiteSearchResponse;
import com.google.cloud.discoveryengine.v1beta.FetchDomainVerificationStatusRequest;
import com.google.cloud.discoveryengine.v1beta.FetchDomainVerificationStatusResponse;
import com.google.cloud.discoveryengine.v1beta.GetSiteSearchEngineRequest;
import com.google.cloud.discoveryengine.v1beta.GetTargetSiteRequest;
import com.google.cloud.discoveryengine.v1beta.ListTargetSitesRequest;
import com.google.cloud.discoveryengine.v1beta.ListTargetSitesResponse;
import com.google.cloud.discoveryengine.v1beta.RecrawlUrisMetadata;
import com.google.cloud.discoveryengine.v1beta.RecrawlUrisRequest;
import com.google.cloud.discoveryengine.v1beta.RecrawlUrisResponse;
import com.google.cloud.discoveryengine.v1beta.SiteSearchEngine;
import com.google.cloud.discoveryengine.v1beta.SiteSearchEngineServiceClient;
import com.google.cloud.discoveryengine.v1beta.TargetSite;
import com.google.cloud.discoveryengine.v1beta.UpdateTargetSiteMetadata;
import com.google.cloud.discoveryengine.v1beta.UpdateTargetSiteRequest;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcSiteSearchEngineServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonSiteSearchEngineServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SiteSearchEngineServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SiteSearchEngineServiceStubSettings
extends StubSettings<SiteSearchEngineServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetSiteSearchEngineRequest, SiteSearchEngine> getSiteSearchEngineSettings;
    private final UnaryCallSettings<CreateTargetSiteRequest, Operation> createTargetSiteSettings;
    private final OperationCallSettings<CreateTargetSiteRequest, TargetSite, CreateTargetSiteMetadata> createTargetSiteOperationSettings;
    private final UnaryCallSettings<BatchCreateTargetSitesRequest, Operation> batchCreateTargetSitesSettings;
    private final OperationCallSettings<BatchCreateTargetSitesRequest, BatchCreateTargetSitesResponse, BatchCreateTargetSiteMetadata> batchCreateTargetSitesOperationSettings;
    private final UnaryCallSettings<GetTargetSiteRequest, TargetSite> getTargetSiteSettings;
    private final UnaryCallSettings<UpdateTargetSiteRequest, Operation> updateTargetSiteSettings;
    private final OperationCallSettings<UpdateTargetSiteRequest, TargetSite, UpdateTargetSiteMetadata> updateTargetSiteOperationSettings;
    private final UnaryCallSettings<DeleteTargetSiteRequest, Operation> deleteTargetSiteSettings;
    private final OperationCallSettings<DeleteTargetSiteRequest, Empty, DeleteTargetSiteMetadata> deleteTargetSiteOperationSettings;
    private final PagedCallSettings<ListTargetSitesRequest, ListTargetSitesResponse, SiteSearchEngineServiceClient.ListTargetSitesPagedResponse> listTargetSitesSettings;
    private final UnaryCallSettings<EnableAdvancedSiteSearchRequest, Operation> enableAdvancedSiteSearchSettings;
    private final OperationCallSettings<EnableAdvancedSiteSearchRequest, EnableAdvancedSiteSearchResponse, EnableAdvancedSiteSearchMetadata> enableAdvancedSiteSearchOperationSettings;
    private final UnaryCallSettings<DisableAdvancedSiteSearchRequest, Operation> disableAdvancedSiteSearchSettings;
    private final OperationCallSettings<DisableAdvancedSiteSearchRequest, DisableAdvancedSiteSearchResponse, DisableAdvancedSiteSearchMetadata> disableAdvancedSiteSearchOperationSettings;
    private final UnaryCallSettings<RecrawlUrisRequest, Operation> recrawlUrisSettings;
    private final OperationCallSettings<RecrawlUrisRequest, RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisOperationSettings;
    private final UnaryCallSettings<BatchVerifyTargetSitesRequest, Operation> batchVerifyTargetSitesSettings;
    private final OperationCallSettings<BatchVerifyTargetSitesRequest, BatchVerifyTargetSitesResponse, BatchVerifyTargetSitesMetadata> batchVerifyTargetSitesOperationSettings;
    private final PagedCallSettings<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse> fetchDomainVerificationStatusSettings;
    private static final PagedListDescriptor<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite> LIST_TARGET_SITES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetSitesRequest injectToken(ListTargetSitesRequest payload, String token) {
            return ListTargetSitesRequest.newBuilder((ListTargetSitesRequest)payload).setPageToken(token).build();
        }

        public ListTargetSitesRequest injectPageSize(ListTargetSitesRequest payload, int pageSize) {
            return ListTargetSitesRequest.newBuilder((ListTargetSitesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTargetSitesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTargetSitesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetSite> extractResources(ListTargetSitesResponse payload) {
            return payload.getTargetSitesList() == null ? ImmutableList.of() : payload.getTargetSitesList();
        }
    };
    private static final PagedListDescriptor<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite> FETCH_DOMAIN_VERIFICATION_STATUS_PAGE_STR_DESC = new PagedListDescriptor<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite>(){

        public String emptyToken() {
            return "";
        }

        public FetchDomainVerificationStatusRequest injectToken(FetchDomainVerificationStatusRequest payload, String token) {
            return FetchDomainVerificationStatusRequest.newBuilder((FetchDomainVerificationStatusRequest)payload).setPageToken(token).build();
        }

        public FetchDomainVerificationStatusRequest injectPageSize(FetchDomainVerificationStatusRequest payload, int pageSize) {
            return FetchDomainVerificationStatusRequest.newBuilder((FetchDomainVerificationStatusRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchDomainVerificationStatusRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchDomainVerificationStatusResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetSite> extractResources(FetchDomainVerificationStatusResponse payload) {
            return payload.getTargetSitesList() == null ? ImmutableList.of() : payload.getTargetSitesList();
        }
    };
    private static final PagedListResponseFactory<ListTargetSitesRequest, ListTargetSitesResponse, SiteSearchEngineServiceClient.ListTargetSitesPagedResponse> LIST_TARGET_SITES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetSitesRequest, ListTargetSitesResponse, SiteSearchEngineServiceClient.ListTargetSitesPagedResponse>(){

        public ApiFuture<SiteSearchEngineServiceClient.ListTargetSitesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetSitesRequest, ListTargetSitesResponse> callable, ListTargetSitesRequest request, ApiCallContext context, ApiFuture<ListTargetSitesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_SITES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SiteSearchEngineServiceClient.ListTargetSitesPagedResponse.createAsync((PageContext<ListTargetSitesRequest, ListTargetSitesResponse, TargetSite>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse> FETCH_DOMAIN_VERIFICATION_STATUS_PAGE_STR_FACT = new PagedListResponseFactory<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse>(){

        public ApiFuture<SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse> getFuturePagedResponse(UnaryCallable<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse> callable, FetchDomainVerificationStatusRequest request, ApiCallContext context, ApiFuture<FetchDomainVerificationStatusResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_DOMAIN_VERIFICATION_STATUS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse.createAsync((PageContext<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, TargetSite>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetSiteSearchEngineRequest, SiteSearchEngine> getSiteSearchEngineSettings() {
        return this.getSiteSearchEngineSettings;
    }

    public UnaryCallSettings<CreateTargetSiteRequest, Operation> createTargetSiteSettings() {
        return this.createTargetSiteSettings;
    }

    public OperationCallSettings<CreateTargetSiteRequest, TargetSite, CreateTargetSiteMetadata> createTargetSiteOperationSettings() {
        return this.createTargetSiteOperationSettings;
    }

    public UnaryCallSettings<BatchCreateTargetSitesRequest, Operation> batchCreateTargetSitesSettings() {
        return this.batchCreateTargetSitesSettings;
    }

    public OperationCallSettings<BatchCreateTargetSitesRequest, BatchCreateTargetSitesResponse, BatchCreateTargetSiteMetadata> batchCreateTargetSitesOperationSettings() {
        return this.batchCreateTargetSitesOperationSettings;
    }

    public UnaryCallSettings<GetTargetSiteRequest, TargetSite> getTargetSiteSettings() {
        return this.getTargetSiteSettings;
    }

    public UnaryCallSettings<UpdateTargetSiteRequest, Operation> updateTargetSiteSettings() {
        return this.updateTargetSiteSettings;
    }

    public OperationCallSettings<UpdateTargetSiteRequest, TargetSite, UpdateTargetSiteMetadata> updateTargetSiteOperationSettings() {
        return this.updateTargetSiteOperationSettings;
    }

    public UnaryCallSettings<DeleteTargetSiteRequest, Operation> deleteTargetSiteSettings() {
        return this.deleteTargetSiteSettings;
    }

    public OperationCallSettings<DeleteTargetSiteRequest, Empty, DeleteTargetSiteMetadata> deleteTargetSiteOperationSettings() {
        return this.deleteTargetSiteOperationSettings;
    }

    public PagedCallSettings<ListTargetSitesRequest, ListTargetSitesResponse, SiteSearchEngineServiceClient.ListTargetSitesPagedResponse> listTargetSitesSettings() {
        return this.listTargetSitesSettings;
    }

    public UnaryCallSettings<EnableAdvancedSiteSearchRequest, Operation> enableAdvancedSiteSearchSettings() {
        return this.enableAdvancedSiteSearchSettings;
    }

    public OperationCallSettings<EnableAdvancedSiteSearchRequest, EnableAdvancedSiteSearchResponse, EnableAdvancedSiteSearchMetadata> enableAdvancedSiteSearchOperationSettings() {
        return this.enableAdvancedSiteSearchOperationSettings;
    }

    public UnaryCallSettings<DisableAdvancedSiteSearchRequest, Operation> disableAdvancedSiteSearchSettings() {
        return this.disableAdvancedSiteSearchSettings;
    }

    public OperationCallSettings<DisableAdvancedSiteSearchRequest, DisableAdvancedSiteSearchResponse, DisableAdvancedSiteSearchMetadata> disableAdvancedSiteSearchOperationSettings() {
        return this.disableAdvancedSiteSearchOperationSettings;
    }

    public UnaryCallSettings<RecrawlUrisRequest, Operation> recrawlUrisSettings() {
        return this.recrawlUrisSettings;
    }

    public OperationCallSettings<RecrawlUrisRequest, RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisOperationSettings() {
        return this.recrawlUrisOperationSettings;
    }

    public UnaryCallSettings<BatchVerifyTargetSitesRequest, Operation> batchVerifyTargetSitesSettings() {
        return this.batchVerifyTargetSitesSettings;
    }

    public OperationCallSettings<BatchVerifyTargetSitesRequest, BatchVerifyTargetSitesResponse, BatchVerifyTargetSitesMetadata> batchVerifyTargetSitesOperationSettings() {
        return this.batchVerifyTargetSitesOperationSettings;
    }

    public PagedCallSettings<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse> fetchDomainVerificationStatusSettings() {
        return this.fetchDomainVerificationStatusSettings;
    }

    public SiteSearchEngineServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSiteSearchEngineServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSiteSearchEngineServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return SiteSearchEngineServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SiteSearchEngineServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SiteSearchEngineServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SiteSearchEngineServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SiteSearchEngineServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SiteSearchEngineServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSiteSearchEngineSettings = settingsBuilder.getSiteSearchEngineSettings().build();
        this.createTargetSiteSettings = settingsBuilder.createTargetSiteSettings().build();
        this.createTargetSiteOperationSettings = settingsBuilder.createTargetSiteOperationSettings().build();
        this.batchCreateTargetSitesSettings = settingsBuilder.batchCreateTargetSitesSettings().build();
        this.batchCreateTargetSitesOperationSettings = settingsBuilder.batchCreateTargetSitesOperationSettings().build();
        this.getTargetSiteSettings = settingsBuilder.getTargetSiteSettings().build();
        this.updateTargetSiteSettings = settingsBuilder.updateTargetSiteSettings().build();
        this.updateTargetSiteOperationSettings = settingsBuilder.updateTargetSiteOperationSettings().build();
        this.deleteTargetSiteSettings = settingsBuilder.deleteTargetSiteSettings().build();
        this.deleteTargetSiteOperationSettings = settingsBuilder.deleteTargetSiteOperationSettings().build();
        this.listTargetSitesSettings = settingsBuilder.listTargetSitesSettings().build();
        this.enableAdvancedSiteSearchSettings = settingsBuilder.enableAdvancedSiteSearchSettings().build();
        this.enableAdvancedSiteSearchOperationSettings = settingsBuilder.enableAdvancedSiteSearchOperationSettings().build();
        this.disableAdvancedSiteSearchSettings = settingsBuilder.disableAdvancedSiteSearchSettings().build();
        this.disableAdvancedSiteSearchOperationSettings = settingsBuilder.disableAdvancedSiteSearchOperationSettings().build();
        this.recrawlUrisSettings = settingsBuilder.recrawlUrisSettings().build();
        this.recrawlUrisOperationSettings = settingsBuilder.recrawlUrisOperationSettings().build();
        this.batchVerifyTargetSitesSettings = settingsBuilder.batchVerifyTargetSitesSettings().build();
        this.batchVerifyTargetSitesOperationSettings = settingsBuilder.batchVerifyTargetSitesOperationSettings().build();
        this.fetchDomainVerificationStatusSettings = settingsBuilder.fetchDomainVerificationStatusSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SiteSearchEngineServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetSiteSearchEngineRequest, SiteSearchEngine> getSiteSearchEngineSettings;
        private final UnaryCallSettings.Builder<CreateTargetSiteRequest, Operation> createTargetSiteSettings;
        private final OperationCallSettings.Builder<CreateTargetSiteRequest, TargetSite, CreateTargetSiteMetadata> createTargetSiteOperationSettings;
        private final UnaryCallSettings.Builder<BatchCreateTargetSitesRequest, Operation> batchCreateTargetSitesSettings;
        private final OperationCallSettings.Builder<BatchCreateTargetSitesRequest, BatchCreateTargetSitesResponse, BatchCreateTargetSiteMetadata> batchCreateTargetSitesOperationSettings;
        private final UnaryCallSettings.Builder<GetTargetSiteRequest, TargetSite> getTargetSiteSettings;
        private final UnaryCallSettings.Builder<UpdateTargetSiteRequest, Operation> updateTargetSiteSettings;
        private final OperationCallSettings.Builder<UpdateTargetSiteRequest, TargetSite, UpdateTargetSiteMetadata> updateTargetSiteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTargetSiteRequest, Operation> deleteTargetSiteSettings;
        private final OperationCallSettings.Builder<DeleteTargetSiteRequest, Empty, DeleteTargetSiteMetadata> deleteTargetSiteOperationSettings;
        private final PagedCallSettings.Builder<ListTargetSitesRequest, ListTargetSitesResponse, SiteSearchEngineServiceClient.ListTargetSitesPagedResponse> listTargetSitesSettings;
        private final UnaryCallSettings.Builder<EnableAdvancedSiteSearchRequest, Operation> enableAdvancedSiteSearchSettings;
        private final OperationCallSettings.Builder<EnableAdvancedSiteSearchRequest, EnableAdvancedSiteSearchResponse, EnableAdvancedSiteSearchMetadata> enableAdvancedSiteSearchOperationSettings;
        private final UnaryCallSettings.Builder<DisableAdvancedSiteSearchRequest, Operation> disableAdvancedSiteSearchSettings;
        private final OperationCallSettings.Builder<DisableAdvancedSiteSearchRequest, DisableAdvancedSiteSearchResponse, DisableAdvancedSiteSearchMetadata> disableAdvancedSiteSearchOperationSettings;
        private final UnaryCallSettings.Builder<RecrawlUrisRequest, Operation> recrawlUrisSettings;
        private final OperationCallSettings.Builder<RecrawlUrisRequest, RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisOperationSettings;
        private final UnaryCallSettings.Builder<BatchVerifyTargetSitesRequest, Operation> batchVerifyTargetSitesSettings;
        private final OperationCallSettings.Builder<BatchVerifyTargetSitesRequest, BatchVerifyTargetSitesResponse, BatchVerifyTargetSitesMetadata> batchVerifyTargetSitesOperationSettings;
        private final PagedCallSettings.Builder<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse> fetchDomainVerificationStatusSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSiteSearchEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTargetSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTargetSiteOperationSettings = OperationCallSettings.newBuilder();
            this.batchCreateTargetSitesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateTargetSitesOperationSettings = OperationCallSettings.newBuilder();
            this.getTargetSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTargetSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTargetSiteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTargetSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTargetSiteOperationSettings = OperationCallSettings.newBuilder();
            this.listTargetSitesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_SITES_PAGE_STR_FACT);
            this.enableAdvancedSiteSearchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableAdvancedSiteSearchOperationSettings = OperationCallSettings.newBuilder();
            this.disableAdvancedSiteSearchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableAdvancedSiteSearchOperationSettings = OperationCallSettings.newBuilder();
            this.recrawlUrisSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.recrawlUrisOperationSettings = OperationCallSettings.newBuilder();
            this.batchVerifyTargetSitesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchVerifyTargetSitesOperationSettings = OperationCallSettings.newBuilder();
            this.fetchDomainVerificationStatusSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_DOMAIN_VERIFICATION_STATUS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSiteSearchEngineSettings, this.createTargetSiteSettings, this.batchCreateTargetSitesSettings, this.getTargetSiteSettings, this.updateTargetSiteSettings, this.deleteTargetSiteSettings, this.listTargetSitesSettings, this.enableAdvancedSiteSearchSettings, this.disableAdvancedSiteSearchSettings, this.recrawlUrisSettings, this.batchVerifyTargetSitesSettings, this.fetchDomainVerificationStatusSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(SiteSearchEngineServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getSiteSearchEngineSettings = settings.getSiteSearchEngineSettings.toBuilder();
            this.createTargetSiteSettings = settings.createTargetSiteSettings.toBuilder();
            this.createTargetSiteOperationSettings = settings.createTargetSiteOperationSettings.toBuilder();
            this.batchCreateTargetSitesSettings = settings.batchCreateTargetSitesSettings.toBuilder();
            this.batchCreateTargetSitesOperationSettings = settings.batchCreateTargetSitesOperationSettings.toBuilder();
            this.getTargetSiteSettings = settings.getTargetSiteSettings.toBuilder();
            this.updateTargetSiteSettings = settings.updateTargetSiteSettings.toBuilder();
            this.updateTargetSiteOperationSettings = settings.updateTargetSiteOperationSettings.toBuilder();
            this.deleteTargetSiteSettings = settings.deleteTargetSiteSettings.toBuilder();
            this.deleteTargetSiteOperationSettings = settings.deleteTargetSiteOperationSettings.toBuilder();
            this.listTargetSitesSettings = settings.listTargetSitesSettings.toBuilder();
            this.enableAdvancedSiteSearchSettings = settings.enableAdvancedSiteSearchSettings.toBuilder();
            this.enableAdvancedSiteSearchOperationSettings = settings.enableAdvancedSiteSearchOperationSettings.toBuilder();
            this.disableAdvancedSiteSearchSettings = settings.disableAdvancedSiteSearchSettings.toBuilder();
            this.disableAdvancedSiteSearchOperationSettings = settings.disableAdvancedSiteSearchOperationSettings.toBuilder();
            this.recrawlUrisSettings = settings.recrawlUrisSettings.toBuilder();
            this.recrawlUrisOperationSettings = settings.recrawlUrisOperationSettings.toBuilder();
            this.batchVerifyTargetSitesSettings = settings.batchVerifyTargetSitesSettings.toBuilder();
            this.batchVerifyTargetSitesOperationSettings = settings.batchVerifyTargetSitesOperationSettings.toBuilder();
            this.fetchDomainVerificationStatusSettings = settings.fetchDomainVerificationStatusSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSiteSearchEngineSettings, this.createTargetSiteSettings, this.batchCreateTargetSitesSettings, this.getTargetSiteSettings, this.updateTargetSiteSettings, this.deleteTargetSiteSettings, this.listTargetSitesSettings, this.enableAdvancedSiteSearchSettings, this.disableAdvancedSiteSearchSettings, this.recrawlUrisSettings, this.batchVerifyTargetSitesSettings, this.fetchDomainVerificationStatusSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SiteSearchEngineServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SiteSearchEngineServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SiteSearchEngineServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SiteSearchEngineServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SiteSearchEngineServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SiteSearchEngineServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SiteSearchEngineServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SiteSearchEngineServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSiteSearchEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTargetSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateTargetSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTargetSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTargetSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTargetSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTargetSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.enableAdvancedSiteSearchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.disableAdvancedSiteSearchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.recrawlUrisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchVerifyTargetSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchDomainVerificationStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTargetSiteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TargetSite.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTargetSiteMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchCreateTargetSitesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchCreateTargetSitesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchCreateTargetSiteMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTargetSiteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TargetSite.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateTargetSiteMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTargetSiteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteTargetSiteMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.enableAdvancedSiteSearchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EnableAdvancedSiteSearchResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(EnableAdvancedSiteSearchMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.disableAdvancedSiteSearchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DisableAdvancedSiteSearchResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DisableAdvancedSiteSearchMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.recrawlUrisOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RecrawlUrisResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RecrawlUrisMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchVerifyTargetSitesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchVerifyTargetSitesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchVerifyTargetSitesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetSiteSearchEngineRequest, SiteSearchEngine> getSiteSearchEngineSettings() {
            return this.getSiteSearchEngineSettings;
        }

        public UnaryCallSettings.Builder<CreateTargetSiteRequest, Operation> createTargetSiteSettings() {
            return this.createTargetSiteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTargetSiteRequest, TargetSite, CreateTargetSiteMetadata> createTargetSiteOperationSettings() {
            return this.createTargetSiteOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateTargetSitesRequest, Operation> batchCreateTargetSitesSettings() {
            return this.batchCreateTargetSitesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchCreateTargetSitesRequest, BatchCreateTargetSitesResponse, BatchCreateTargetSiteMetadata> batchCreateTargetSitesOperationSettings() {
            return this.batchCreateTargetSitesOperationSettings;
        }

        public UnaryCallSettings.Builder<GetTargetSiteRequest, TargetSite> getTargetSiteSettings() {
            return this.getTargetSiteSettings;
        }

        public UnaryCallSettings.Builder<UpdateTargetSiteRequest, Operation> updateTargetSiteSettings() {
            return this.updateTargetSiteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTargetSiteRequest, TargetSite, UpdateTargetSiteMetadata> updateTargetSiteOperationSettings() {
            return this.updateTargetSiteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetSiteRequest, Operation> deleteTargetSiteSettings() {
            return this.deleteTargetSiteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTargetSiteRequest, Empty, DeleteTargetSiteMetadata> deleteTargetSiteOperationSettings() {
            return this.deleteTargetSiteOperationSettings;
        }

        public PagedCallSettings.Builder<ListTargetSitesRequest, ListTargetSitesResponse, SiteSearchEngineServiceClient.ListTargetSitesPagedResponse> listTargetSitesSettings() {
            return this.listTargetSitesSettings;
        }

        public UnaryCallSettings.Builder<EnableAdvancedSiteSearchRequest, Operation> enableAdvancedSiteSearchSettings() {
            return this.enableAdvancedSiteSearchSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<EnableAdvancedSiteSearchRequest, EnableAdvancedSiteSearchResponse, EnableAdvancedSiteSearchMetadata> enableAdvancedSiteSearchOperationSettings() {
            return this.enableAdvancedSiteSearchOperationSettings;
        }

        public UnaryCallSettings.Builder<DisableAdvancedSiteSearchRequest, Operation> disableAdvancedSiteSearchSettings() {
            return this.disableAdvancedSiteSearchSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DisableAdvancedSiteSearchRequest, DisableAdvancedSiteSearchResponse, DisableAdvancedSiteSearchMetadata> disableAdvancedSiteSearchOperationSettings() {
            return this.disableAdvancedSiteSearchOperationSettings;
        }

        public UnaryCallSettings.Builder<RecrawlUrisRequest, Operation> recrawlUrisSettings() {
            return this.recrawlUrisSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RecrawlUrisRequest, RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisOperationSettings() {
            return this.recrawlUrisOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchVerifyTargetSitesRequest, Operation> batchVerifyTargetSitesSettings() {
            return this.batchVerifyTargetSitesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchVerifyTargetSitesRequest, BatchVerifyTargetSitesResponse, BatchVerifyTargetSitesMetadata> batchVerifyTargetSitesOperationSettings() {
            return this.batchVerifyTargetSitesOperationSettings;
        }

        public PagedCallSettings.Builder<FetchDomainVerificationStatusRequest, FetchDomainVerificationStatusResponse, SiteSearchEngineServiceClient.FetchDomainVerificationStatusPagedResponse> fetchDomainVerificationStatusSettings() {
            return this.fetchDomainVerificationStatusSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return SiteSearchEngineServiceStubSettings.getDefaultEndpoint();
        }

        public SiteSearchEngineServiceStubSettings build() throws IOException {
            return new SiteSearchEngineServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

