/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.GetSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSchemasRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSchemasResponse;
import com.google.cloud.discoveryengine.v1alpha.Schema;
import com.google.cloud.discoveryengine.v1alpha.SchemaServiceClient;
import com.google.cloud.discoveryengine.v1alpha.UpdateSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.UpdateSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonSchemaServiceCallableFactory;
import com.google.cloud.discoveryengine.v1alpha.stub.SchemaServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SchemaServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSchemaServiceStub
extends SchemaServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Schema.getDescriptor()).add(Empty.getDescriptor()).add(UpdateSchemaMetadata.getDescriptor()).add(DeleteSchemaMetadata.getDescriptor()).add(CreateSchemaMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetSchemaRequest, Schema> getSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/GetSchema").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/dataStores/*/schemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Schema.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSchemasRequest, ListSchemasResponse> listSchemasMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/ListSchemas").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*/dataStores/*}/schemas", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{parent=projects/*/locations/*/collections/*/dataStores/*}/schemas"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSchemasResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateSchemaRequest, Operation> createSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/CreateSchema").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*/dataStores/*}/schemas", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{parent=projects/*/locations/*/collections/*/dataStores/*}/schemas"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "schemaId", (Object)request.getSchemaId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("schema", (Message)request.getSchema(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateSchemaRequest, Operation> updateSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/UpdateSchema").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{schema.name=projects/*/locations/*/dataStores/*/schemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "schema.name", (Object)request.getSchema().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{schema.name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("schema", (Message)request.getSchema(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteSchemaRequest, Operation> deleteSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.SchemaService/DeleteSchema").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/dataStores/*/schemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable;
    private final UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable;
    private final UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable;
    private final UnaryCallable<CreateSchemaRequest, Operation> createSchemaCallable;
    private final OperationCallable<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationCallable;
    private final UnaryCallable<UpdateSchemaRequest, Operation> updateSchemaCallable;
    private final OperationCallable<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationCallable;
    private final UnaryCallable<DeleteSchemaRequest, Operation> deleteSchemaCallable;
    private final OperationCallable<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSchemaServiceStub create(SchemaServiceStubSettings settings) throws IOException {
        return new HttpJsonSchemaServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSchemaServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSchemaServiceStub(SchemaServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSchemaServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSchemaServiceStub(SchemaServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSchemaServiceCallableFactory());
    }

    protected HttpJsonSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataConnector/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/engines/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataConnector}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/engines/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*}/operations").build()).build()).build());
        HttpJsonCallSettings getSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSchemasTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSchemasMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("schema.name", String.valueOf(request.getSchema().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getSchemaCallable = callableFactory.createUnaryCallable(getSchemaTransportSettings, settings.getSchemaSettings(), clientContext);
        this.listSchemasCallable = callableFactory.createUnaryCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.listSchemasPagedCallable = callableFactory.createPagedCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.createSchemaCallable = callableFactory.createUnaryCallable(createSchemaTransportSettings, settings.createSchemaSettings(), clientContext);
        this.createSchemaOperationCallable = callableFactory.createOperationCallable(createSchemaTransportSettings, settings.createSchemaOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateSchemaCallable = callableFactory.createUnaryCallable(updateSchemaTransportSettings, settings.updateSchemaSettings(), clientContext);
        this.updateSchemaOperationCallable = callableFactory.createOperationCallable(updateSchemaTransportSettings, settings.updateSchemaOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteSchemaCallable = callableFactory.createUnaryCallable(deleteSchemaTransportSettings, settings.deleteSchemaSettings(), clientContext);
        this.deleteSchemaOperationCallable = callableFactory.createOperationCallable(deleteSchemaTransportSettings, settings.deleteSchemaOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getSchemaMethodDescriptor);
        methodDescriptors.add(listSchemasMethodDescriptor);
        methodDescriptors.add(createSchemaMethodDescriptor);
        methodDescriptors.add(updateSchemaMethodDescriptor);
        methodDescriptors.add(deleteSchemaMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable() {
        return this.getSchemaCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable() {
        return this.listSchemasCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable() {
        return this.listSchemasPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSchemaRequest, Operation> createSchemaCallable() {
        return this.createSchemaCallable;
    }

    @Override
    public OperationCallable<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationCallable() {
        return this.createSchemaOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateSchemaRequest, Operation> updateSchemaCallable() {
        return this.updateSchemaCallable;
    }

    @Override
    public OperationCallable<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationCallable() {
        return this.updateSchemaOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSchemaRequest, Operation> deleteSchemaCallable() {
        return this.deleteSchemaCallable;
    }

    @Override
    public OperationCallable<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationCallable() {
        return this.deleteSchemaOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

