/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.BranchName;
import com.google.cloud.discoveryengine.v1.CreateDocumentRequest;
import com.google.cloud.discoveryengine.v1.DeleteDocumentRequest;
import com.google.cloud.discoveryengine.v1.Document;
import com.google.cloud.discoveryengine.v1.DocumentName;
import com.google.cloud.discoveryengine.v1.DocumentServiceSettings;
import com.google.cloud.discoveryengine.v1.GetDocumentRequest;
import com.google.cloud.discoveryengine.v1.ImportDocumentsMetadata;
import com.google.cloud.discoveryengine.v1.ImportDocumentsRequest;
import com.google.cloud.discoveryengine.v1.ImportDocumentsResponse;
import com.google.cloud.discoveryengine.v1.ListDocumentsRequest;
import com.google.cloud.discoveryengine.v1.ListDocumentsResponse;
import com.google.cloud.discoveryengine.v1.PurgeDocumentsMetadata;
import com.google.cloud.discoveryengine.v1.PurgeDocumentsRequest;
import com.google.cloud.discoveryengine.v1.PurgeDocumentsResponse;
import com.google.cloud.discoveryengine.v1.UpdateDocumentRequest;
import com.google.cloud.discoveryengine.v1.stub.DocumentServiceStub;
import com.google.cloud.discoveryengine.v1.stub.DocumentServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DocumentServiceClient
implements BackgroundResource {
    private final DocumentServiceSettings settings;
    private final DocumentServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DocumentServiceClient create() throws IOException {
        return DocumentServiceClient.create(DocumentServiceSettings.newBuilder().build());
    }

    public static final DocumentServiceClient create(DocumentServiceSettings settings) throws IOException {
        return new DocumentServiceClient(settings);
    }

    public static final DocumentServiceClient create(DocumentServiceStub stub) {
        return new DocumentServiceClient(stub);
    }

    protected DocumentServiceClient(DocumentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DocumentServiceClient(DocumentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DocumentServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Document getDocument(DocumentName name) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDocument(request);
    }

    public final Document getDocument(String name) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName(name).build();
        return this.getDocument(request);
    }

    public final Document getDocument(GetDocumentRequest request) {
        return (Document)this.getDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.stub.getDocumentCallable();
    }

    public final ListDocumentsPagedResponse listDocuments(BranchName parent) {
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDocuments(request);
    }

    public final ListDocumentsPagedResponse listDocuments(String parent) {
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent(parent).build();
        return this.listDocuments(request);
    }

    public final ListDocumentsPagedResponse listDocuments(ListDocumentsRequest request) {
        return (ListDocumentsPagedResponse)((Object)this.listDocumentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.stub.listDocumentsPagedCallable();
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.stub.listDocumentsCallable();
    }

    public final Document createDocument(BranchName parent, Document document, String documentId) {
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDocument(document).setDocumentId(documentId).build();
        return this.createDocument(request);
    }

    public final Document createDocument(String parent, Document document, String documentId) {
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent(parent).setDocument(document).setDocumentId(documentId).build();
        return this.createDocument(request);
    }

    public final Document createDocument(CreateDocumentRequest request) {
        return (Document)this.createDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.stub.createDocumentCallable();
    }

    public final Document updateDocument(UpdateDocumentRequest request) {
        return (Document)this.updateDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.stub.updateDocumentCallable();
    }

    public final void deleteDocument(DocumentName name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDocument(request);
    }

    public final void deleteDocument(String name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name).build();
        this.deleteDocument(request);
    }

    public final void deleteDocument(DeleteDocumentRequest request) {
        this.deleteDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.stub.deleteDocumentCallable();
    }

    public final OperationFuture<ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsAsync(ImportDocumentsRequest request) {
        return this.importDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.stub.importDocumentsOperationCallable();
    }

    public final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.stub.importDocumentsCallable();
    }

    public final OperationFuture<PurgeDocumentsResponse, PurgeDocumentsMetadata> purgeDocumentsAsync(PurgeDocumentsRequest request) {
        return this.purgeDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeDocumentsRequest, PurgeDocumentsResponse, PurgeDocumentsMetadata> purgeDocumentsOperationCallable() {
        return this.stub.purgeDocumentsOperationCallable();
    }

    public final UnaryCallable<PurgeDocumentsRequest, Operation> purgeDocumentsCallable() {
        return this.stub.purgeDocumentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDocumentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        private ListDocumentsFixedSizeCollection(List<ListDocumentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDocumentsFixedSizeCollection createEmptyCollection() {
            return new ListDocumentsFixedSizeCollection(null, 0);
        }

        protected ListDocumentsFixedSizeCollection createCollection(List<ListDocumentsPage> pages, int collectionSize) {
            return new ListDocumentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDocumentsPage
    extends AbstractPage<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage> {
        private ListDocumentsPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ListDocumentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDocumentsPage createEmptyPage() {
            return new ListDocumentsPage(null, null);
        }

        protected ListDocumentsPage createPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ListDocumentsResponse response) {
            return new ListDocumentsPage(context, response);
        }

        public ApiFuture<ListDocumentsPage> createPageAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDocumentsPagedResponse
    extends AbstractPagedListResponse<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        public static ApiFuture<ListDocumentsPagedResponse> createAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            ApiFuture<ListDocumentsPage> futurePage = ListDocumentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDocumentsPagedResponse((ListDocumentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDocumentsPagedResponse(ListDocumentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDocumentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

