/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateGeneratorEvaluationRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteGeneratorEvaluationRequest;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluation;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluationOperationMetadata;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluationsClient;
import com.google.cloud.dialogflow.v2beta1.GetGeneratorEvaluationRequest;
import com.google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsRequest;
import com.google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsResponse;
import com.google.cloud.dialogflow.v2beta1.stub.GeneratorEvaluationsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcGeneratorEvaluationsStub;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonGeneratorEvaluationsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class GeneratorEvaluationsStubSettings
extends StubSettings<GeneratorEvaluationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateGeneratorEvaluationRequest, Operation> createGeneratorEvaluationSettings;
    private final OperationCallSettings<CreateGeneratorEvaluationRequest, GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationOperationSettings;
    private final UnaryCallSettings<GetGeneratorEvaluationRequest, GeneratorEvaluation> getGeneratorEvaluationSettings;
    private final PagedCallSettings<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse> listGeneratorEvaluationsSettings;
    private final UnaryCallSettings<DeleteGeneratorEvaluationRequest, Empty> deleteGeneratorEvaluationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, GeneratorEvaluationsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation> LIST_GENERATOR_EVALUATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation>(){

        public String emptyToken() {
            return "";
        }

        public ListGeneratorEvaluationsRequest injectToken(ListGeneratorEvaluationsRequest payload, String token) {
            return ListGeneratorEvaluationsRequest.newBuilder((ListGeneratorEvaluationsRequest)payload).setPageToken(token).build();
        }

        public ListGeneratorEvaluationsRequest injectPageSize(ListGeneratorEvaluationsRequest payload, int pageSize) {
            return ListGeneratorEvaluationsRequest.newBuilder((ListGeneratorEvaluationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGeneratorEvaluationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGeneratorEvaluationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GeneratorEvaluation> extractResources(ListGeneratorEvaluationsResponse payload) {
            return payload.getGeneratorEvaluationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse> LIST_GENERATOR_EVALUATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse>(){

        public ApiFuture<GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse> callable, ListGeneratorEvaluationsRequest request, ApiCallContext context, ApiFuture<ListGeneratorEvaluationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GENERATOR_EVALUATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse.createAsync((PageContext<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, GeneratorEvaluationsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, GeneratorEvaluationsClient.ListLocationsPagedResponse>(){

        public ApiFuture<GeneratorEvaluationsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GeneratorEvaluationsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateGeneratorEvaluationRequest, Operation> createGeneratorEvaluationSettings() {
        return this.createGeneratorEvaluationSettings;
    }

    public OperationCallSettings<CreateGeneratorEvaluationRequest, GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationOperationSettings() {
        return this.createGeneratorEvaluationOperationSettings;
    }

    public UnaryCallSettings<GetGeneratorEvaluationRequest, GeneratorEvaluation> getGeneratorEvaluationSettings() {
        return this.getGeneratorEvaluationSettings;
    }

    public PagedCallSettings<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse> listGeneratorEvaluationsSettings() {
        return this.listGeneratorEvaluationsSettings;
    }

    public UnaryCallSettings<DeleteGeneratorEvaluationRequest, Empty> deleteGeneratorEvaluationSettings() {
        return this.deleteGeneratorEvaluationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, GeneratorEvaluationsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public GeneratorEvaluationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGeneratorEvaluationsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGeneratorEvaluationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GeneratorEvaluationsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GeneratorEvaluationsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GeneratorEvaluationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GeneratorEvaluationsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GeneratorEvaluationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createGeneratorEvaluationSettings = settingsBuilder.createGeneratorEvaluationSettings().build();
        this.createGeneratorEvaluationOperationSettings = settingsBuilder.createGeneratorEvaluationOperationSettings().build();
        this.getGeneratorEvaluationSettings = settingsBuilder.getGeneratorEvaluationSettings().build();
        this.listGeneratorEvaluationsSettings = settingsBuilder.listGeneratorEvaluationsSettings().build();
        this.deleteGeneratorEvaluationSettings = settingsBuilder.deleteGeneratorEvaluationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GeneratorEvaluationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateGeneratorEvaluationRequest, Operation> createGeneratorEvaluationSettings;
        private final OperationCallSettings.Builder<CreateGeneratorEvaluationRequest, GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationOperationSettings;
        private final UnaryCallSettings.Builder<GetGeneratorEvaluationRequest, GeneratorEvaluation> getGeneratorEvaluationSettings;
        private final PagedCallSettings.Builder<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse> listGeneratorEvaluationsSettings;
        private final UnaryCallSettings.Builder<DeleteGeneratorEvaluationRequest, Empty> deleteGeneratorEvaluationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, GeneratorEvaluationsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createGeneratorEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGeneratorEvaluationOperationSettings = OperationCallSettings.newBuilder();
            this.getGeneratorEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGeneratorEvaluationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GENERATOR_EVALUATIONS_PAGE_STR_FACT);
            this.deleteGeneratorEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createGeneratorEvaluationSettings, this.getGeneratorEvaluationSettings, this.listGeneratorEvaluationsSettings, this.deleteGeneratorEvaluationSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GeneratorEvaluationsStubSettings settings) {
            super((StubSettings)settings);
            this.createGeneratorEvaluationSettings = settings.createGeneratorEvaluationSettings.toBuilder();
            this.createGeneratorEvaluationOperationSettings = settings.createGeneratorEvaluationOperationSettings.toBuilder();
            this.getGeneratorEvaluationSettings = settings.getGeneratorEvaluationSettings.toBuilder();
            this.listGeneratorEvaluationsSettings = settings.listGeneratorEvaluationsSettings.toBuilder();
            this.deleteGeneratorEvaluationSettings = settings.deleteGeneratorEvaluationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createGeneratorEvaluationSettings, this.getGeneratorEvaluationSettings, this.listGeneratorEvaluationsSettings, this.deleteGeneratorEvaluationSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GeneratorEvaluationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GeneratorEvaluationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GeneratorEvaluationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GeneratorEvaluationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GeneratorEvaluationsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GeneratorEvaluationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GeneratorEvaluationsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GeneratorEvaluationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createGeneratorEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGeneratorEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listGeneratorEvaluationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteGeneratorEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGeneratorEvaluationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GeneratorEvaluation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(GeneratorEvaluationOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateGeneratorEvaluationRequest, Operation> createGeneratorEvaluationSettings() {
            return this.createGeneratorEvaluationSettings;
        }

        public OperationCallSettings.Builder<CreateGeneratorEvaluationRequest, GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationOperationSettings() {
            return this.createGeneratorEvaluationOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGeneratorEvaluationRequest, GeneratorEvaluation> getGeneratorEvaluationSettings() {
            return this.getGeneratorEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluationsClient.ListGeneratorEvaluationsPagedResponse> listGeneratorEvaluationsSettings() {
            return this.listGeneratorEvaluationsSettings;
        }

        public UnaryCallSettings.Builder<DeleteGeneratorEvaluationRequest, Empty> deleteGeneratorEvaluationSettings() {
            return this.deleteGeneratorEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, GeneratorEvaluationsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public GeneratorEvaluationsStubSettings build() throws IOException {
            return new GeneratorEvaluationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

