/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.BatchCreateMessagesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchCreateMessagesResponse;
import com.google.cloud.dialogflow.v2beta1.CompleteConversationRequest;
import com.google.cloud.dialogflow.v2beta1.Conversation;
import com.google.cloud.dialogflow.v2beta1.ConversationName;
import com.google.cloud.dialogflow.v2beta1.ConversationsSettings;
import com.google.cloud.dialogflow.v2beta1.CreateConversationRequest;
import com.google.cloud.dialogflow.v2beta1.CreateMessageRequest;
import com.google.cloud.dialogflow.v2beta1.GenerateStatelessSuggestionRequest;
import com.google.cloud.dialogflow.v2beta1.GenerateStatelessSuggestionResponse;
import com.google.cloud.dialogflow.v2beta1.GenerateStatelessSummaryRequest;
import com.google.cloud.dialogflow.v2beta1.GenerateStatelessSummaryResponse;
import com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest;
import com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse;
import com.google.cloud.dialogflow.v2beta1.GetConversationRequest;
import com.google.cloud.dialogflow.v2beta1.IngestContextReferencesRequest;
import com.google.cloud.dialogflow.v2beta1.IngestContextReferencesResponse;
import com.google.cloud.dialogflow.v2beta1.ListConversationsRequest;
import com.google.cloud.dialogflow.v2beta1.ListConversationsResponse;
import com.google.cloud.dialogflow.v2beta1.ListMessagesRequest;
import com.google.cloud.dialogflow.v2beta1.ListMessagesResponse;
import com.google.cloud.dialogflow.v2beta1.LocationName;
import com.google.cloud.dialogflow.v2beta1.Message;
import com.google.cloud.dialogflow.v2beta1.ProjectName;
import com.google.cloud.dialogflow.v2beta1.SearchKnowledgeRequest;
import com.google.cloud.dialogflow.v2beta1.SearchKnowledgeResponse;
import com.google.cloud.dialogflow.v2beta1.SuggestConversationSummaryRequest;
import com.google.cloud.dialogflow.v2beta1.SuggestConversationSummaryResponse;
import com.google.cloud.dialogflow.v2beta1.stub.ConversationsStub;
import com.google.cloud.dialogflow.v2beta1.stub.ConversationsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConversationsClient
implements BackgroundResource {
    private final ConversationsSettings settings;
    private final ConversationsStub stub;

    public static final ConversationsClient create() throws IOException {
        return ConversationsClient.create(ConversationsSettings.newBuilder().build());
    }

    public static final ConversationsClient create(ConversationsSettings settings) throws IOException {
        return new ConversationsClient(settings);
    }

    public static final ConversationsClient create(ConversationsStub stub) {
        return new ConversationsClient(stub);
    }

    protected ConversationsClient(ConversationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConversationsClient(ConversationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversationsSettings getSettings() {
        return this.settings;
    }

    public ConversationsStub getStub() {
        return this.stub;
    }

    public final Conversation createConversation(LocationName parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(ProjectName parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(String parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(CreateConversationRequest request) {
        return (Conversation)this.createConversationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.stub.createConversationCallable();
    }

    public final ListConversationsPagedResponse listConversations(LocationName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ProjectName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(String parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ListConversationsRequest request) {
        return (ListConversationsPagedResponse)((Object)this.listConversationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.stub.listConversationsPagedCallable();
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.stub.listConversationsCallable();
    }

    public final Conversation getConversation(ConversationName name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(String name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(GetConversationRequest request) {
        return (Conversation)this.getConversationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.stub.getConversationCallable();
    }

    public final Conversation completeConversation(ConversationName name) {
        CompleteConversationRequest request = CompleteConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.completeConversation(request);
    }

    public final Conversation completeConversation(String name) {
        CompleteConversationRequest request = CompleteConversationRequest.newBuilder().setName(name).build();
        return this.completeConversation(request);
    }

    public final Conversation completeConversation(CompleteConversationRequest request) {
        return (Conversation)this.completeConversationCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable() {
        return this.stub.completeConversationCallable();
    }

    public final IngestContextReferencesResponse ingestContextReferences(ConversationName conversation, Map<String, Conversation.ContextReference> contextReferences) {
        IngestContextReferencesRequest request = IngestContextReferencesRequest.newBuilder().setConversation(conversation == null ? null : conversation.toString()).putAllContextReferences(contextReferences).build();
        return this.ingestContextReferences(request);
    }

    public final IngestContextReferencesResponse ingestContextReferences(String conversation, Map<String, Conversation.ContextReference> contextReferences) {
        IngestContextReferencesRequest request = IngestContextReferencesRequest.newBuilder().setConversation(conversation).putAllContextReferences(contextReferences).build();
        return this.ingestContextReferences(request);
    }

    public final IngestContextReferencesResponse ingestContextReferences(IngestContextReferencesRequest request) {
        return (IngestContextReferencesResponse)this.ingestContextReferencesCallable().call((Object)request);
    }

    public final UnaryCallable<IngestContextReferencesRequest, IngestContextReferencesResponse> ingestContextReferencesCallable() {
        return this.stub.ingestContextReferencesCallable();
    }

    public final BatchCreateMessagesResponse batchCreateMessages(ConversationName parent, List<CreateMessageRequest> requests) {
        BatchCreateMessagesRequest request = BatchCreateMessagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateMessages(request);
    }

    public final BatchCreateMessagesResponse batchCreateMessages(String parent, List<CreateMessageRequest> requests) {
        BatchCreateMessagesRequest request = BatchCreateMessagesRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateMessages(request);
    }

    public final BatchCreateMessagesResponse batchCreateMessages(BatchCreateMessagesRequest request) {
        return (BatchCreateMessagesResponse)this.batchCreateMessagesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateMessagesRequest, BatchCreateMessagesResponse> batchCreateMessagesCallable() {
        return this.stub.batchCreateMessagesCallable();
    }

    public final ListMessagesPagedResponse listMessages(ConversationName parent) {
        ListMessagesRequest request = ListMessagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMessages(request);
    }

    public final ListMessagesPagedResponse listMessages(String parent) {
        ListMessagesRequest request = ListMessagesRequest.newBuilder().setParent(parent).build();
        return this.listMessages(request);
    }

    public final ListMessagesPagedResponse listMessages(ListMessagesRequest request) {
        return (ListMessagesPagedResponse)((Object)this.listMessagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMessagesRequest, ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.stub.listMessagesPagedCallable();
    }

    public final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.stub.listMessagesCallable();
    }

    public final SuggestConversationSummaryResponse suggestConversationSummary(ConversationName conversation) {
        SuggestConversationSummaryRequest request = SuggestConversationSummaryRequest.newBuilder().setConversation(conversation == null ? null : conversation.toString()).build();
        return this.suggestConversationSummary(request);
    }

    public final SuggestConversationSummaryResponse suggestConversationSummary(String conversation) {
        SuggestConversationSummaryRequest request = SuggestConversationSummaryRequest.newBuilder().setConversation(conversation).build();
        return this.suggestConversationSummary(request);
    }

    public final SuggestConversationSummaryResponse suggestConversationSummary(SuggestConversationSummaryRequest request) {
        return (SuggestConversationSummaryResponse)this.suggestConversationSummaryCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummaryCallable() {
        return this.stub.suggestConversationSummaryCallable();
    }

    public final GenerateStatelessSummaryResponse generateStatelessSummary(GenerateStatelessSummaryRequest request) {
        return (GenerateStatelessSummaryResponse)this.generateStatelessSummaryCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummaryCallable() {
        return this.stub.generateStatelessSummaryCallable();
    }

    public final GenerateStatelessSuggestionResponse generateStatelessSuggestion(GenerateStatelessSuggestionRequest request) {
        return (GenerateStatelessSuggestionResponse)this.generateStatelessSuggestionCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateStatelessSuggestionRequest, GenerateStatelessSuggestionResponse> generateStatelessSuggestionCallable() {
        return this.stub.generateStatelessSuggestionCallable();
    }

    public final SearchKnowledgeResponse searchKnowledge(SearchKnowledgeRequest request) {
        return (SearchKnowledgeResponse)this.searchKnowledgeCallable().call((Object)request);
    }

    public final UnaryCallable<SearchKnowledgeRequest, SearchKnowledgeResponse> searchKnowledgeCallable() {
        return this.stub.searchKnowledgeCallable();
    }

    public final GenerateSuggestionsResponse generateSuggestions(ConversationName conversation) {
        GenerateSuggestionsRequest request = GenerateSuggestionsRequest.newBuilder().setConversation(conversation == null ? null : conversation.toString()).build();
        return this.generateSuggestions(request);
    }

    public final GenerateSuggestionsResponse generateSuggestions(String conversation) {
        GenerateSuggestionsRequest request = GenerateSuggestionsRequest.newBuilder().setConversation(conversation).build();
        return this.generateSuggestions(request);
    }

    public final GenerateSuggestionsResponse generateSuggestions(GenerateSuggestionsRequest request) {
        return (GenerateSuggestionsResponse)this.generateSuggestionsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateSuggestionsRequest, GenerateSuggestionsResponse> generateSuggestionsCallable() {
        return this.stub.generateSuggestionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMessagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMessagesRequest, ListMessagesResponse, Message, ListMessagesPage, ListMessagesFixedSizeCollection> {
        private ListMessagesFixedSizeCollection(List<ListMessagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMessagesFixedSizeCollection createEmptyCollection() {
            return new ListMessagesFixedSizeCollection(null, 0);
        }

        protected ListMessagesFixedSizeCollection createCollection(List<ListMessagesPage> pages, int collectionSize) {
            return new ListMessagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMessagesPage
    extends AbstractPage<ListMessagesRequest, ListMessagesResponse, Message, ListMessagesPage> {
        private ListMessagesPage(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ListMessagesResponse response) {
            super(context, (Object)response);
        }

        private static ListMessagesPage createEmptyPage() {
            return new ListMessagesPage(null, null);
        }

        protected ListMessagesPage createPage(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ListMessagesResponse response) {
            return new ListMessagesPage(context, response);
        }

        public ApiFuture<ListMessagesPage> createPageAsync(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ApiFuture<ListMessagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMessagesPagedResponse
    extends AbstractPagedListResponse<ListMessagesRequest, ListMessagesResponse, Message, ListMessagesPage, ListMessagesFixedSizeCollection> {
        public static ApiFuture<ListMessagesPagedResponse> createAsync(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ApiFuture<ListMessagesResponse> futureResponse) {
            ApiFuture<ListMessagesPage> futurePage = ListMessagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMessagesPagedResponse((ListMessagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMessagesPagedResponse(ListMessagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMessagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        private ListConversationsFixedSizeCollection(List<ListConversationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationsFixedSizeCollection(null, 0);
        }

        protected ListConversationsFixedSizeCollection createCollection(List<ListConversationsPage> pages, int collectionSize) {
            return new ListConversationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationsPage
    extends AbstractPage<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage> {
        private ListConversationsPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationsPage createEmptyPage() {
            return new ListConversationsPage(null, null);
        }

        protected ListConversationsPage createPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            return new ListConversationsPage(context, response);
        }

        public ApiFuture<ListConversationsPage> createPageAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationsPagedResponse
    extends AbstractPagedListResponse<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        public static ApiFuture<ListConversationsPagedResponse> createAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            ApiFuture<ListConversationsPage> futurePage = ListConversationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationsPagedResponse((ListConversationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationsPagedResponse(ListConversationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

