/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CompleteConversationRequest;
import com.google.cloud.dialogflow.v2.Conversation;
import com.google.cloud.dialogflow.v2.ConversationsClient;
import com.google.cloud.dialogflow.v2.CreateConversationRequest;
import com.google.cloud.dialogflow.v2.GetConversationRequest;
import com.google.cloud.dialogflow.v2.ListConversationsRequest;
import com.google.cloud.dialogflow.v2.ListConversationsResponse;
import com.google.cloud.dialogflow.v2.ListMessagesRequest;
import com.google.cloud.dialogflow.v2.ListMessagesResponse;
import com.google.cloud.dialogflow.v2.stub.ConversationsStub;
import com.google.cloud.dialogflow.v2.stub.ConversationsStubSettings;
import com.google.cloud.dialogflow.v2.stub.HttpJsonConversationsCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonConversationsStub
extends ConversationsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateConversationRequest, Conversation> createConversationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Conversations/CreateConversation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/conversations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/locations/*}/conversations"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "conversationId", (Object)request.getConversationId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("conversation", (Message)request.getConversation())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Conversation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListConversationsRequest, ListConversationsResponse> listConversationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Conversations/ListConversations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/conversations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/locations/*}/conversations"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConversationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetConversationRequest, Conversation> getConversationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Conversations/GetConversation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/conversations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/locations/*/conversations/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Conversation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CompleteConversationRequest, Conversation> completeConversationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Conversations/CompleteConversation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/conversations/*}:complete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/locations/*/conversations/*}:complete"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Conversation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListMessagesRequest, ListMessagesResponse> listMessagesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Conversations/ListMessages").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/conversations/*}/messages", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/locations/*/conversations/*}/messages"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListMessagesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable;
    private final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable;
    private final UnaryCallable<ListConversationsRequest, ConversationsClient.ListConversationsPagedResponse> listConversationsPagedCallable;
    private final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable;
    private final UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable;
    private final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable;
    private final UnaryCallable<ListMessagesRequest, ConversationsClient.ListMessagesPagedResponse> listMessagesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonConversationsStub create(ConversationsStubSettings settings) throws IOException {
        return new HttpJsonConversationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonConversationsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonConversationsStub(ConversationsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonConversationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonConversationsStub(ConversationsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonConversationsStub(ConversationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonConversationsCallableFactory());
    }

    protected HttpJsonConversationsStub(ConversationsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createConversationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConversationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listConversationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConversationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getConversationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConversationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings completeConversationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(completeConversationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listMessagesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMessagesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createConversationCallable = callableFactory.createUnaryCallable(createConversationTransportSettings, settings.createConversationSettings(), clientContext);
        this.listConversationsCallable = callableFactory.createUnaryCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listConversationsPagedCallable = callableFactory.createPagedCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.getConversationCallable = callableFactory.createUnaryCallable(getConversationTransportSettings, settings.getConversationSettings(), clientContext);
        this.completeConversationCallable = callableFactory.createUnaryCallable(completeConversationTransportSettings, settings.completeConversationSettings(), clientContext);
        this.listMessagesCallable = callableFactory.createUnaryCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listMessagesPagedCallable = callableFactory.createPagedCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createConversationMethodDescriptor);
        methodDescriptors.add(listConversationsMethodDescriptor);
        methodDescriptors.add(getConversationMethodDescriptor);
        methodDescriptors.add(completeConversationMethodDescriptor);
        methodDescriptors.add(listMessagesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.createConversationCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.listConversationsCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ConversationsClient.ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.listConversationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.getConversationCallable;
    }

    @Override
    public UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable() {
        return this.completeConversationCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.listMessagesCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ConversationsClient.ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.listMessagesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

