/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.EncryptionSpec;
import com.google.cloud.dialogflow.v2beta1.EncryptionSpecServiceClient;
import com.google.cloud.dialogflow.v2beta1.GetEncryptionSpecRequest;
import com.google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecMetadata;
import com.google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecRequest;
import com.google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecResponse;
import com.google.cloud.dialogflow.v2beta1.stub.EncryptionSpecServiceStub;
import com.google.cloud.dialogflow.v2beta1.stub.EncryptionSpecServiceStubSettings;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcEncryptionSpecServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcEncryptionSpecServiceStub
extends EncryptionSpecServiceStub {
    private static final MethodDescriptor<GetEncryptionSpecRequest, EncryptionSpec> getEncryptionSpecMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.EncryptionSpecService/GetEncryptionSpec").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEncryptionSpecRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EncryptionSpec.getDefaultInstance())).build();
    private static final MethodDescriptor<InitializeEncryptionSpecRequest, Operation> initializeEncryptionSpecMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.EncryptionSpecService/InitializeEncryptionSpec").setRequestMarshaller(ProtoUtils.marshaller((Message)InitializeEncryptionSpecRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<GetEncryptionSpecRequest, EncryptionSpec> getEncryptionSpecCallable;
    private final UnaryCallable<InitializeEncryptionSpecRequest, Operation> initializeEncryptionSpecCallable;
    private final OperationCallable<InitializeEncryptionSpecRequest, InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, EncryptionSpecServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEncryptionSpecServiceStub create(EncryptionSpecServiceStubSettings settings) throws IOException {
        return new GrpcEncryptionSpecServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEncryptionSpecServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEncryptionSpecServiceStub(EncryptionSpecServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEncryptionSpecServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEncryptionSpecServiceStub(EncryptionSpecServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEncryptionSpecServiceStub(EncryptionSpecServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEncryptionSpecServiceCallableFactory());
    }

    protected GrpcEncryptionSpecServiceStub(EncryptionSpecServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getEncryptionSpecTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEncryptionSpecMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings initializeEncryptionSpecTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(initializeEncryptionSpecMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("encryption_spec.name", String.valueOf(request.getEncryptionSpec().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getEncryptionSpecCallable = callableFactory.createUnaryCallable(getEncryptionSpecTransportSettings, settings.getEncryptionSpecSettings(), clientContext);
        this.initializeEncryptionSpecCallable = callableFactory.createUnaryCallable(initializeEncryptionSpecTransportSettings, settings.initializeEncryptionSpecSettings(), clientContext);
        this.initializeEncryptionSpecOperationCallable = callableFactory.createOperationCallable(initializeEncryptionSpecTransportSettings, settings.initializeEncryptionSpecOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetEncryptionSpecRequest, EncryptionSpec> getEncryptionSpecCallable() {
        return this.getEncryptionSpecCallable;
    }

    @Override
    public UnaryCallable<InitializeEncryptionSpecRequest, Operation> initializeEncryptionSpecCallable() {
        return this.initializeEncryptionSpecCallable;
    }

    @Override
    public OperationCallable<InitializeEncryptionSpecRequest, InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecOperationCallable() {
        return this.initializeEncryptionSpecOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, EncryptionSpecServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

