/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.AgentName;
import com.google.cloud.dialogflow.v2.BatchCreateEntitiesRequest;
import com.google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest;
import com.google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest;
import com.google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest;
import com.google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest;
import com.google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse;
import com.google.cloud.dialogflow.v2.CreateEntityTypeRequest;
import com.google.cloud.dialogflow.v2.DeleteEntityTypeRequest;
import com.google.cloud.dialogflow.v2.EntityType;
import com.google.cloud.dialogflow.v2.EntityTypeName;
import com.google.cloud.dialogflow.v2.EntityTypesSettings;
import com.google.cloud.dialogflow.v2.GetEntityTypeRequest;
import com.google.cloud.dialogflow.v2.ListEntityTypesRequest;
import com.google.cloud.dialogflow.v2.ListEntityTypesResponse;
import com.google.cloud.dialogflow.v2.UpdateEntityTypeRequest;
import com.google.cloud.dialogflow.v2.stub.EntityTypesStub;
import com.google.cloud.dialogflow.v2.stub.EntityTypesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EntityTypesClient
implements BackgroundResource {
    private final EntityTypesSettings settings;
    private final EntityTypesStub stub;
    private final OperationsClient operationsClient;

    public static final EntityTypesClient create() throws IOException {
        return EntityTypesClient.create(EntityTypesSettings.newBuilder().build());
    }

    public static final EntityTypesClient create(EntityTypesSettings settings) throws IOException {
        return new EntityTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EntityTypesClient create(EntityTypesStub stub) {
        return new EntityTypesClient(stub);
    }

    protected EntityTypesClient(EntityTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EntityTypesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EntityTypesClient(EntityTypesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final EntityTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EntityTypesStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListEntityTypesPagedResponse listEntityTypes(AgentName parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(String parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(AgentName parent, String languageCode) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLanguageCode(languageCode).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(String parent, String languageCode) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent).setLanguageCode(languageCode).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(ListEntityTypesRequest request) {
        return (ListEntityTypesPagedResponse)((Object)this.listEntityTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesPagedResponse> listEntityTypesPagedCallable() {
        return this.stub.listEntityTypesPagedCallable();
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> listEntityTypesCallable() {
        return this.stub.listEntityTypesCallable();
    }

    public final EntityType getEntityType(EntityTypeName name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(String name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(EntityTypeName name, String languageCode) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).setLanguageCode(languageCode).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(String name, String languageCode) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name).setLanguageCode(languageCode).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(GetEntityTypeRequest request) {
        return (EntityType)this.getEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntityTypeRequest, EntityType> getEntityTypeCallable() {
        return this.stub.getEntityTypeCallable();
    }

    public final EntityType createEntityType(AgentName parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntityType(entityType).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(String parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent).setEntityType(entityType).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(AgentName parent, EntityType entityType, String languageCode) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntityType(entityType).setLanguageCode(languageCode).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(String parent, EntityType entityType, String languageCode) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent).setEntityType(entityType).setLanguageCode(languageCode).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(CreateEntityTypeRequest request) {
        return (EntityType)this.createEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntityTypeRequest, EntityType> createEntityTypeCallable() {
        return this.stub.createEntityTypeCallable();
    }

    public final EntityType updateEntityType(EntityType entityType) {
        UpdateEntityTypeRequest request = UpdateEntityTypeRequest.newBuilder().setEntityType(entityType).build();
        return this.updateEntityType(request);
    }

    public final EntityType updateEntityType(EntityType entityType, String languageCode) {
        UpdateEntityTypeRequest request = UpdateEntityTypeRequest.newBuilder().setEntityType(entityType).setLanguageCode(languageCode).build();
        return this.updateEntityType(request);
    }

    public final EntityType updateEntityType(UpdateEntityTypeRequest request) {
        return (EntityType)this.updateEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntityTypeRequest, EntityType> updateEntityTypeCallable() {
        return this.stub.updateEntityTypeCallable();
    }

    public final void deleteEntityType(EntityTypeName name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEntityType(request);
    }

    public final void deleteEntityType(String name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name).build();
        this.deleteEntityType(request);
    }

    public final void deleteEntityType(DeleteEntityTypeRequest request) {
        this.deleteEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntityTypeRequest, Empty> deleteEntityTypeCallable() {
        return this.stub.deleteEntityTypeCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesAsync(BatchUpdateEntityTypesRequest request) {
        return this.batchUpdateEntityTypesOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchUpdateEntityTypesRequest, BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesOperationCallable() {
        return this.stub.batchUpdateEntityTypesOperationCallable();
    }

    public final UnaryCallable<BatchUpdateEntityTypesRequest, Operation> batchUpdateEntityTypesCallable() {
        return this.stub.batchUpdateEntityTypesCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntityTypesAsync(AgentName parent, List<String> entityTypeNames) {
        BatchDeleteEntityTypesRequest request = BatchDeleteEntityTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntityTypeNames(entityTypeNames).build();
        return this.batchDeleteEntityTypesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntityTypesAsync(String parent, List<String> entityTypeNames) {
        BatchDeleteEntityTypesRequest request = BatchDeleteEntityTypesRequest.newBuilder().setParent(parent).addAllEntityTypeNames(entityTypeNames).build();
        return this.batchDeleteEntityTypesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntityTypesAsync(BatchDeleteEntityTypesRequest request) {
        return this.batchDeleteEntityTypesOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchDeleteEntityTypesRequest, Empty, Struct> batchDeleteEntityTypesOperationCallable() {
        return this.stub.batchDeleteEntityTypesOperationCallable();
    }

    public final UnaryCallable<BatchDeleteEntityTypesRequest, Operation> batchDeleteEntityTypesCallable() {
        return this.stub.batchDeleteEntityTypesCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities) {
        BatchCreateEntitiesRequest request = BatchCreateEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntities(entities).build();
        return this.batchCreateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(String parent, List<EntityType.Entity> entities) {
        BatchCreateEntitiesRequest request = BatchCreateEntitiesRequest.newBuilder().setParent(parent).addAllEntities(entities).build();
        return this.batchCreateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities, String languageCode) {
        BatchCreateEntitiesRequest request = BatchCreateEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntities(entities).setLanguageCode(languageCode).build();
        return this.batchCreateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(String parent, List<EntityType.Entity> entities, String languageCode) {
        BatchCreateEntitiesRequest request = BatchCreateEntitiesRequest.newBuilder().setParent(parent).addAllEntities(entities).setLanguageCode(languageCode).build();
        return this.batchCreateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(BatchCreateEntitiesRequest request) {
        return this.batchCreateEntitiesOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchCreateEntitiesRequest, Empty, Struct> batchCreateEntitiesOperationCallable() {
        return this.stub.batchCreateEntitiesOperationCallable();
    }

    public final UnaryCallable<BatchCreateEntitiesRequest, Operation> batchCreateEntitiesCallable() {
        return this.stub.batchCreateEntitiesCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities) {
        BatchUpdateEntitiesRequest request = BatchUpdateEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntities(entities).build();
        return this.batchUpdateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(String parent, List<EntityType.Entity> entities) {
        BatchUpdateEntitiesRequest request = BatchUpdateEntitiesRequest.newBuilder().setParent(parent).addAllEntities(entities).build();
        return this.batchUpdateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities, String languageCode) {
        BatchUpdateEntitiesRequest request = BatchUpdateEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntities(entities).setLanguageCode(languageCode).build();
        return this.batchUpdateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(String parent, List<EntityType.Entity> entities, String languageCode) {
        BatchUpdateEntitiesRequest request = BatchUpdateEntitiesRequest.newBuilder().setParent(parent).addAllEntities(entities).setLanguageCode(languageCode).build();
        return this.batchUpdateEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(BatchUpdateEntitiesRequest request) {
        return this.batchUpdateEntitiesOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchUpdateEntitiesRequest, Empty, Struct> batchUpdateEntitiesOperationCallable() {
        return this.stub.batchUpdateEntitiesOperationCallable();
    }

    public final UnaryCallable<BatchUpdateEntitiesRequest, Operation> batchUpdateEntitiesCallable() {
        return this.stub.batchUpdateEntitiesCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(EntityTypeName parent, List<String> entityValues) {
        BatchDeleteEntitiesRequest request = BatchDeleteEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntityValues(entityValues).build();
        return this.batchDeleteEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(String parent, List<String> entityValues) {
        BatchDeleteEntitiesRequest request = BatchDeleteEntitiesRequest.newBuilder().setParent(parent).addAllEntityValues(entityValues).build();
        return this.batchDeleteEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(EntityTypeName parent, List<String> entityValues, String languageCode) {
        BatchDeleteEntitiesRequest request = BatchDeleteEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEntityValues(entityValues).setLanguageCode(languageCode).build();
        return this.batchDeleteEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(String parent, List<String> entityValues, String languageCode) {
        BatchDeleteEntitiesRequest request = BatchDeleteEntitiesRequest.newBuilder().setParent(parent).addAllEntityValues(entityValues).setLanguageCode(languageCode).build();
        return this.batchDeleteEntitiesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(BatchDeleteEntitiesRequest request) {
        return this.batchDeleteEntitiesOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchDeleteEntitiesRequest, Empty, Struct> batchDeleteEntitiesOperationCallable() {
        return this.stub.batchDeleteEntitiesOperationCallable();
    }

    public final UnaryCallable<BatchDeleteEntitiesRequest, Operation> batchDeleteEntitiesCallable() {
        return this.stub.batchDeleteEntitiesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEntityTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage, ListEntityTypesFixedSizeCollection> {
        private ListEntityTypesFixedSizeCollection(List<ListEntityTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntityTypesFixedSizeCollection createEmptyCollection() {
            return new ListEntityTypesFixedSizeCollection(null, 0);
        }

        protected ListEntityTypesFixedSizeCollection createCollection(List<ListEntityTypesPage> pages, int collectionSize) {
            return new ListEntityTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntityTypesPage
    extends AbstractPage<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage> {
        private ListEntityTypesPage(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ListEntityTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntityTypesPage createEmptyPage() {
            return new ListEntityTypesPage(null, null);
        }

        protected ListEntityTypesPage createPage(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ListEntityTypesResponse response) {
            return new ListEntityTypesPage(context, response);
        }

        public ApiFuture<ListEntityTypesPage> createPageAsync(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntityTypesPagedResponse
    extends AbstractPagedListResponse<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage, ListEntityTypesFixedSizeCollection> {
        public static ApiFuture<ListEntityTypesPagedResponse> createAsync(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            ApiFuture<ListEntityTypesPage> futurePage = ListEntityTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListEntityTypesPage, ListEntityTypesPagedResponse>(){

                public ListEntityTypesPagedResponse apply(ListEntityTypesPage input) {
                    return new ListEntityTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListEntityTypesPagedResponse(ListEntityTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntityTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

