/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.DetectIntentRequest;
import com.google.cloud.dialogflow.v2beta1.DetectIntentResponse;
import com.google.cloud.dialogflow.v2beta1.QueryInput;
import com.google.cloud.dialogflow.v2beta1.SessionName;
import com.google.cloud.dialogflow.v2beta1.SessionsSettings;
import com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest;
import com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse;
import com.google.cloud.dialogflow.v2beta1.stub.SessionsStub;
import com.google.cloud.dialogflow.v2beta1.stub.SessionsStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SessionsClient
implements BackgroundResource {
    private final SessionsSettings settings;
    private final SessionsStub stub;

    public static final SessionsClient create() throws IOException {
        return SessionsClient.create(SessionsSettings.newBuilder().build());
    }

    public static final SessionsClient create(SessionsSettings settings) throws IOException {
        return new SessionsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SessionsClient create(SessionsStub stub) {
        return new SessionsClient(stub);
    }

    protected SessionsClient(SessionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SessionsClient(SessionsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SessionsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SessionsStub getStub() {
        return this.stub;
    }

    public final DetectIntentResponse detectIntent(SessionName session, QueryInput queryInput) {
        DetectIntentRequest request = DetectIntentRequest.newBuilder().setSession(session == null ? null : session.toString()).setQueryInput(queryInput).build();
        return this.detectIntent(request);
    }

    public final DetectIntentResponse detectIntent(String session, QueryInput queryInput) {
        DetectIntentRequest request = DetectIntentRequest.newBuilder().setSession(session).setQueryInput(queryInput).build();
        return this.detectIntent(request);
    }

    public final DetectIntentResponse detectIntent(DetectIntentRequest request) {
        return (DetectIntentResponse)this.detectIntentCallable().call((Object)request);
    }

    public final UnaryCallable<DetectIntentRequest, DetectIntentResponse> detectIntentCallable() {
        return this.stub.detectIntentCallable();
    }

    public final BidiStreamingCallable<StreamingDetectIntentRequest, StreamingDetectIntentResponse> streamingDetectIntentCallable() {
        return this.stub.streamingDetectIntentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

