/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.GetSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.ListSessionEntityTypesRequest;
import com.google.cloud.dialogflow.v2.ListSessionEntityTypesResponse;
import com.google.cloud.dialogflow.v2.SessionEntityType;
import com.google.cloud.dialogflow.v2.SessionEntityTypeName;
import com.google.cloud.dialogflow.v2.SessionEntityTypesSettings;
import com.google.cloud.dialogflow.v2.SessionName;
import com.google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.stub.SessionEntityTypesStub;
import com.google.cloud.dialogflow.v2.stub.SessionEntityTypesStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SessionEntityTypesClient
implements BackgroundResource {
    private final SessionEntityTypesSettings settings;
    private final SessionEntityTypesStub stub;

    public static final SessionEntityTypesClient create() throws IOException {
        return SessionEntityTypesClient.create(SessionEntityTypesSettings.newBuilder().build());
    }

    public static final SessionEntityTypesClient create(SessionEntityTypesSettings settings) throws IOException {
        return new SessionEntityTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SessionEntityTypesClient create(SessionEntityTypesStub stub) {
        return new SessionEntityTypesClient(stub);
    }

    protected SessionEntityTypesClient(SessionEntityTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionEntityTypesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SessionEntityTypesClient(SessionEntityTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SessionEntityTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SessionEntityTypesStub getStub() {
        return this.stub;
    }

    public final ListSessionEntityTypesPagedResponse listSessionEntityTypes(SessionName parent) {
        ListSessionEntityTypesRequest request = ListSessionEntityTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessionEntityTypes(request);
    }

    public final ListSessionEntityTypesPagedResponse listSessionEntityTypes(String parent) {
        ListSessionEntityTypesRequest request = ListSessionEntityTypesRequest.newBuilder().setParent(parent).build();
        return this.listSessionEntityTypes(request);
    }

    public final ListSessionEntityTypesPagedResponse listSessionEntityTypes(ListSessionEntityTypesRequest request) {
        return (ListSessionEntityTypesPagedResponse)((Object)this.listSessionEntityTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionEntityTypesRequest, ListSessionEntityTypesPagedResponse> listSessionEntityTypesPagedCallable() {
        return this.stub.listSessionEntityTypesPagedCallable();
    }

    public final UnaryCallable<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse> listSessionEntityTypesCallable() {
        return this.stub.listSessionEntityTypesCallable();
    }

    public final SessionEntityType getSessionEntityType(SessionEntityTypeName name) {
        GetSessionEntityTypeRequest request = GetSessionEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSessionEntityType(request);
    }

    public final SessionEntityType getSessionEntityType(String name) {
        GetSessionEntityTypeRequest request = GetSessionEntityTypeRequest.newBuilder().setName(name).build();
        return this.getSessionEntityType(request);
    }

    private final SessionEntityType getSessionEntityType(GetSessionEntityTypeRequest request) {
        return (SessionEntityType)this.getSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeCallable() {
        return this.stub.getSessionEntityTypeCallable();
    }

    public final SessionEntityType createSessionEntityType(SessionName parent, SessionEntityType sessionEntityType) {
        CreateSessionEntityTypeRequest request = CreateSessionEntityTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSessionEntityType(sessionEntityType).build();
        return this.createSessionEntityType(request);
    }

    public final SessionEntityType createSessionEntityType(String parent, SessionEntityType sessionEntityType) {
        CreateSessionEntityTypeRequest request = CreateSessionEntityTypeRequest.newBuilder().setParent(parent).setSessionEntityType(sessionEntityType).build();
        return this.createSessionEntityType(request);
    }

    public final SessionEntityType createSessionEntityType(CreateSessionEntityTypeRequest request) {
        return (SessionEntityType)this.createSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeCallable() {
        return this.stub.createSessionEntityTypeCallable();
    }

    public final SessionEntityType updateSessionEntityType(SessionEntityType sessionEntityType) {
        UpdateSessionEntityTypeRequest request = UpdateSessionEntityTypeRequest.newBuilder().setSessionEntityType(sessionEntityType).build();
        return this.updateSessionEntityType(request);
    }

    public final SessionEntityType updateSessionEntityType(UpdateSessionEntityTypeRequest request) {
        return (SessionEntityType)this.updateSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeCallable() {
        return this.stub.updateSessionEntityTypeCallable();
    }

    public final void deleteSessionEntityType(SessionEntityTypeName name) {
        DeleteSessionEntityTypeRequest request = DeleteSessionEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSessionEntityType(request);
    }

    public final void deleteSessionEntityType(String name) {
        DeleteSessionEntityTypeRequest request = DeleteSessionEntityTypeRequest.newBuilder().setName(name).build();
        this.deleteSessionEntityType(request);
    }

    private final void deleteSessionEntityType(DeleteSessionEntityTypeRequest request) {
        this.deleteSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeCallable() {
        return this.stub.deleteSessionEntityTypeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionEntityTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType, ListSessionEntityTypesPage, ListSessionEntityTypesFixedSizeCollection> {
        private ListSessionEntityTypesFixedSizeCollection(List<ListSessionEntityTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionEntityTypesFixedSizeCollection createEmptyCollection() {
            return new ListSessionEntityTypesFixedSizeCollection(null, 0);
        }

        protected ListSessionEntityTypesFixedSizeCollection createCollection(List<ListSessionEntityTypesPage> pages, int collectionSize) {
            return new ListSessionEntityTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionEntityTypesPage
    extends AbstractPage<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType, ListSessionEntityTypesPage> {
        private ListSessionEntityTypesPage(PageContext<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType> context, ListSessionEntityTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionEntityTypesPage createEmptyPage() {
            return new ListSessionEntityTypesPage(null, null);
        }

        protected ListSessionEntityTypesPage createPage(PageContext<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType> context, ListSessionEntityTypesResponse response) {
            return new ListSessionEntityTypesPage(context, response);
        }

        public ApiFuture<ListSessionEntityTypesPage> createPageAsync(PageContext<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType> context, ApiFuture<ListSessionEntityTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionEntityTypesPagedResponse
    extends AbstractPagedListResponse<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType, ListSessionEntityTypesPage, ListSessionEntityTypesFixedSizeCollection> {
        public static ApiFuture<ListSessionEntityTypesPagedResponse> createAsync(PageContext<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType> context, ApiFuture<ListSessionEntityTypesResponse> futureResponse) {
            ApiFuture<ListSessionEntityTypesPage> futurePage = ListSessionEntityTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSessionEntityTypesPage, ListSessionEntityTypesPagedResponse>(){

                public ListSessionEntityTypesPagedResponse apply(ListSessionEntityTypesPage input) {
                    return new ListSessionEntityTypesPagedResponse(input);
                }
            });
        }

        private ListSessionEntityTypesPagedResponse(ListSessionEntityTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionEntityTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

